/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.converter.ConversionException;
import io.polaris.core.io.IO;
import io.polaris.core.lang.JavaType;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.util.TimeZone;

public class StringConverter
extends AbstractSimpleConverter<String> {
    private final JavaType<String> targetType = JavaType.of(String.class);

    @Override
    public JavaType<String> getTargetType() {
        return this.targetType;
    }

    @Override
    protected String doConvert(Object value, JavaType<String> targetType) {
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        if (value instanceof Clob) {
            return StringConverter.clobToStr((Clob)value);
        }
        if (value instanceof Blob) {
            return StringConverter.blobToStr((Blob)value);
        }
        if (value instanceof Type) {
            return ((Type)value).getTypeName();
        }
        return this.asString(value);
    }

    private static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            String string = IO.toString(reader);
            return string;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
        finally {
            IO.close(reader);
        }
    }

    private static String blobToStr(Blob blob) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            String string = IO.toString(in, StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
        finally {
            IO.close(in);
        }
    }
}

