/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto;

import io.polaris.core.service.Service;
import io.polaris.core.service.ServiceLoader;
import java.security.Provider;
import java.security.Security;
import org.slf4j.LoggerFactory;

public interface ICryptoProviderLoader {
    public Provider provider();

    default public int position() {
        return Integer.MAX_VALUE;
    }

    public static void loadProviders() {
        try {
            ServiceLoader<ICryptoProviderLoader> serviceLoader = ServiceLoader.of(ICryptoProviderLoader.class);
            for (Service<ICryptoProviderLoader> service : serviceLoader) {
                try {
                    ICryptoProviderLoader providerLoader = service.getSingleton();
                    Security.insertProviderAt(providerLoader.provider(), providerLoader.position());
                }
                catch (Throwable e) {
                    LoggerFactory.getLogger(ICryptoProviderLoader.class).error("", e);
                }
            }
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(ICryptoProviderLoader.class).error("", e);
        }
    }
}

