/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.otp;

import io.polaris.core.crypto.otp.OtpHmacHashAlgorithm;
import java.util.concurrent.TimeUnit;

public class GoogleAuthenticatorConfig {
    private long timeStepSizeInMillis = TimeUnit.SECONDS.toMillis(30L);
    private int windowSize = 3;
    private int codeDigits = 6;
    private int numberOfScratchCodes = 5;
    private int keyModulus = (int)Math.pow(10.0, this.codeDigits);
    private int secretBits = 160;
    private OtpHmacHashAlgorithm hmacHash = OtpHmacHashAlgorithm.HmacSHA1;

    public int getKeyModulus() {
        return this.keyModulus;
    }

    public int getCodeDigits() {
        return this.codeDigits;
    }

    public int getNumberOfScratchCodes() {
        return this.numberOfScratchCodes;
    }

    public long getTimeStepSizeInMillis() {
        return this.timeStepSizeInMillis;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getSecretBits() {
        return this.secretBits;
    }

    public OtpHmacHashAlgorithm getHmacHash() {
        return this.hmacHash;
    }

    public static GoogleAuthenticatorConfigBuilder builder() {
        return new GoogleAuthenticatorConfigBuilder();
    }

    public static class GoogleAuthenticatorConfigBuilder {
        private GoogleAuthenticatorConfig config = new GoogleAuthenticatorConfig();

        public GoogleAuthenticatorConfig build() {
            return this.config;
        }

        public GoogleAuthenticatorConfigBuilder codeDigits(int codeDigits) {
            if (codeDigits <= 0) {
                throw new IllegalArgumentException("Code digits must be positive.");
            }
            if (codeDigits < 6) {
                throw new IllegalArgumentException("The minimum number of digits is 6.");
            }
            if (codeDigits > 8) {
                throw new IllegalArgumentException("The maximum number of digits is 8.");
            }
            this.config.codeDigits = codeDigits;
            this.config.keyModulus = (int)Math.pow(10.0, codeDigits);
            return this;
        }

        public GoogleAuthenticatorConfigBuilder numberOfScratchCodes(int numberOfScratchCodes) {
            if (numberOfScratchCodes < 0) {
                throw new IllegalArgumentException("The number of scratch codes must not be negative");
            }
            if (numberOfScratchCodes > 1000) {
                throw new IllegalArgumentException("The maximum number of scratch codes is 1000");
            }
            this.config.numberOfScratchCodes = numberOfScratchCodes;
            return this;
        }

        public GoogleAuthenticatorConfigBuilder timeStepSizeInMillis(long timeStepSizeInMillis) {
            if (timeStepSizeInMillis <= 0L) {
                throw new IllegalArgumentException("Time step size must be positive.");
            }
            this.config.timeStepSizeInMillis = timeStepSizeInMillis;
            return this;
        }

        public GoogleAuthenticatorConfigBuilder windowSize(int windowSize) {
            if (windowSize <= 0) {
                throw new IllegalArgumentException("Window number must be positive.");
            }
            this.config.windowSize = windowSize;
            return this;
        }

        public GoogleAuthenticatorConfigBuilder secretBits(int secretBits) {
            if (secretBits < 128) {
                throw new IllegalArgumentException("Secret bits must be greater than or equal to 128.");
            }
            if (secretBits % 8 != 0) {
                throw new IllegalArgumentException("Secret bits must be a multiple of 8.");
            }
            this.config.secretBits = secretBits;
            return this;
        }

        public GoogleAuthenticatorConfigBuilder hmacHash(OtpHmacHashAlgorithm hmacHash) {
            if (hmacHash == null) {
                throw new IllegalArgumentException("HMAC Hash Function cannot be null.");
            }
            this.config.hmacHash = hmacHash;
            return this;
        }
    }
}

