/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.symmetric;

import io.polaris.core.crypto.Ciphers;
import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.IDecryptor;
import io.polaris.core.crypto.IEncryptor;
import io.polaris.core.crypto.symmetric.SymmetricAlgorithm;
import java.security.Key;

public class Symmetric {
    private final String algorithm;
    private final Key key;
    private IEncryptor encryptor;
    private IDecryptor decryptor;

    public Symmetric(String algorithm, Key key) {
        this.algorithm = algorithm;
        this.key = key;
    }

    public Symmetric(SymmetricAlgorithm algorithm, Key key) {
        this.algorithm = algorithm.code();
        this.key = key;
    }

    public Symmetric(String algorithm) {
        this.algorithm = algorithm;
        this.key = CryptoKeys.generateKey(this.algorithm);
    }

    public Symmetric(SymmetricAlgorithm algorithm) {
        this.algorithm = algorithm.code();
        this.key = CryptoKeys.generateKey(this.algorithm);
    }

    public IDecryptor getDecryptor() {
        if (this.decryptor == null) {
            this.decryptor = Ciphers.getDecryptor(this.algorithm, this.key);
        }
        return this.decryptor;
    }

    public IEncryptor getEncryptor() {
        if (this.encryptor == null) {
            this.encryptor = Ciphers.getEncryptor(this.algorithm, this.key);
        }
        return this.encryptor;
    }

    public Symmetric encryptUpdate(byte[] data) {
        this.getEncryptor().update(data);
        return this;
    }

    public byte[] encrypt(byte[] data) {
        return this.getEncryptor().encrypt(data);
    }

    public Symmetric decryptUpdate(byte[] data) {
        this.getDecryptor().update(data);
        return this;
    }

    public byte[] decrypt(byte[] data) {
        return this.getDecryptor().decrypt(data);
    }
}

