/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.data;

import io.polaris.core.assertion.Arguments;
import io.polaris.core.concurrent.PooledThreadFactory;
import io.polaris.core.data.BatchDataCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class MultiBatchDataCollector<K, E> {
    private final Map<K, BatchDataCollector<E>> collectors = new ConcurrentHashMap<K, BatchDataCollector<E>>();
    private final int maxStoreSize;
    private final long maxStoreNanos;
    private ScheduledExecutorService scheduler;

    public MultiBatchDataCollector(int maxStoreSize, long maxStoreTime, TimeUnit timeUnit) {
        this(maxStoreSize, timeUnit.toNanos(maxStoreTime));
    }

    public MultiBatchDataCollector(int maxStoreSize, long maxStoreNanos) {
        Arguments.isTrue(maxStoreSize > 0, "maxStoreSize must be greater than 0");
        Arguments.isTrue(maxStoreNanos > 0L, "maxStoreNanos must be greater than 0");
        this.maxStoreSize = maxStoreSize;
        this.maxStoreNanos = maxStoreNanos;
    }

    public long getMaxStoreNanos() {
        return this.maxStoreNanos;
    }

    public int getMaxStoreSize() {
        return this.maxStoreSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startScheduler() {
        if (this.scheduler != null) {
            return false;
        }
        MultiBatchDataCollector multiBatchDataCollector = this;
        synchronized (multiBatchDataCollector) {
            ScheduledExecutorService scheduler;
            if (this.scheduler != null) {
                return false;
            }
            this.scheduler = scheduler = Executors.newScheduledThreadPool(1, new PooledThreadFactory("MultiBatchDataCollector"));
            scheduler.scheduleAtFixedRate(() -> {
                for (Map.Entry<K, BatchDataCollector<E>> entry : this.collectors.entrySet()) {
                    BatchDataCollector<E> collector = entry.getValue();
                    if (collector.getConsumer() == null) continue;
                    collector.flush();
                }
            }, this.maxStoreNanos, this.maxStoreNanos, TimeUnit.NANOSECONDS);
            return true;
        }
    }

    private BatchDataCollector<E> getCollector(K key, Consumer<List<E>> consumer) {
        return this.collectors.computeIfAbsent(key, k -> new BatchDataCollector(this.maxStoreSize, this.maxStoreNanos, consumer));
    }

    private BatchDataCollector<E> getCollector(K key) {
        return Objects.requireNonNull(this.collectors.get(key));
    }

    public boolean register(K key, Consumer<List<E>> consumer) {
        return this.register(key, new BatchDataCollector<E>(this.maxStoreSize, this.maxStoreNanos, consumer));
    }

    public boolean register(K key, BatchDataCollector<E> collector) {
        BatchDataCollector<E> old = this.collectors.putIfAbsent(key, collector);
        return old == null;
    }

    public void collect(K key, E datum) {
        this.collect(key, Collections.singletonList(datum));
    }

    public void collect(K key, Iterable<E> data) {
        this.getCollector(key).collect(data);
    }

    public void flush(K key) {
        this.getCollector(key).flush();
    }

    public void collect(K key, E datum, Consumer<List<E>> consumer) {
        this.collect(key, Collections.singletonList(datum), consumer);
    }

    public void collect(K key, Iterable<E> data, Consumer<List<E>> consumer) {
        this.getCollector(key, consumer).collect(data, consumer);
    }

    public void flush(K key, Consumer<List<E>> consumer) {
        this.getCollector(key, consumer).flush(consumer);
    }
}

