/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.data.buffer;

import io.polaris.core.data.buffer.AtomicRangeInteger;
import io.polaris.core.data.buffer.IQueueBuffer;
import java.util.List;

public class QueueBuffer<T>
implements IQueueBuffer<T> {
    private final Object[] buffer;
    private final AtomicRangeInteger index;
    private final boolean override;

    QueueBuffer(int bufferSize, boolean override) {
        this.buffer = new Object[bufferSize];
        this.override = override;
        this.index = new AtomicRangeInteger(0, bufferSize);
    }

    @Override
    public boolean push(T data) {
        int i = this.index.getAndIncrement();
        if (this.buffer[i] != null && !this.override) {
            return false;
        }
        this.buffer[i] = data;
        return true;
    }

    @Override
    public int size() {
        return this.buffer.length;
    }

    @Override
    public void drainTo(List<T> consumeList) {
        this.drainTo(consumeList, 0, this.buffer.length);
    }

    void drainTo(List<T> consumeList, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (this.buffer[i] == null) continue;
            consumeList.add(this.buffer[i]);
            this.buffer[i] = null;
        }
    }
}

