/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.env;

import io.polaris.core.env.Env;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class GroupEnv
implements Env {
    private final String name;
    private Env runtime;
    private final CopyOnWriteArrayList<Env> envList = new CopyOnWriteArrayList();
    private final ThreadLocal<Deque<String>> resolvedKeys = new ThreadLocal();
    private final ThreadLocal<Boolean> retrieved = new ThreadLocal();

    public GroupEnv() {
        this(null, false);
    }

    public GroupEnv(String name) {
        this(name, false);
    }

    public GroupEnv(String name, boolean mutable) {
        this.name = name;
        if (mutable) {
            this.runtime = Env.wrap(new Properties());
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvFirst(Env properties) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            this.envList.remove(properties);
            this.envList.add(0, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvLast(Env properties) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            this.envList.remove(properties);
            this.envList.add(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEnv(String name) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            int size = this.envList.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.envList.get(i).name(), name)) continue;
                this.envList.remove(i);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceEnv(String name, Env properties) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            int size = this.envList.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.envList.get(i).name(), name)) continue;
                this.envList.set(i, properties);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEnvBefore(String name, Env properties) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            int size = this.envList.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.envList.get(i).name(), name)) continue;
                this.envList.add(i, properties);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEnvAfter(String name, Env properties) {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            int size = this.envList.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.envList.get(i).name(), name)) continue;
                this.envList.add(i + 1, properties);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEnv() {
        CopyOnWriteArrayList<Env> copyOnWriteArrayList = this.envList;
        synchronized (copyOnWriteArrayList) {
            this.envList.clear();
        }
    }

    @Override
    public void set(String key, String value) {
        if (this.runtime != null) {
            this.runtime.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        if (this.isResolvingKey(key)) {
            return null;
        }
        try {
            Object object;
            this.pushResolveKey(key);
            String val = null;
            if (this.runtime != null) {
                val = this.runtime.get(key);
            }
            if (val == null) {
                Env properties;
                object = this.envList.iterator();
                while (object.hasNext() && (val = (properties = (Env)object.next()).get(key)) == null) {
                }
            }
            object = val;
            return object;
        }
        finally {
            this.pollResolveKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        if (this.isResolvingKey(key)) {
            return;
        }
        try {
            this.pushResolveKey(key);
            if (this.runtime != null) {
                this.runtime.remove(key);
            }
            for (Env properties : this.envList) {
                properties.remove(key);
            }
        }
        finally {
            this.pollResolveKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keys() {
        if (Boolean.TRUE.equals(this.retrieved.get())) {
            return Collections.emptySet();
        }
        this.retrieved.set(true);
        try {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            if (this.runtime != null) {
                keys.addAll(this.runtime.keys());
            }
            for (Env properties : this.envList) {
                Set<String> keySet = properties.keys();
                keys.addAll(keySet);
            }
            LinkedHashSet<String> linkedHashSet = keys;
            return linkedHashSet;
        }
        finally {
            this.retrieved.remove();
        }
    }

    private boolean isResolvingKey(String key) {
        Deque<String> queue = this.resolvedKeys.get();
        return queue != null && queue.contains(key);
    }

    private void pushResolveKey(String key) {
        Deque<String> queue = this.resolvedKeys.get();
        if (queue == null) {
            queue = new ArrayDeque<String>();
            this.resolvedKeys.set(queue);
        }
        queue.offerFirst(key);
    }

    private void pollResolveKey(String key) {
        Deque<String> queue = this.resolvedKeys.get();
        if (Objects.equals(queue.peekFirst(), key)) {
            queue.pollFirst();
        }
        if (queue.isEmpty()) {
            this.resolvedKeys.remove();
        }
    }
}

