/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.dbv.model;

import io.polaris.core.jdbc.dbv.annotation.DbvColumn;
import io.polaris.core.jdbc.dbv.model.Column;
import io.polaris.core.jdbc.dbv.model.Index;
import io.polaris.core.jdbc.dbv.model.IndexInfo;
import io.polaris.core.jdbc.dbv.model.PrimaryKey;
import io.polaris.core.map.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Table {
    @DbvColumn(value="TABLE_CAT")
    private String tableCatalog;
    @DbvColumn(value="TABLE_SCHEM")
    private String tableSchema;
    @DbvColumn(value="TABLE_NAME")
    private String tableName;
    @DbvColumn(value="TABLE_TYPE")
    private String tableType;
    @DbvColumn(value="REMARKS")
    private String remarks;
    private List<PrimaryKey> primaryKeyList = new ArrayList<PrimaryKey>();
    private List<IndexInfo> indexInfoList = new ArrayList<IndexInfo>();
    private List<Column> columnList = new ArrayList<Column>();
    private Set<String> pkColumns = new LinkedHashSet<String>();
    private Map<String, Column> columnMap = Maps.newUpperCaseLinkedHashMap();
    private List<Index> indexList = new ArrayList<Index>();

    public void fit() {
        TreeSet<IndexInfo> sortedIndexInfos = new TreeSet<IndexInfo>(new Comparator<IndexInfo>(){

            @Override
            public int compare(IndexInfo o1, IndexInfo o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int i = o1.getIndexName().compareTo(o2.getIndexName());
                if (i == 0) {
                    if (o1.getOrdinalPosition() < o2.getOrdinalPosition()) {
                        return -1;
                    }
                    return 1;
                }
                return i;
            }
        });
        for (IndexInfo idx : this.indexInfoList) {
            sortedIndexInfos.add(idx);
            if (!idx.isNonUnique()) {
                idx.setIsUnique("YES");
                continue;
            }
            idx.setIsUnique("NO");
        }
        for (IndexInfo idxInfo : sortedIndexInfos) {
            Index idx;
            if (this.indexList.size() > 0 && this.indexList.get(this.indexList.size() - 1).getIndexName().equals(idxInfo.getIndexName())) {
                idx = this.indexList.get(this.indexList.size() - 1);
                idx.setColumnNames(idx.getColumnNames() + "," + idxInfo.getColumnName());
                continue;
            }
            idx = new Index();
            idx.setTableCatalog(idxInfo.getTableCatalog());
            idx.setTableSchema(idxInfo.getTableSchema());
            idx.setTableName(idxInfo.getTableName());
            idx.setIndexName(idxInfo.getIndexName());
            idx.setColumnNames(idxInfo.getColumnName());
            idx.setAscOrDesc(idxInfo.getAscOrDesc());
            idx.setNonUnique(idxInfo.isNonUnique());
            idx.setUnique(!idxInfo.isNonUnique());
            idx.setIsUnique(idxInfo.getIsUnique());
            this.indexList.add(idx);
        }
        for (PrimaryKey pk : this.primaryKeyList) {
            this.pkColumns.add(pk.getColumnName());
        }
        block7: for (Column col : this.columnList) {
            this.columnMap.put(col.getColumnName(), col);
            if (this.pkColumns.contains(col.getColumnName())) {
                col.setIsPrimaryKey("YES");
                col.setPrimaryKey(true);
            } else {
                col.setIsPrimaryKey("NO");
                col.setPrimaryKey(false);
            }
            if (col.getNullable() == 0) {
                col.setIsNotNullable("YES");
                col.setNotNull(true);
            } else {
                col.setIsNotNullable("NO");
                col.setNotNull(false);
            }
            if ("YES".equalsIgnoreCase(col.getIsAutoincrement())) {
                col.setAutoincrement(true);
            } else {
                col.setAutoincrement(false);
            }
            if ("YES".equalsIgnoreCase(col.getIsGeneratedcolumn())) {
                col.setGenerated(true);
            } else {
                col.setGenerated(false);
            }
            int dataType = col.getDataType();
            switch (dataType) {
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    col.setColumnType(col.getTypeName() + "(" + col.getColumnSize() + ")");
                    continue block7;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    int decimalDigits = col.getDecimalDigits();
                    col.setColumnType(col.getTypeName() + "(" + col.getColumnSize() + (decimalDigits > 0 ? "," + decimalDigits : "") + ")");
                    continue block7;
                }
            }
            col.setColumnType(col.getTypeName());
        }
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public List<PrimaryKey> getPrimaryKeyList() {
        return this.primaryKeyList;
    }

    public List<IndexInfo> getIndexInfoList() {
        return this.indexInfoList;
    }

    public List<Column> getColumnList() {
        return this.columnList;
    }

    public Set<String> getPkColumns() {
        return this.pkColumns;
    }

    public Map<String, Column> getColumnMap() {
        return this.columnMap;
    }

    public List<Index> getIndexList() {
        return this.indexList;
    }

    public void setTableCatalog(String tableCatalog) {
        this.tableCatalog = tableCatalog;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setPrimaryKeyList(List<PrimaryKey> primaryKeyList) {
        this.primaryKeyList = primaryKeyList;
    }

    public void setIndexInfoList(List<IndexInfo> indexInfoList) {
        this.indexInfoList = indexInfoList;
    }

    public void setColumnList(List<Column> columnList) {
        this.columnList = columnList;
    }

    public void setPkColumns(Set<String> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public void setColumnMap(Map<String, Column> columnMap) {
        this.columnMap = columnMap;
    }

    public void setIndexList(List<Index> indexList) {
        this.indexList = indexList;
    }

    public String toString() {
        return "Table(tableCatalog=" + this.tableCatalog + ", tableSchema=" + this.tableSchema + ", tableName=" + this.tableName + ", tableType=" + this.tableType + ", remarks=" + this.remarks + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableCatalog = this.tableCatalog;
        String other$tableCatalog = other.tableCatalog;
        if (this$tableCatalog == null ? other$tableCatalog != null : !this$tableCatalog.equals(other$tableCatalog)) {
            return false;
        }
        String this$tableSchema = this.tableSchema;
        String other$tableSchema = other.tableSchema;
        if (this$tableSchema == null ? other$tableSchema != null : !this$tableSchema.equals(other$tableSchema)) {
            return false;
        }
        String this$tableName = this.tableName;
        String other$tableName = other.tableName;
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableType = this.tableType;
        String other$tableType = other.tableType;
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        String this$remarks = this.remarks;
        String other$remarks = other.remarks;
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        List<PrimaryKey> this$primaryKeyList = this.primaryKeyList;
        List<PrimaryKey> other$primaryKeyList = other.primaryKeyList;
        if (this$primaryKeyList == null ? other$primaryKeyList != null : !((Object)this$primaryKeyList).equals(other$primaryKeyList)) {
            return false;
        }
        List<IndexInfo> this$indexInfoList = this.indexInfoList;
        List<IndexInfo> other$indexInfoList = other.indexInfoList;
        if (this$indexInfoList == null ? other$indexInfoList != null : !((Object)this$indexInfoList).equals(other$indexInfoList)) {
            return false;
        }
        List<Column> this$columnList = this.columnList;
        List<Column> other$columnList = other.columnList;
        if (this$columnList == null ? other$columnList != null : !((Object)this$columnList).equals(other$columnList)) {
            return false;
        }
        Set<String> this$pkColumns = this.pkColumns;
        Set<String> other$pkColumns = other.pkColumns;
        if (this$pkColumns == null ? other$pkColumns != null : !((Object)this$pkColumns).equals(other$pkColumns)) {
            return false;
        }
        Map<String, Column> this$columnMap = this.columnMap;
        Map<String, Column> other$columnMap = other.columnMap;
        if (this$columnMap == null ? other$columnMap != null : !((Object)this$columnMap).equals(other$columnMap)) {
            return false;
        }
        List<Index> this$indexList = this.indexList;
        List<Index> other$indexList = other.indexList;
        return !(this$indexList == null ? other$indexList != null : !((Object)this$indexList).equals(other$indexList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableCatalog = this.tableCatalog;
        result = result * 59 + ($tableCatalog == null ? 43 : $tableCatalog.hashCode());
        String $tableSchema = this.tableSchema;
        result = result * 59 + ($tableSchema == null ? 43 : $tableSchema.hashCode());
        String $tableName = this.tableName;
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableType = this.tableType;
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        String $remarks = this.remarks;
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        List<PrimaryKey> $primaryKeyList = this.primaryKeyList;
        result = result * 59 + ($primaryKeyList == null ? 43 : ((Object)$primaryKeyList).hashCode());
        List<IndexInfo> $indexInfoList = this.indexInfoList;
        result = result * 59 + ($indexInfoList == null ? 43 : ((Object)$indexInfoList).hashCode());
        List<Column> $columnList = this.columnList;
        result = result * 59 + ($columnList == null ? 43 : ((Object)$columnList).hashCode());
        Set<String> $pkColumns = this.pkColumns;
        result = result * 59 + ($pkColumns == null ? 43 : ((Object)$pkColumns).hashCode());
        Map<String, Column> $columnMap = this.columnMap;
        result = result * 59 + ($columnMap == null ? 43 : ((Object)$columnMap).hashCode());
        List<Index> $indexList = this.indexList;
        result = result * 59 + ($indexList == null ? 43 : ((Object)$indexList).hashCode());
        return result;
    }
}

