/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql;

import io.polaris.core.string.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SqlStatement {
    private final List<String> tables = new ArrayList<String>();
    private final List<String> columns = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();
    private final List<String> sets = new ArrayList<String>();
    private final List<String> select = new ArrayList<String>();
    private final List<Join> joins = new ArrayList<Join>();
    private final List<String> groupBy = new ArrayList<String>();
    private final List<String> orderBy = new ArrayList<String>();
    private final And<SqlStatement> where = new And(this);
    private final And<SqlStatement> having = new And(this);
    private StatementType statementType;
    private boolean distinct;

    public static SqlStatement of() {
        return new SqlStatement();
    }

    public SqlStatement update(String table) {
        this.statementType = StatementType.UPDATE;
        this.tables.add(table);
        return this;
    }

    public SqlStatement set(String sets) {
        this.sets.add(sets);
        return this;
    }

    public SqlStatement set(String ... sets) {
        this.sets.addAll(Arrays.asList(sets));
        return this;
    }

    public SqlStatement insert(String tableName) {
        this.statementType = StatementType.INSERT;
        this.tables.add(tableName);
        return this;
    }

    public SqlStatement columnAndValue(String columns, String values) {
        this.columns.add(columns);
        this.values.add(values);
        return this;
    }

    public SqlStatement columns(String ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public SqlStatement values(String ... values) {
        this.values.addAll(Arrays.asList(values));
        return this;
    }

    public SqlStatement select(String columns) {
        this.statementType = StatementType.SELECT;
        this.select.add(columns);
        return this;
    }

    public SqlStatement select(String ... columns) {
        this.statementType = StatementType.SELECT;
        this.select.addAll(Arrays.asList(columns));
        return this;
    }

    public SqlStatement selectDistinct(String columns) {
        this.distinct = true;
        this.select(columns);
        return this;
    }

    public SqlStatement selectDistinct(String ... columns) {
        this.distinct = true;
        this.select(columns);
        return this;
    }

    public SqlStatement delete(String table) {
        this.statementType = StatementType.DELETE;
        this.tables.add(table);
        return this;
    }

    public SqlStatement from(String table) {
        this.tables.add(table);
        return this;
    }

    public SqlStatement from(String ... tables) {
        this.tables.addAll(Arrays.asList(tables));
        return this;
    }

    public Join join(String table) {
        Join join = new Join(this, "JOIN", table);
        this.joins.add(join);
        return join;
    }

    public Join innerJoin(String table) {
        Join join = new Join(this, "INNER JOIN", table);
        this.joins.add(join);
        return join;
    }

    public Join leftOuterJoin(String table) {
        Join join = new Join(this, "LEFT OUTER JOIN", table);
        this.joins.add(join);
        return join;
    }

    public Join rightOuterJoin(String table) {
        Join join = new Join(this, "RIGHT OUTER JOIN", table);
        this.joins.add(join);
        return join;
    }

    public Join outerJoin(String table) {
        Join join = new Join(this, "OUTER JOIN", table);
        this.joins.add(join);
        return join;
    }

    public And<SqlStatement> where() {
        return this.where;
    }

    public SqlStatement where(String conditions) {
        this.where.add(conditions);
        return this;
    }

    public SqlStatement where(String ... conditions) {
        this.where.add(conditions);
        return this;
    }

    public SqlStatement groupBy(String columns) {
        this.groupBy.add(columns);
        return this;
    }

    public SqlStatement groupBy(String ... columns) {
        this.groupBy.addAll(Arrays.asList(columns));
        return this;
    }

    public And<SqlStatement> having() {
        return this.having;
    }

    public SqlStatement having(String conditions) {
        this.having.add(conditions);
        return this;
    }

    public SqlStatement having(String ... conditions) {
        this.having.add(conditions);
        return this;
    }

    public SqlStatement orderBy(String columns) {
        this.orderBy.add(columns);
        return this;
    }

    public SqlStatement orderBy(String ... columns) {
        this.orderBy.addAll(Arrays.asList(columns));
        return this;
    }

    public String toString() {
        return this.toSqlString();
    }

    public String toSqlString() throws IllegalStateException {
        StringBuilder builder = new StringBuilder();
        if (this.statementType == null) {
            return null;
        }
        switch (this.statementType) {
            case DELETE: {
                return this.deleteSQL(builder);
            }
            case INSERT: {
                return this.insertSQL(builder);
            }
            case SELECT: {
                return this.selectSQL(builder);
            }
            case UPDATE: {
                return this.updateSQL(builder);
            }
        }
        throw new IllegalArgumentException("\u672a\u77e5Sql\u7c7b\u578b\uff1a" + (Object)((Object)this.statementType));
    }

    private String selectSQL(StringBuilder builder) {
        this.sqlSelect(builder);
        this.sqlFrom(builder);
        this.sqlJoins(builder);
        this.sqlWhere(builder);
        this.sqlGroupBy(builder);
        this.sqlHaving(builder);
        this.sqlOrderBy(builder);
        return builder.toString();
    }

    private String insertSQL(StringBuilder builder) {
        this.sqlInsert(builder);
        this.sqlColumns(builder);
        this.sqlValues(builder);
        return builder.toString();
    }

    private String deleteSQL(StringBuilder builder) {
        this.sqlDelete(builder);
        this.sqlWhere(builder);
        return builder.toString();
    }

    private String updateSQL(StringBuilder builder) {
        this.sqlUpdate(builder);
        this.sqlJoins(builder);
        this.sqlSet(builder);
        this.sqlWhere(builder);
        return builder.toString();
    }

    private void sqlInsert(StringBuilder builder) {
        if (!this.tables.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("INSERT INTO ");
            for (int i = 0; i < this.tables.size(); ++i) {
                String c = this.tables.get(i);
                builder.append(c);
            }
        }
    }

    private void sqlColumns(StringBuilder builder) {
        if (!this.columns.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("(");
            for (int i = 0; i < this.columns.size(); ++i) {
                String c = this.columns.get(i);
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(c);
            }
            builder.append(")");
        }
    }

    private void sqlValues(StringBuilder builder) {
        if (!this.values.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("VALUES (");
            for (int i = 0; i < this.values.size(); ++i) {
                String c = this.values.get(i);
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(c);
            }
            builder.append(")");
        }
    }

    private void sqlDelete(StringBuilder builder) {
        if (!this.tables.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("DELETE FROM ");
            for (int i = 0; i < this.tables.size(); ++i) {
                String c = this.tables.get(i);
                builder.append(c);
            }
        }
    }

    private void sqlUpdate(StringBuilder builder) {
        if (!this.tables.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("UPDATE ");
            for (int i = 0; i < this.tables.size(); ++i) {
                String c = this.tables.get(i);
                builder.append(c);
            }
        }
    }

    private void sqlSet(StringBuilder builder) {
        if (!this.sets.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("SET");
            for (int i = 0; i < this.sets.size(); ++i) {
                String c = this.sets.get(i);
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(" ").append(c);
            }
        }
    }

    private void sqlSelect(StringBuilder builder) {
        if (!this.select.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("SELECT");
            if (this.distinct) {
                builder.append(" DISTINCT");
            }
            for (int i = 0; i < this.select.size(); ++i) {
                String c = this.select.get(i);
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(" ").append(c);
            }
        }
    }

    private void sqlFrom(StringBuilder builder) {
        if (!this.tables.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("FROM");
            for (int i = 0; i < this.tables.size(); ++i) {
                String c = this.tables.get(i);
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(" ").append(c);
            }
        }
    }

    private void sqlJoins(StringBuilder builder) {
        if (!this.joins.isEmpty()) {
            for (Join join : this.joins) {
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(join.toSqlString());
            }
        }
    }

    private void sqlWhere(StringBuilder builder) {
        String whereString = this.where.toSqlString();
        if (whereString.length() > 0) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("WHERE ").append(whereString);
        }
    }

    private void sqlGroupBy(StringBuilder builder) {
        if (!this.groupBy.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("GROUP BY");
            for (int i = 0; i < this.groupBy.size(); ++i) {
                String c = this.groupBy.get(i);
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(" ").append(c);
            }
        }
    }

    private void sqlHaving(StringBuilder builder) {
        String whereString = this.having.toSqlString();
        if (whereString.length() > 0) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("HAVING ").append(whereString);
        }
    }

    private void sqlOrderBy(StringBuilder builder) {
        if (!this.orderBy.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("ORDER BY");
            for (int i = 0; i < this.orderBy.size(); ++i) {
                String c = this.orderBy.get(i);
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(" ").append(c);
            }
        }
    }

    public static class Or<T> {
        private final T owner;
        private final List<Object> conditions = new ArrayList<Object>();

        private Or(T owner) {
            this.owner = owner;
        }

        public T end() {
            return this.owner;
        }

        public Or<T> add(String condition) {
            this.conditions.add(condition);
            return this;
        }

        public Or<T> add(String ... conditions) {
            this.conditions.addAll(Arrays.asList(conditions));
            return this;
        }

        public And<Or<T>> and() {
            And<Or<T>> and = new And<Or<T>>(this);
            this.conditions.add(and);
            return and;
        }

        public String toSqlString() {
            if (this.conditions.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (Object condition : this.conditions) {
                if (sb.length() > 0) {
                    sb.append(")\nOR (");
                } else {
                    sb.append("(");
                }
                if (condition instanceof And) {
                    sb.append(((And)condition).toSqlString());
                    continue;
                }
                if (!(condition instanceof String)) continue;
                sb.append(condition);
            }
            sb.append(")");
            return sb.toString();
        }

        public boolean hasConditions() {
            return !this.conditions.isEmpty();
        }
    }

    public static class And<T> {
        private final T owner;
        private final List<Object> conditions = new ArrayList<Object>();

        private And(T owner) {
            this.owner = owner;
        }

        public T end() {
            return this.owner;
        }

        public And<T> add(String condition) {
            this.conditions.add(condition);
            return this;
        }

        public And<T> add(String ... conditions) {
            this.conditions.addAll(Arrays.asList(conditions));
            return this;
        }

        public Or<And<T>> or() {
            Or<And<T>> or = new Or<And<T>>(this);
            this.conditions.add(or);
            return or;
        }

        public String toSqlString() {
            if (this.conditions.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (Object condition : this.conditions) {
                if (sb.length() > 0) {
                    sb.append(")\nAND (");
                } else {
                    sb.append("(");
                }
                if (condition instanceof Or) {
                    sb.append(((Or)condition).toSqlString());
                    continue;
                }
                if (!(condition instanceof String)) continue;
                sb.append(condition);
            }
            sb.append(")");
            return sb.toString();
        }

        public boolean hasConditions() {
            return !this.conditions.isEmpty();
        }
    }

    public static class Join {
        private final SqlStatement owner;
        private final String conjunction;
        private final String table;
        private final And<SqlStatement> on;

        public Join(SqlStatement owner, String conjunction, String table) {
            this.owner = owner;
            this.conjunction = Strings.isBlank(conjunction) ? "JOIN" : conjunction;
            this.table = table;
            this.on = new And(owner);
        }

        public And<SqlStatement> on() {
            return this.on;
        }

        public SqlStatement end() {
            return this.owner;
        }

        public String toSqlString() {
            if (Strings.isBlank(this.table)) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.conjunction).append(" ").append(this.table);
            String onSqlString = this.on.toSqlString();
            if (onSqlString.length() > 0) {
                sb.append(" ON ").append(onSqlString);
            }
            return sb.toString();
        }
    }

    public static enum StatementType {
        INSERT,
        SELECT,
        UPDATE,
        DELETE;

    }
}

