/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql;

import io.polaris.core.converter.Converters;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.ExpressionMeta;
import io.polaris.core.jdbc.TableMeta;
import io.polaris.core.jdbc.TableMetaKit;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.BoundSql;
import io.polaris.core.jdbc.sql.SqlStatement;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.VarNameGenerator;
import io.polaris.core.jdbc.sql.query.Criteria;
import io.polaris.core.jdbc.sql.query.OrderBy;
import io.polaris.core.jdbc.sql.query.Queries;
import io.polaris.core.jdbc.sql.statement.ColumnPredicate;
import io.polaris.core.jdbc.sql.statement.ConfigurableColumnPredicate;
import io.polaris.core.lang.Objs;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.string.Strings;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class SqlStatements {
    private static ILogger log = ILoggers.of(SqlStatements.class);
    private static final String KEY_WHERE_PREFIX = "_w";
    private static final String KEY_VALUE_PREFIX = "_v";

    private static VarNameGenerator newWhereVarNameGenerator() {
        return VarNameGenerator.newInstance(KEY_WHERE_PREFIX);
    }

    private static VarNameGenerator newValueVarNameGenerator() {
        return VarNameGenerator.newInstance(KEY_VALUE_PREFIX);
    }

    public static String buildInsert(Map<String, Object> bindings, Class<?> entityClass) {
        String entityKey = "_e";
        String includeColumnsKey = "_ic";
        String excludeColumnsKey = "_xc";
        String includeEmptyColumnsKey = "_iec";
        String includeAllEmptyKey = "_ie";
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, null, includeColumnsKey, null, excludeColumnsKey, null, includeEmptyColumnsKey, false, includeAllEmptyKey);
        return SqlStatements.buildInsert(bindings, entityClass, entityKey, columnPredicate);
    }

    public static String buildInsert(Map<String, Object> bindings, Class<?> entityClass, String entityKey, ColumnPredicate columnPredicate) {
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, Collections.emptyMap());
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.insert(tableMeta.getTable());
        VarNameGenerator valueKeyGen = SqlStatements.newValueVarNameGenerator();
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String name = entry.getKey();
            ColumnMeta meta = entry.getValue();
            String columnName = meta.getColumnName();
            boolean insertable = meta.isInsertable() || meta.isCreateTime() || meta.isUpdateTime();
            if (!insertable || !columnPredicate.isIncludedColumn(name)) continue;
            Object val1 = entityMap.get(meta.getFieldName());
            Object val = BindingValues.getValueForInsert(meta, val1);
            if (meta.isVersion()) {
                val = val == null ? 1L : ((Number)val).longValue();
            }
            if (Objs.isNotEmpty(val)) {
                String keyName = valueKeyGen.generate();
                sql.columnAndValue(columnName, "#{" + keyName + "}");
                bindings.put(keyName, val);
                continue;
            }
            if (!columnPredicate.isIncludedEmptyColumn(name)) continue;
            sql.columnAndValue(columnName, "NULL");
        }
        return sql.toSqlString();
    }

    public static String buildDeleteById(Map<String, Object> bindings, Class<?> entityClass) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        return SqlStatements.buildDeleteById(bindings, entityClass, entityKey, whereKey);
    }

    public static String buildDeleteById(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.delete(tableMeta.getTable());
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
        if (entity == null) {
            entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
        }
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String name = entry.getKey();
            ColumnMeta meta = entry.getValue();
            String columnName = meta.getColumnName();
            boolean primaryKey = meta.isPrimaryKey();
            boolean version = meta.isVersion();
            Object val = entityMap.get(name);
            if (!primaryKey && !version) continue;
            if (Objs.isNotEmpty(val)) {
                SqlStatements.appendSqlWhereWithVal(bindings, sql, meta, val, whereKeyGen.generate());
                continue;
            }
            sql.where(columnName + " IS NULL");
        }
        if (!sql.where().hasConditions()) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6761\u4ef6\u5b50\u53e5");
        }
        return sql.toSqlString();
    }

    public static String buildDeleteByAny(Map<String, Object> bindings, Class<?> entityClass) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        String[] includeColumnsKey = new String[]{"_w_ic", "_ic"};
        String[] excludeColumnsKey = new String[]{"_w_xc", "_xc"};
        String[] includeEmptyColumnsKey = new String[]{"_w_iec", "_iec"};
        String[] includeAllEmptyKey = new String[]{"_w_ie", "_ie"};
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, null, includeColumnsKey, null, excludeColumnsKey, null, includeEmptyColumnsKey, false, includeAllEmptyKey);
        return SqlStatements.buildDeleteByAny(bindings, entityClass, entityKey, whereKey, columnPredicate);
    }

    public static String buildDeleteByAny(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, ColumnPredicate columnPredicate) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.delete(tableMeta.getTable());
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
        if (entity != null) {
            if (entity instanceof Criteria) {
                SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, entity);
            } else {
                SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, entity, columnPredicate);
            }
        }
        if ((entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, null)) != null) {
            if (entity instanceof Criteria) {
                SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, entity);
            } else {
                SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, entity, columnPredicate);
            }
        }
        if (!sql.where().hasConditions()) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6761\u4ef6\u5b50\u53e5");
        }
        return sql.toSqlString();
    }

    public static String buildUpdateById(Map<String, Object> bindings, Class<?> entityClass) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        String includeColumnsKey = "_ic";
        String excludeColumnsKey = "_xc";
        String includeEmptyColumnsKey = "_iec";
        String includeAllEmptyKey = "_ie";
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, null, includeColumnsKey, null, excludeColumnsKey, null, includeEmptyColumnsKey, false, includeAllEmptyKey);
        return SqlStatements.buildUpdateById(bindings, entityClass, entityKey, whereKey, columnPredicate);
    }

    public static String buildUpdateById(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, ColumnPredicate columnPredicate) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.update(tableMeta.getTable());
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
        if (entity == null) {
            entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
        }
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        VarNameGenerator valueKeyGen = SqlStatements.newValueVarNameGenerator();
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String updateDefault;
            String keyName;
            boolean updatable;
            String name = entry.getKey();
            ColumnMeta meta = entry.getValue();
            String columnName = meta.getColumnName();
            boolean primaryKey = meta.isPrimaryKey();
            boolean version = meta.isVersion();
            Object val = entityMap.get(name);
            boolean bl = updatable = meta.isUpdatable() || meta.isVersion() || meta.isUpdateTime();
            if (primaryKey || version) {
                if (Objs.isEmpty(val)) {
                    sql.where(columnName + " IS NULL");
                } else {
                    keyName = whereKeyGen.generate();
                    sql.where(columnName + " = #{" + keyName + "}");
                    bindings.put(keyName, val);
                }
            }
            if (!updatable || !columnPredicate.isIncludedColumn(name)) continue;
            if (Objs.isEmpty(val) && meta.isUpdateTime()) {
                Date value = new Date();
                val = Converters.convertQuietly(meta.getFieldType(), value);
            }
            if (Objs.isEmpty(val) && Strings.isNotBlank(updateDefault = meta.getUpdateDefault())) {
                val = Converters.convertQuietly(meta.getFieldType(), updateDefault);
            }
            if (version) {
                val = Objs.isEmpty(val) ? 1L : ((Number)val).longValue() + 1L;
            } else if (primaryKey) continue;
            if (Objs.isNotEmpty(val)) {
                keyName = valueKeyGen.generate();
                sql.set(columnName + " = #{" + keyName + "}");
                bindings.put(keyName, val);
                continue;
            }
            boolean include = columnPredicate.isIncludedEmptyColumn(name);
            if (!include) continue;
            sql.set(columnName + " = NULL");
        }
        if (!sql.where().hasConditions()) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6761\u4ef6\u5b50\u53e5");
        }
        return sql.toSqlString();
    }

    public static String buildLogicDeleteById(Map<String, Object> bindings, Class<?> entityClass) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        return SqlStatements.buildLogicDeleteById(bindings, entityClass, entityKey, whereKey);
    }

    public static String buildLogicDeleteById(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        if (!tableMeta.getColumns().values().stream().anyMatch(c -> c.isLogicDeleted())) {
            log.warn("\u5b9e\u4f53{}\u4e0d\u5b58\u5728\u903b\u8f91\u5220\u9664\u5b57\u6bb5\uff01", entityClass);
            return SqlStatements.buildDeleteById(bindings, entityClass, entityKey, whereKey);
        }
        SqlStatement sql = SqlStatement.of();
        sql.update(tableMeta.getTable());
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
        if (entity == null) {
            entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
        }
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        VarNameGenerator valueKeyGen = SqlStatements.newValueVarNameGenerator();
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String keyName;
            Long val;
            String name = entry.getKey();
            ColumnMeta meta = entry.getValue();
            String columnName = meta.getColumnName();
            boolean primaryKey = meta.isPrimaryKey();
            boolean version = meta.isVersion();
            boolean logicDeleted = meta.isLogicDeleted();
            if (primaryKey || version) {
                val = (Long)entityMap.get(name);
                if (Objs.isEmpty(val)) {
                    sql.where(columnName + " IS NULL");
                } else {
                    keyName = whereKeyGen.generate();
                    sql.where(columnName + " = #{" + keyName + "}");
                    bindings.put(keyName, val);
                }
            }
            val = null;
            if (logicDeleted) {
                val = (Long)Converters.convertQuietly(meta.getFieldType(), true);
            } else if (meta.isUpdateTime()) {
                val = (Long)entityMap.get(name);
                if (Objs.isEmpty(val)) {
                    Date value = new Date();
                    val = Converters.convertQuietly(meta.getFieldType(), value);
                }
            } else if (version) {
                val = (Long)entityMap.get(name);
                val = Objs.isEmpty(val) ? 1L : ((Number)val).longValue() + 1L;
            }
            if (!Objs.isNotEmpty(val)) continue;
            keyName = valueKeyGen.generate();
            sql.set(columnName + " = #{" + keyName + "}");
            bindings.put(keyName, val);
        }
        if (!sql.where().hasConditions()) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6761\u4ef6\u5b50\u53e5");
        }
        return sql.toSqlString();
    }

    public static String buildUpdateByAny(Map<String, Object> bindings, Class<?> entityClass) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        String includeColumnsKey = "_ic";
        String excludeColumnsKey = "_xc";
        String includeEmptyColumnsKey = "_iec";
        String includeAllEmptyKey = "_ie";
        String whereIncludeColumnsKey = "_w_ic";
        String whereExcludeColumnsKey = "_w_xc";
        String whereIncludeEmptyColumnsKey = "_w_iec";
        String whereIncludeAllEmptyKey = "_w_ie";
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, null, includeColumnsKey, null, excludeColumnsKey, null, includeEmptyColumnsKey, false, includeAllEmptyKey);
        ColumnPredicate whereColumnPredicate = ConfigurableColumnPredicate.of(bindings, null, whereIncludeColumnsKey, null, whereExcludeColumnsKey, null, whereIncludeEmptyColumnsKey, false, whereIncludeAllEmptyKey);
        return SqlStatements.buildUpdateByAny(bindings, entityClass, entityKey, whereKey, columnPredicate, whereColumnPredicate);
    }

    public static String buildUpdateByAny(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, ColumnPredicate columnPredicate, ColumnPredicate whereColumnPredicate) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.update(tableMeta.getTable());
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        VarNameGenerator valueKeyGen = SqlStatements.newValueVarNameGenerator();
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, Collections.emptyMap());
        Object where = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String name = entry.getKey();
            ColumnMeta meta = entry.getValue();
            String columnName = meta.getColumnName();
            boolean primaryKey = meta.isPrimaryKey();
            boolean version = meta.isVersion();
            boolean updatable = meta.isUpdatable() || meta.isVersion() || meta.isUpdateTime();
            if (!updatable || primaryKey || !columnPredicate.isIncludedColumn(name)) continue;
            Object val = entityMap.get(meta.getFieldName());
            Object entityVal = BindingValues.getValueForUpdate(meta, val);
            if (version) {
                entityVal = Objs.isEmpty(entityVal) ? 1L : ((Number)entityVal).longValue() + 1L;
            }
            if (Objs.isNotEmpty(entityVal)) {
                String keyName = valueKeyGen.generate();
                sql.set(columnName + " = #{" + keyName + "}");
                bindings.put(keyName, entityVal);
                continue;
            }
            boolean include = columnPredicate.isIncludedEmptyColumn(name);
            if (!include) continue;
            sql.set(columnName + " = NULL");
        }
        if (where instanceof Criteria) {
            SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, where);
        } else if (where != null) {
            SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, where, whereColumnPredicate);
        }
        if (!sql.where().hasConditions()) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6761\u4ef6\u5b50\u53e5");
        }
        return sql.toSqlString();
    }

    public static String buildLogicDeleteByAny(Map<String, Object> bindings, Class<?> entityClass) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        String whereIncludeColumnsKey = "_w_ic";
        String whereExcludeColumnsKey = "_w_xc";
        String whereIncludeEmptyColumnsKey = "_w_iec";
        String whereIncludeAllEmptyKey = "_w_ie";
        ColumnPredicate whereColumnPredicate = ConfigurableColumnPredicate.of(bindings, null, whereIncludeColumnsKey, null, whereExcludeColumnsKey, null, whereIncludeEmptyColumnsKey, false, whereIncludeAllEmptyKey);
        return SqlStatements.buildLogicDeleteByAny(bindings, entityClass, entityKey, whereKey, whereColumnPredicate);
    }

    public static String buildLogicDeleteByAny(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, ColumnPredicate whereColumnPredicate) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        if (!tableMeta.getColumns().values().stream().anyMatch(c -> c.isLogicDeleted())) {
            log.warn("\u5b9e\u4f53{}\u4e0d\u5b58\u5728\u903b\u8f91\u5220\u9664\u5b57\u6bb5\uff01", entityClass);
            return SqlStatements.buildDeleteByAny(bindings, entityClass, entityKey, whereKey, whereColumnPredicate);
        }
        SqlStatement sql = SqlStatement.of();
        sql.update(tableMeta.getTable());
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        VarNameGenerator valueKeyGen = SqlStatements.newValueVarNameGenerator();
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, Collections.emptyMap());
        Object where = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String name = entry.getKey();
            ColumnMeta meta = entry.getValue();
            String columnName = meta.getColumnName();
            boolean primaryKey = meta.isPrimaryKey();
            boolean version = meta.isVersion();
            boolean logicDeleted = meta.isLogicDeleted();
            Long val = null;
            if (logicDeleted) {
                val = (Long)Converters.convertQuietly(meta.getFieldType(), true);
            } else if (meta.isUpdateTime()) {
                val = (Long)entityMap.get(name);
                if (Objs.isEmpty(val)) {
                    Date value = new Date();
                    val = Converters.convertQuietly(meta.getFieldType(), value);
                }
            } else if (version) {
                val = (Long)entityMap.get(name);
                val = Objs.isEmpty(val) ? 1L : ((Number)val).longValue() + 1L;
            }
            if (!Objs.isNotEmpty(val)) continue;
            String keyName = valueKeyGen.generate();
            sql.set(columnName + " = #{" + keyName + "}");
            bindings.put(keyName, val);
        }
        if (where instanceof Criteria) {
            SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, where);
        } else if (where != null) {
            SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, where, whereColumnPredicate);
        }
        if (!sql.where().hasConditions()) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6761\u4ef6\u5b50\u53e5");
        }
        return sql.toSqlString();
    }

    public static String buildCount(Map<String, Object> bindings, Class<?> entityClass) {
        return SqlStatements.buildCount(bindings, entityClass, false);
    }

    public static String buildCount(Map<String, Object> bindings, Class<?> entityClass, boolean exceptLogicDeleted) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        String[] includeColumnsKey = new String[]{"_w_ic", "_ic"};
        String[] excludeColumnsKey = new String[]{"_w_xc", "_xc"};
        String[] includeEmptyColumnsKey = new String[]{"_w_iec", "_iec"};
        String[] includeAllEmptyKey = new String[]{"_w_ie", "_ie"};
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, null, includeColumnsKey, null, excludeColumnsKey, null, includeEmptyColumnsKey, false, includeAllEmptyKey);
        return SqlStatements.buildCount(bindings, entityClass, entityKey, whereKey, columnPredicate, exceptLogicDeleted);
    }

    public static String buildCount(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, ColumnPredicate columnPredicate) {
        return SqlStatements.buildCount(bindings, entityClass, entityKey, whereKey, columnPredicate, false);
    }

    public static String buildCount(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, ColumnPredicate columnPredicate, boolean exceptLogicDeleted) {
        Object entity;
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.from(tableMeta.getTable());
        sql.select("COUNT(*)");
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        if (exceptLogicDeleted) {
            tableMeta.getColumns().values().stream().filter(c -> c.isLogicDeleted()).forEach(meta -> {
                String columnName = meta.getColumnName();
                Object val = Converters.convertQuietly(meta.getFieldType(), false);
                String keyName = whereKeyGen.generate();
                sql.where(columnName + " = #{" + keyName + "}");
                bindings.put(keyName, val);
            });
        }
        if ((entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null)) != null) {
            if (entity instanceof Criteria) {
                SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, entity);
            } else {
                SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, entity, columnPredicate);
            }
        }
        if ((entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, null)) != null) {
            if (entity instanceof Criteria) {
                SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, entity);
            } else {
                SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, entity, columnPredicate);
            }
        }
        return sql.toSqlString();
    }

    public static String buildExistsById(Map<String, Object> bindings, Class<?> entityClass) {
        return SqlStatements.buildExistsById(bindings, entityClass, false);
    }

    public static String buildExistsById(Map<String, Object> bindings, Class<?> entityClass, boolean exceptLogicDeleted) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        return SqlStatements.buildExistsById(bindings, entityClass, entityKey, whereKey, exceptLogicDeleted);
    }

    public static String buildExistsById(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey) {
        return SqlStatements.buildExistsById(bindings, entityClass, entityKey, whereKey, false);
    }

    public static String buildExistsById(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, boolean exceptLogicDeleted) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.from(tableMeta.getTable());
        sql.select("COUNT(*) EXISTED");
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
        if (entity == null) {
            entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
        }
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String keyName;
            String name = entry.getKey();
            ColumnMeta meta = entry.getValue();
            String columnName = meta.getColumnName();
            boolean primaryKey = meta.isPrimaryKey();
            boolean version = meta.isVersion();
            Object val = entityMap.get(name);
            if (primaryKey) {
                if (val == null) {
                    sql.where(columnName + " IS NULL");
                    continue;
                }
                keyName = whereKeyGen.generate();
                sql.where(columnName + " = #{" + keyName + "}");
                bindings.put(keyName, val);
                continue;
            }
            if (!exceptLogicDeleted || !meta.isLogicDeleted()) continue;
            keyName = whereKeyGen.generate();
            val = Converters.convertQuietly(meta.getFieldType(), false);
            sql.where(columnName + " = #{" + keyName + "}");
            bindings.put(keyName, val);
        }
        if (!sql.where().hasConditions()) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6761\u4ef6\u5b50\u53e5");
        }
        return sql.toSqlString();
    }

    public static String buildExistsByAny(Map<String, Object> bindings, Class<?> entityClass, boolean queryByCount) {
        return SqlStatements.buildExistsByAny(bindings, entityClass, queryByCount, false);
    }

    public static String buildExistsByAny(Map<String, Object> bindings, Class<?> entityClass, boolean queryByCount, boolean exceptLogicDeleted) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        String[] includeColumnsKey = new String[]{"_w_ic", "_ic"};
        String[] excludeColumnsKey = new String[]{"_w_xc", "_xc"};
        String[] includeEmptyColumnsKey = new String[]{"_w_iec", "_iec"};
        String[] includeAllEmptyKey = new String[]{"_w_ie", "_ie"};
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, null, includeColumnsKey, null, excludeColumnsKey, null, includeEmptyColumnsKey, false, includeAllEmptyKey);
        return SqlStatements.buildExistsByAny(bindings, entityClass, entityKey, whereKey, columnPredicate, queryByCount, exceptLogicDeleted);
    }

    public static String buildExistsByAny(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, ColumnPredicate columnPredicate, boolean queryByCount) {
        return SqlStatements.buildExistsByAny(bindings, entityClass, entityKey, whereKey, columnPredicate, queryByCount, false);
    }

    public static String buildExistsByAny(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, ColumnPredicate columnPredicate, boolean queryByCount, boolean exceptLogicDeleted) {
        Object entity;
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.from(tableMeta.getTable());
        if (queryByCount) {
            sql.select("COUNT(*) EXISTED");
        } else {
            sql.select("1 EXISTED");
        }
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        if (exceptLogicDeleted) {
            tableMeta.getColumns().values().stream().filter(c -> c.isLogicDeleted()).forEach(meta -> {
                String columnName = meta.getColumnName();
                Object val = Converters.convertQuietly(meta.getFieldType(), false);
                String keyName = whereKeyGen.generate();
                sql.where(columnName + " = #{" + keyName + "}");
                bindings.put(keyName, val);
            });
        }
        if ((entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null)) != null) {
            if (entity instanceof Criteria) {
                SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, entity);
            } else {
                SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, entity, columnPredicate);
            }
        }
        if ((entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, null)) != null) {
            if (entity instanceof Criteria) {
                SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, entity);
            } else {
                SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, entity, columnPredicate);
            }
        }
        return sql.toSqlString();
    }

    public static String buildSelectById(Map<String, Object> bindings, Class<?> entityClass) {
        return SqlStatements.buildSelectById(bindings, entityClass, false);
    }

    public static String buildSelectById(Map<String, Object> bindings, Class<?> entityClass, boolean exceptLogicDeleted) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        String orderByKey = "_o";
        return SqlStatements.buildSelectById(bindings, entityClass, entityKey, whereKey, orderByKey, exceptLogicDeleted);
    }

    public static String buildSelectById(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, String orderByKey) {
        return SqlStatements.buildSelectById(bindings, entityClass, entityKey, whereKey, orderByKey, false);
    }

    public static String buildSelectById(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, String orderByKey, boolean exceptLogicDeleted) {
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.from(tableMeta.getTable());
        Object entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null);
        if (entity == null) {
            entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, Collections.emptyMap());
        }
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            String keyName;
            String name = entry.getKey();
            ColumnMeta meta = entry.getValue();
            String columnName = meta.getColumnName();
            boolean primaryKey = meta.isPrimaryKey();
            Object val = entityMap.get(name);
            sql.select(columnName + " " + name);
            if (primaryKey) {
                if (val == null) {
                    sql.where(columnName + " IS NULL");
                    continue;
                }
                keyName = whereKeyGen.generate();
                sql.where(columnName + " = #{" + keyName + "}");
                bindings.put(keyName, val);
                continue;
            }
            if (!exceptLogicDeleted || !meta.isLogicDeleted()) continue;
            keyName = whereKeyGen.generate();
            val = Converters.convertQuietly(meta.getFieldType(), false);
            sql.where(columnName + " = #{" + keyName + "}");
            bindings.put(keyName, val);
        }
        if (!sql.where().hasConditions()) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u6761\u4ef6\u5b50\u53e5");
        }
        return sql.toSqlString();
    }

    public static String buildSelectByAny(Map<String, Object> bindings, Class<?> entityClass) {
        return SqlStatements.buildSelectByAny(bindings, entityClass, false);
    }

    public static String buildSelectByAny(Map<String, Object> bindings, Class<?> entityClass, boolean exceptLogicDeleted) {
        String entityKey = "_e";
        String whereKey = KEY_WHERE_PREFIX;
        String orderByKey = "_o";
        String[] includeColumnsKey = new String[]{"_w_ic", "_ic"};
        String[] excludeColumnsKey = new String[]{"_w_xc", "_xc"};
        String[] includeEmptyColumnsKey = new String[]{"_w_iec", "_iec"};
        String[] includeAllEmptyKey = new String[]{"_w_ie", "_ie"};
        ColumnPredicate columnPredicate = ConfigurableColumnPredicate.of(bindings, null, includeColumnsKey, null, excludeColumnsKey, null, includeEmptyColumnsKey, false, includeAllEmptyKey);
        return SqlStatements.buildSelectByAny(bindings, entityClass, entityKey, whereKey, orderByKey, columnPredicate, exceptLogicDeleted);
    }

    public static String buildSelectByAny(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, String orderByKey, ColumnPredicate columnPredicate) {
        return SqlStatements.buildSelectByAny(bindings, entityClass, entityKey, whereKey, orderByKey, columnPredicate, false);
    }

    public static String buildSelectByAny(Map<String, Object> bindings, Class<?> entityClass, String entityKey, String whereKey, String orderByKey, ColumnPredicate columnPredicate, boolean exceptLogicDeleted) {
        Object entity;
        String columnName;
        String name;
        TableMeta tableMeta = TableMetaKit.instance().get(entityClass);
        SqlStatement sql = SqlStatement.of();
        sql.from(tableMeta.getTable());
        VarNameGenerator whereKeyGen = SqlStatements.newWhereVarNameGenerator();
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            name = entry.getKey();
            ColumnMeta meta2 = entry.getValue();
            columnName = meta2.getColumnName();
            sql.select(columnName + " " + name);
        }
        for (Map.Entry<String, Cloneable> entry : tableMeta.getExpressions().entrySet()) {
            name = entry.getKey();
            ExpressionMeta meta2 = (ExpressionMeta)entry.getValue();
            if (!meta2.isSelectable()) continue;
            columnName = meta2.getExpressionWithTableName();
            sql.select(columnName + " " + name);
        }
        if (exceptLogicDeleted) {
            tableMeta.getColumns().values().stream().filter(c -> c.isLogicDeleted()).forEach(meta -> {
                String columnName = meta.getColumnName();
                Object val = Converters.convertQuietly(meta.getFieldType(), false);
                String keyName = whereKeyGen.generate();
                sql.where(columnName + " = #{" + keyName + "}");
                bindings.put(keyName, val);
            });
        }
        if ((entity = BindingValues.getBindingValueOrDefault(bindings, entityKey, null)) != null) {
            if (entity instanceof Criteria) {
                SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, entity);
            } else {
                SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, entity, columnPredicate);
            }
        }
        if ((entity = BindingValues.getBindingValueOrDefault(bindings, whereKey, null)) != null) {
            if (entity instanceof Criteria) {
                SqlStatements.appendSqlWhereWithCriteria(bindings, tableMeta, sql, whereKeyGen, entity);
            } else {
                SqlStatements.appendSqlWhereWithEntity(bindings, entityClass, tableMeta, sql, whereKeyGen, entity, columnPredicate);
            }
        }
        Object object = BindingValues.getBindingValueOrDefault(bindings, orderByKey, null);
        OrderBy orderBy = null;
        if (object instanceof String) {
            orderBy = Queries.newOrderBy((String)object);
        } else if (object instanceof OrderBy) {
            orderBy = (OrderBy)object;
        }
        if (orderBy != null) {
            for (OrderBy.Item item : orderBy.getItems()) {
                ColumnMeta columnMeta = tableMeta.getColumns().get(item.getField());
                if (columnMeta != null) {
                    sql.orderBy(columnMeta.getColumnName() + " " + item.getDirection().getSqlText());
                    continue;
                }
                ExpressionMeta expressionMeta = tableMeta.getExpressions().get(item.getField());
                if (expressionMeta == null) continue;
                sql.orderBy(expressionMeta.getExpressionWithTableName() + " " + item.getDirection().getSqlText());
            }
        }
        return sql.toSqlString();
    }

    private static void appendSqlWhereWithEntity(Map<String, Object> bindings, Class<?> entityClass, TableMeta tableMeta, SqlStatement sql, VarNameGenerator whereKeyGen, Object entity, ColumnPredicate columnPredicate) {
        boolean include;
        Object val;
        String columnName;
        Cloneable meta;
        String name;
        BeanMap<Object> entityMap = entity instanceof Map ? (BeanMap<Object>)entity : (tableMeta.getEntityClass().isAssignableFrom(entity.getClass()) ? Beans.newBeanMap(entity, tableMeta.getEntityClass()) : Beans.newBeanMap(entity));
        for (Map.Entry<String, ColumnMeta> entry : tableMeta.getColumns().entrySet()) {
            name = entry.getKey();
            if (!columnPredicate.isIncludedColumn(name)) continue;
            meta = entry.getValue();
            columnName = ((ColumnMeta)meta).getColumnName();
            val = entityMap.get(name);
            if (Objs.isNotEmpty(val)) {
                SqlStatements.appendSqlWhereWithVal(bindings, sql, (ColumnMeta)meta, val, whereKeyGen.generate());
                continue;
            }
            include = columnPredicate.isIncludedEmptyColumn(name);
            if (!include) continue;
            sql.where(columnName + " IS NULL");
        }
        for (Map.Entry<String, Cloneable> entry : tableMeta.getExpressions().entrySet()) {
            name = entry.getKey();
            if (!columnPredicate.isIncludedColumn(name)) continue;
            meta = (ExpressionMeta)entry.getValue();
            columnName = ((ExpressionMeta)meta).getExpressionWithTableName();
            val = entityMap.get(name);
            if (Objs.isNotEmpty(val)) {
                SqlStatements.appendSqlWhereWithVal(bindings, sql, (ExpressionMeta)meta, val, whereKeyGen.generate());
                continue;
            }
            include = columnPredicate.isIncludedEmptyColumn(name);
            if (!include) continue;
            sql.where(columnName + " IS NULL");
        }
    }

    private static void appendSqlWhereWithCriteria(Map<String, Object> bindings, TableMeta tableMeta, SqlStatement sql, VarNameGenerator whereKeyGen, Object criteria) {
        Function<String, String> columnDiscovery;
        SqlNode sqlNode;
        if (criteria instanceof Criteria && !(sqlNode = Queries.parse((Criteria)criteria, false, columnDiscovery = Queries.newColumnDiscovery(tableMeta))).isSkipped()) {
            BoundSql boundSql = sqlNode.asBoundSql(whereKeyGen);
            sql.where(boundSql.getText());
            bindings.putAll(boundSql.getBindings());
        }
    }

    private static void appendSqlWhereWithVal(@Nonnull Map<String, Object> bindings, @Nonnull SqlStatement sql, @Nonnull ExpressionMeta meta, @Nonnull Object val, String key) {
        String columnName = meta.getExpressionWithTableName();
        Class<?> fieldType = meta.getFieldType();
        SqlStatements.appendSqlWhereWithVal(bindings, sql, columnName, fieldType, val, key);
    }

    private static void appendSqlWhereWithVal(@Nonnull Map<String, Object> bindings, @Nonnull SqlStatement sql, @Nonnull ColumnMeta meta, @Nonnull Object val, String key) {
        String columnName = meta.getColumnName();
        Class<?> fieldType = meta.getFieldType();
        SqlStatements.appendSqlWhereWithVal(bindings, sql, columnName, fieldType, val, key);
    }

    private static void appendSqlWhereWithVal(Map<String, Object> bindings, SqlStatement sql, String columnName, Class<?> fieldType, Object val, String key) {
        Date[] range;
        if (Date.class.isAssignableFrom(fieldType) && (range = BindingValues.getDateRangeOrNull(val)) != null) {
            Date start = range[0];
            Date end = range[1];
            if (start != null) {
                sql.where(columnName + " >= #{" + key + "0} ");
                bindings.put(key + "0", start);
            }
            if (end != null) {
                sql.where(columnName + " <= #{" + key + "1} ");
                bindings.put(key + "1", end);
            }
            return;
        }
        if (String.class.isAssignableFrom(fieldType) && val instanceof String && (((String)val).startsWith("%") || ((String)val).endsWith("%"))) {
            bindings.put(key, val);
            sql.where(columnName + " like #{" + key + "} ");
            return;
        }
        if (val instanceof Iterable) {
            StringBuilder where = new StringBuilder();
            where.append(columnName).append(" IN ( ");
            int i = 0;
            boolean first = true;
            for (Object next : (Iterable)val) {
                if (i > 0 && i % 1000 == 0) {
                    where.append(" ) AND ").append(columnName).append(" IN ( ");
                    first = true;
                }
                if (first) {
                    first = false;
                } else {
                    where.append(", ");
                }
                where.append("#{").append(key).append(i).append("}");
                bindings.put(key + i, Converters.convertQuietly(fieldType, next));
                ++i;
            }
            where.append(" ) ");
            sql.where(where.toString());
        } else if (val.getClass().isArray()) {
            int len = Array.getLength(val);
            StringBuilder where = new StringBuilder();
            where.append(columnName).append(" IN ( ");
            boolean first = true;
            for (int i = 0; i < len; ++i) {
                Object next = Array.get(val, i);
                if (i > 0 && i % 1000 == 0) {
                    where.append(" ) AND ").append(columnName).append(" IN ( ");
                    first = true;
                }
                if (first) {
                    first = false;
                } else {
                    where.append(", ");
                }
                where.append("#{").append(key).append(i).append("}");
                bindings.put(key + i, Converters.convertQuietly(fieldType, next));
            }
            where.append(" ) ");
            sql.where(where.toString());
        } else {
            sql.where(columnName + " = #{" + key + "} ");
            bindings.put(key, Converters.convertQuietly(fieldType, val));
        }
    }
}

