/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.jdbc.sql.SqlTextParsers;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.BaseSegment;
import io.polaris.core.jdbc.sql.statement.Segment;
import io.polaris.core.jdbc.sql.statement.SelectStatement;
import io.polaris.core.jdbc.sql.statement.segment.AndSegment;
import io.polaris.core.jdbc.sql.statement.segment.GroupBySegment;
import io.polaris.core.jdbc.sql.statement.segment.OrderBySegment;
import io.polaris.core.jdbc.sql.statement.segment.SelectSegment;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessibleHolder;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.lang.Objs;
import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import java.util.ArrayList;
import java.util.List;

@AnnotationProcessing
public class JoinSegment<O extends Segment<O>, S extends JoinSegment<O, S>>
extends BaseSegment<S>
implements TableAccessible {
    private final O owner;
    private final TableAccessible tableAccessible;
    private final TextNode conj;
    private final TableSegment<?> table;
    private final List<SelectSegment<S, ?>> selects = new ArrayList();
    private AndSegment<S, ?> on;
    private AndSegment<S, ?> where;
    private final List<GroupBySegment<S, ?>> groupBys = new ArrayList();
    private AndSegment<S, ?> having;
    private final List<OrderBySegment<S, ?>> orderBys = new ArrayList();

    @AnnotationProcessing
    public JoinSegment(O owner, TextNode conj, Class<?> entityClass, String alias) {
        this.owner = owner;
        this.conj = conj;
        this.table = TableSegment.fromEntity(entityClass, alias);
        this.tableAccessible = this.fetchTableAccessible();
    }

    @AnnotationProcessing
    public JoinSegment(O owner, TextNode conj, SelectStatement<?> select, String alias) {
        this.owner = owner;
        this.conj = conj;
        this.table = TableSegment.fromSelect(select, alias);
        this.tableAccessible = this.fetchTableAccessible();
    }

    private TableAccessible fetchTableAccessible() {
        if (this.owner instanceof TableAccessible) {
            return (TableAccessible)this.owner;
        }
        if (this.owner instanceof TableAccessibleHolder) {
            return ((TableAccessibleHolder)this.owner).getTableAccessible();
        }
        throw new IllegalArgumentException("owner error!");
    }

    @Override
    public TableAccessible getTableAccessible() {
        return this.tableAccessible;
    }

    @AnnotationProcessing
    protected <T extends SelectSegment<S, T>> T buildSelect() {
        return (T)new SelectSegment(this.getThis(), this.table);
    }

    @AnnotationProcessing
    protected <T extends AndSegment<S, T>> T buildWhere() {
        return (T)new AndSegment(this.getThis(), this.table);
    }

    @AnnotationProcessing
    protected GroupBySegment<S, ?> buildGroupBy() {
        return new GroupBySegment(this.getThis(), this.table);
    }

    @AnnotationProcessing
    protected OrderBySegment<S, ?> buildOrderBy() {
        return new OrderBySegment(this.getThis(), this.table);
    }

    public SqlNode toOnSqlNode() {
        if (this.on == null) {
            return SqlNodes.EMPTY;
        }
        return this.on.toSqlNode();
    }

    public SqlNode toWhereSqlNode() {
        if (this.where == null) {
            return SqlNodes.EMPTY;
        }
        return this.where.toSqlNode();
    }

    public O end() {
        return this.owner;
    }

    @AnnotationProcessing
    public <T extends AndSegment<S, T>> T on() {
        this.on = Objs.defaultIfNull(this.on, this::buildWhere);
        return (T)this.on;
    }

    @AnnotationProcessing
    public <T extends AndSegment<S, T>> T where() {
        this.where = Objs.defaultIfNull(this.where, this::buildWhere);
        return (T)this.where;
    }

    public S selectAll() {
        Object segment = ((SelectSegment)this.buildSelect()).column("*");
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((JoinSegment)this.getThis());
    }

    public S selectAll(boolean withFieldAlias) {
        Object segment = ((SelectSegment)((SelectSegment)this.buildSelect()).column("*")).aliasWithField(withFieldAlias);
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((JoinSegment)this.getThis());
    }

    public S selectRaw(String ... rawColumns) {
        return this.select(SqlNodes.text(SqlTextParsers.resolveTableRef(Strings.join((CharSequence)",", rawColumns), this)));
    }

    public S select(SqlNode sqlNode) {
        Object segment = ((SelectSegment)this.buildSelect()).sql(sqlNode);
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((JoinSegment)this.getThis());
    }

    @AnnotationProcessing
    public <T extends SelectSegment<S, T>> T select() {
        T segment = this.buildSelect();
        this.selects.add((SelectSegment<S, ?>)segment);
        return segment;
    }

    public <T, R> S select(GetterFunction<T, R> getter) {
        return this.select(Reflects.getPropertyName(getter));
    }

    @AnnotationProcessing
    public S select(String field) {
        Object segment = ((SelectSegment)this.buildSelect()).column(field);
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((JoinSegment)this.getThis());
    }

    public <T, R> S select(GetterFunction<T, R> getter, String alias) {
        return this.select(Reflects.getPropertyName(getter), alias);
    }

    @AnnotationProcessing
    public S select(String field, String alias) {
        Object segment = ((SelectSegment)this.buildSelect()).column(field);
        ((SelectSegment)segment).alias(alias);
        this.selects.add((SelectSegment<S, ?>)segment);
        return (S)((JoinSegment)this.getThis());
    }

    @AnnotationProcessing
    public <G extends GroupBySegment<S, G>> G groupBy() {
        GroupBySegment<S, ?> groupBy = this.buildGroupBy();
        this.groupBys.add(groupBy);
        return (G)groupBy;
    }

    @AnnotationProcessing
    public <H extends AndSegment<S, H>> H having() {
        this.having = Objs.defaultIfNull(this.having, this::buildWhere);
        return (H)this.having;
    }

    @AnnotationProcessing
    public <E extends OrderBySegment<S, E>> E orderBy() {
        OrderBySegment<S, ?> orderBy = this.buildOrderBy();
        this.orderBys.add(orderBy);
        return (E)orderBy;
    }

    public S orderByRaw(String ... rawSql) {
        for (String s : rawSql) {
            OrderBySegment<S, ?> orderBy = this.buildOrderBy();
            orderBy.sql(SqlNodes.text(SqlTextParsers.resolveTableRef(s, this.tableAccessible)));
            this.orderBys.add(orderBy);
        }
        return (S)((JoinSegment)this.getThis());
    }

    public <T, R> S orderBy(GetterFunction<T, R> getter) {
        return this.orderBy(Reflects.getPropertyName(getter));
    }

    public S orderBy(String field) {
        OrderBySegment<S, ?> orderBy = this.buildOrderBy();
        orderBy.column(field);
        this.orderBys.add(orderBy);
        return (S)((JoinSegment)this.getThis());
    }

    public <T, R> S orderByDesc(GetterFunction<T, R> getter) {
        return this.orderByDesc(Reflects.getPropertyName(getter));
    }

    public S orderByDesc(String field) {
        OrderBySegment<S, ?> orderBy = this.buildOrderBy();
        ((OrderBySegment)orderBy.column(field)).desc();
        this.orderBys.add(orderBy);
        return (S)((JoinSegment)this.getThis());
    }

    public List<SelectSegment<S, ?>> getSelects() {
        return this.selects;
    }

    public TextNode getConj() {
        return this.conj;
    }

    public List<GroupBySegment<S, ?>> getGroupBys() {
        return this.groupBys;
    }

    public AndSegment<S, ?> getHaving() {
        return this.having;
    }

    public List<OrderBySegment<S, ?>> getOrderBys() {
        return this.orderBys;
    }

    public TableSegment<?> getTable() {
        return this.table;
    }

    @Override
    public TableSegment<?> getTable(int tableIndex) {
        return this.getTableAccessible().getTable(tableIndex);
    }

    @Override
    public TableSegment<?> getTable(String tableAlias) {
        return this.getTableAccessible().getTable(tableAlias);
    }
}

