/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.reflect.Reflects;

public class TableField {
    private final String fieldName;
    private final Integer tableIndex;
    private final String tableAlias;

    private TableField(Integer tableIndex, String fieldName) {
        this.fieldName = fieldName;
        this.tableIndex = tableIndex;
        this.tableAlias = null;
    }

    private TableField(String tableAlias, String fieldName) {
        this.fieldName = fieldName;
        this.tableIndex = null;
        this.tableAlias = tableAlias;
    }

    public static TableField of(Integer tableIndex, String fieldName) {
        return new TableField(tableIndex, fieldName);
    }

    public static TableField of(String tableAlias, String fieldName) {
        return new TableField(tableAlias, fieldName);
    }

    public static <T, R> TableField of(Integer tableIndex, GetterFunction<T, R> getter) {
        return new TableField(tableIndex, Reflects.getPropertyName(getter));
    }

    public static <T, R> TableField of(String tableAlias, GetterFunction<T, R> getter) {
        return new TableField(tableAlias, Reflects.getPropertyName(getter));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableField)) {
            return false;
        }
        TableField other = (TableField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$tableIndex = this.tableIndex;
        Integer other$tableIndex = other.tableIndex;
        if (this$tableIndex == null ? other$tableIndex != null : !((Object)this$tableIndex).equals(other$tableIndex)) {
            return false;
        }
        String this$fieldName = this.fieldName;
        String other$fieldName = other.fieldName;
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$tableAlias = this.tableAlias;
        String other$tableAlias = other.tableAlias;
        return !(this$tableAlias == null ? other$tableAlias != null : !this$tableAlias.equals(other$tableAlias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tableIndex = this.tableIndex;
        result = result * 59 + ($tableIndex == null ? 43 : ((Object)$tableIndex).hashCode());
        String $fieldName = this.fieldName;
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $tableAlias = this.tableAlias;
        result = result * 59 + ($tableAlias == null ? 43 : $tableAlias.hashCode());
        return result;
    }

    public String toString() {
        return "TableField(fieldName=" + this.fieldName + ", tableIndex=" + this.tableIndex + ", tableAlias=" + this.tableAlias + ")";
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Integer getTableIndex() {
        return this.tableIndex;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }
}

