/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.annotation;

import io.polaris.core.lang.annotation.Alias;
import io.polaris.core.lang.annotation.AnnotationAttributes;
import io.polaris.core.lang.annotation.AnnotationInvocationHandler;
import io.polaris.core.lang.annotation.MergedAnnotations;
import io.polaris.core.lang.annotation.RawAnnotations;
import io.polaris.core.reflect.Reflects;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

public class Annotations {
    public static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return RawAnnotations.getAnnotation(element, annotationType);
    }

    public static <A extends Annotation> A[] getRepeatableAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return RawAnnotations.getRepeatableAnnotation((AnnotatedElement)element, annotationType);
    }

    public static <A extends Annotation> A getMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return MergedAnnotations.of(element).getMergedAnnotation(annotationType);
    }

    public static <A extends Annotation> Set<A> getMergedRepeatableAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return MergedAnnotations.of(element).getMergedRepeatableAnnotation(annotationType);
    }

    public static <A extends Annotation> A newInstance(Class<A> annotationType, Map<String, Object> values) {
        return AnnotationInvocationHandler.createProxy(annotationType, values);
    }

    public static Annotation[] getRepeatedAnnotations(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (!Annotations.isRepeatable(annotationType)) {
            return null;
        }
        return (Annotation[])Reflects.invokeQuietly(annotation, annotationType.getDeclaredMethods()[0], new Object[0]);
    }

    public static Class<? extends Annotation> getRepeatedAnnotationType(Class<? extends Annotation> annotationType) {
        Method[] methods = annotationType.getDeclaredMethods();
        if (methods.length != 1) {
            return null;
        }
        Method method = methods[0];
        if (!method.getName().equals("value")) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        if (!returnType.isArray()) {
            return null;
        }
        Class<?> componentType = returnType.getComponentType();
        if (!componentType.isAnnotation()) {
            return null;
        }
        Repeatable annotation = componentType.getAnnotation(Repeatable.class);
        if (annotation == null) {
            return null;
        }
        if (annotation.value() == annotationType) {
            return componentType;
        }
        return null;
    }

    public static <A extends Annotation> boolean isRepeatable(Class<A> annotationType) {
        return Annotations.getRepeatedAnnotationType(annotationType) != null;
    }

    public static <A extends Annotation> boolean hasAliasDefinition(Class<A> annotationType) {
        Method[] methods;
        for (Method method : methods = AnnotationAttributes.getAnnotationMembers(annotationType)) {
            Alias alias = method.getAnnotation(Alias.class);
            if (alias == null || alias.annotation() != annotationType && alias.annotation() != Alias.DEFAULT_ANNOTATION) continue;
            return true;
        }
        return false;
    }
}

