/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.annotation;

import io.polaris.core.assertion.Assertions;
import io.polaris.core.lang.annotation.AnnotationAttributes;
import io.polaris.core.lang.annotation.Annotations;
import io.polaris.core.lang.annotation.MergedAnnotation;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MatchedMergedAnnotation<A extends Annotation> {
    private final Class<A> annotationType;
    private final MergedAnnotation matched;
    private final List<MergedAnnotation> aliases;

    public MatchedMergedAnnotation(@Nonnull Class<A> annotationType, MergedAnnotation matched, List<MergedAnnotation> aliases) {
        Assertions.assertNotNull(annotationType, "annotationType is null");
        this.annotationType = annotationType;
        this.matched = matched;
        this.aliases = aliases == null ? Collections.emptyList() : aliases;
    }

    public static <A extends Annotation> MatchedMergedAnnotation<A> of(@Nonnull Class<A> annotationType, MergedAnnotation matchedAnnotation, List<MergedAnnotation> aliasAnnotations) {
        return new MatchedMergedAnnotation<A>(annotationType, matchedAnnotation, aliasAnnotations);
    }

    public static <A extends Annotation> MatchedMergedAnnotation<A> of(@Nonnull Class<A> annotationType, MergedAnnotation matchedAnnotation) {
        return new MatchedMergedAnnotation<A>(annotationType, matchedAnnotation, Collections.emptyList());
    }

    public A getAnnotation() {
        AnnotationAttributes annotationAttributes;
        MergedAnnotation matchedOne = this.matched;
        List<MergedAnnotation> aliasList = this.aliases;
        if (aliasList.isEmpty()) {
            if (matchedOne != null) {
                if (!Annotations.hasAliasDefinition(this.annotationType)) {
                    return (A)matchedOne.getAnnotation();
                }
            } else {
                return null;
            }
        }
        if (!(annotationAttributes = matchedOne != null ? AnnotationAttributes.of(matchedOne.getAnnotation()) : AnnotationAttributes.of(this.annotationType)).getMemberValues().isEmpty()) {
            HashSet<String> pending = new HashSet<String>(annotationAttributes.getMemberValues().keySet());
            Iterator<MergedAnnotation> iter = aliasList.iterator();
            while (!pending.isEmpty() && iter.hasNext()) {
                MergedAnnotation mergedAnnotation = iter.next();
                Map<String, Object> aliasValues = mergedAnnotation.getAliasValues();
                for (Map.Entry<String, Object> entry : aliasValues.entrySet()) {
                    String aliasName = entry.getKey();
                    Object aliasValue = entry.getValue();
                    if (!pending.contains(aliasName) || !annotationAttributes.set(aliasName, aliasValue)) continue;
                    pending.remove(aliasName);
                }
            }
        }
        return Annotations.newInstance(this.annotationType, annotationAttributes.asMap());
    }

    @Nonnull
    public Class<A> getAnnotationType() {
        return this.annotationType;
    }

    @Nullable
    public MergedAnnotation getMatched() {
        return this.matched;
    }

    @Nonnull
    public List<MergedAnnotation> getAliases() {
        return this.aliases;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchedMergedAnnotation)) {
            return false;
        }
        MatchedMergedAnnotation other = (MatchedMergedAnnotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<A> this$annotationType = this.annotationType;
        Class<A> other$annotationType = other.annotationType;
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        MergedAnnotation this$matched = this.matched;
        MergedAnnotation other$matched = other.matched;
        if (this$matched == null ? other$matched != null : !((Object)this$matched).equals(other$matched)) {
            return false;
        }
        List<MergedAnnotation> this$aliases = this.aliases;
        List<MergedAnnotation> other$aliases = other.aliases;
        return !(this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MatchedMergedAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<A> $annotationType = this.annotationType;
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        MergedAnnotation $matched = this.matched;
        result = result * 59 + ($matched == null ? 43 : ((Object)$matched).hashCode());
        List<MergedAnnotation> $aliases = this.aliases;
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        return result;
    }

    public String toString() {
        return "MatchedMergedAnnotation(annotationType=" + this.annotationType + ", matched=" + this.matched + ", aliases=" + this.aliases + ")";
    }
}

