/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean;

import io.polaris.core.converter.Converters;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.bean.MetaObject;
import io.polaris.core.lang.bean.PropertyAccessor;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.map.CaseInsensitiveMap;
import io.polaris.core.map.Maps;
import io.polaris.core.string.StringCases;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class LambdaMetaObject<T>
extends MetaObject<T> {
    private static final ILogger log = ILoggers.of(LambdaMetaObject.class);
    private static final Map<JavaType<?>, LambdaMetaObject<?>> CACHE = Maps.newWeakKeyMap(new ConcurrentHashMap());
    private Map<String, LambdaProperty> properties;
    private Map<String, LambdaProperty> propertiesCaseInsensitive;

    private LambdaMetaObject(JavaType<T> beanType) {
        super(beanType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> LambdaMetaObject<T> of(JavaType<T> beanType) {
        LambdaMetaObject metaObject = CACHE.computeIfAbsent(beanType, LambdaMetaObject::new);
        if (metaObject.state() == 0) {
            LambdaMetaObject lambdaMetaObject = metaObject;
            synchronized (lambdaMetaObject) {
                if (metaObject.state() == 0) {
                    metaObject.parse();
                }
            }
        }
        return metaObject;
    }

    public static <T> LambdaMetaObject<T> of(Class<T> beanType) {
        return LambdaMetaObject.of(JavaType.of(beanType));
    }

    public static <T> LambdaMetaObject<T> of(TypeRef<T> beanType) {
        return LambdaMetaObject.of(JavaType.of(beanType));
    }

    public static <T> LambdaMetaObject<T> of(Type beanType) {
        return LambdaMetaObject.of(JavaType.of(beanType));
    }

    @Override
    protected <E> MetaObject<E> createMetaObject(JavaType<E> beanType) {
        return LambdaMetaObject.of(beanType);
    }

    @Override
    protected boolean initBeanAccessor(Class<T> rawClass) {
        Map<String, PropertyAccessor> accessors = Beans.getLambdaFieldAndPropertyAccessors(rawClass);
        int size = accessors.size();
        if (size > 0) {
            HashMap<String, LambdaProperty> properties = new HashMap<String, LambdaProperty>(size);
            CaseInsensitiveMap<String, LambdaProperty> propertiesCaseInsensitive = new CaseInsensitiveMap<String, LambdaProperty>(new HashMap(size), true);
            for (Map.Entry<String, PropertyAccessor> entry : accessors.entrySet()) {
                String propertyName = entry.getKey();
                PropertyAccessor accessor = entry.getValue();
                Type type = accessor.type();
                LambdaMetaObject<T> meta = LambdaMetaObject.of(type);
                LambdaProperty lambdaProperty = new LambdaProperty(meta, accessor);
                properties.put(propertyName, lambdaProperty);
                propertiesCaseInsensitive.put(propertyName, lambdaProperty);
            }
            this.properties = Collections.unmodifiableMap(properties);
            this.propertiesCaseInsensitive = Collections.unmodifiableMap(propertiesCaseInsensitive);
            return true;
        }
        return false;
    }

    @Override
    protected Object getBeanPropertyOrSetDefault(@Nonnull T o, int caseModel, @Nonnull String name) {
        Object val;
        LambdaProperty property = this.properties.get(name);
        if (property == null || !property.accessor.hasGetter() || !property.accessor.hasSetter()) {
            String propertyCamelCase;
            if (LambdaMetaObject.isCaseInsensitive(caseModel)) {
                property = this.propertiesCaseInsensitive.get(name);
            }
            if (!(property != null && property.accessor.hasGetter() && property.accessor.hasSetter() || !LambdaMetaObject.isCaseCamel(caseModel) || (property = this.properties.get(propertyCamelCase = StringCases.underlineToCamelCase(name))) != null && property.accessor.hasGetter() && property.accessor.hasSetter() || !LambdaMetaObject.isCaseInsensitive(caseModel))) {
                property = this.propertiesCaseInsensitive.get(propertyCamelCase);
            }
            if (property == null || !property.accessor.hasGetter() || !property.accessor.hasSetter()) {
                MetaObject<?> rtMeta = this.createMetaObject(JavaType.of(o.getClass()));
                if (this.equals(rtMeta) || rtMeta.isObject() || rtMeta.isBasic() || rtMeta.isEnum()) {
                    log.debug("Unsupported property\uff1a{}:{}", this.getBeanType().getTypeName(), name);
                    return null;
                }
                return rtMeta.getPropertyOrSetDefault(o, caseModel, name);
            }
        }
        if ((val = property.accessor.get(o)) == null) {
            val = property.meta.newInstance();
            property.accessor.set(o, val);
        }
        return val;
    }

    @Override
    protected Object setBeanProperty(@Nonnull T o, int caseModel, @Nonnull String name, Object val) {
        LambdaProperty property = this.properties.get(name);
        if (property == null || !property.accessor.hasSetter()) {
            String propertyCamelCase;
            if (LambdaMetaObject.isCaseInsensitive(caseModel)) {
                property = this.propertiesCaseInsensitive.get(name);
            }
            if (!(property != null && property.accessor.hasSetter() || !LambdaMetaObject.isCaseCamel(caseModel) || (property = this.properties.get(propertyCamelCase = StringCases.underlineToCamelCase(name))) != null && property.accessor.hasSetter() || !LambdaMetaObject.isCaseInsensitive(caseModel))) {
                property = this.propertiesCaseInsensitive.get(propertyCamelCase);
            }
            if (property == null || !property.accessor.hasSetter()) {
                MetaObject<?> rtMeta = this.createMetaObject(JavaType.of(o.getClass()));
                if (this.equals(rtMeta) || rtMeta.isObject() || rtMeta.isBasic() || rtMeta.isEnum()) {
                    log.debug("Unsupported property\uff1a{}:{}", this.getBeanType().getTypeName(), name);
                    return null;
                }
                return rtMeta.setProperty(o, caseModel, name, val);
            }
        }
        val = Converters.convertQuietly(property.meta.getBeanType(), val);
        Object val1 = val;
        property.accessor.set(o, val1);
        return val;
    }

    @Override
    protected MetaObject<?> getBeanProperty(int caseModel, @Nonnull String name) {
        LambdaProperty property = this.properties.get(name);
        if (property == null) {
            String propertyCamelCase;
            if (LambdaMetaObject.isCaseInsensitive(caseModel)) {
                property = this.propertiesCaseInsensitive.get(name);
            }
            if (property == null && LambdaMetaObject.isCaseCamel(caseModel) && (property = this.properties.get(propertyCamelCase = StringCases.underlineToCamelCase(name))) == null && LambdaMetaObject.isCaseInsensitive(caseModel)) {
                property = this.propertiesCaseInsensitive.get(propertyCamelCase);
            }
            if (property == null) {
                log.debug("Unsupported property\uff1a{}:{}", this.getBeanType().getTypeName(), name);
                return null;
            }
        }
        return property.meta;
    }

    @Override
    protected Object getBeanProperty(@Nonnull T o, int caseModel, @Nonnull String name) {
        LambdaProperty property = this.properties.get(name);
        if (property == null || !property.accessor.hasGetter()) {
            String propertyCamelCase;
            if (LambdaMetaObject.isCaseInsensitive(caseModel)) {
                property = this.propertiesCaseInsensitive.get(name);
            }
            if (!(property != null && property.accessor.hasGetter() || !LambdaMetaObject.isCaseCamel(caseModel) || (property = this.properties.get(propertyCamelCase = StringCases.underlineToCamelCase(name))) != null && property.accessor.hasGetter() || !LambdaMetaObject.isCaseInsensitive(caseModel))) {
                property = this.propertiesCaseInsensitive.get(propertyCamelCase);
            }
            if (property == null || !property.accessor.hasGetter()) {
                MetaObject<?> rtMeta = this.createMetaObject(JavaType.of(o.getClass()));
                if (this.equals(rtMeta) || rtMeta.isObject() || rtMeta.isBasic() || rtMeta.isEnum()) {
                    log.debug("Unsupported property\uff1a{}:{}", this.getBeanType().getTypeName(), name);
                    return null;
                }
                return rtMeta.getProperty(o, caseModel, name);
            }
        }
        return property.accessor.get(o);
    }

    @Override
    protected boolean hasBeanProperty(@Nonnull T o, int caseModel, @Nonnull String name) {
        LambdaProperty property = this.properties.get(name);
        if (property == null || !property.accessor.hasGetter()) {
            String propertyCamelCase;
            if (LambdaMetaObject.isCaseInsensitive(caseModel)) {
                property = this.propertiesCaseInsensitive.get(name);
            }
            if (!(property != null && property.accessor.hasGetter() || !LambdaMetaObject.isCaseCamel(caseModel) || (property = this.properties.get(propertyCamelCase = StringCases.underlineToCamelCase(name))) != null && property.accessor.hasGetter() || !LambdaMetaObject.isCaseInsensitive(caseModel))) {
                property = this.propertiesCaseInsensitive.get(propertyCamelCase);
            }
            if (property == null || !property.accessor.hasGetter()) {
                MetaObject<?> rtMeta = this.createMetaObject(JavaType.of(o.getClass()));
                if (this.equals(rtMeta) || rtMeta.isObject() || rtMeta.isBasic() || rtMeta.isEnum()) {
                    return false;
                }
                return rtMeta.hasProperty(o, caseModel, name);
            }
        }
        return property.accessor.get(o) != null;
    }

    static class LambdaProperty {
        private final MetaObject<?> meta;
        private final PropertyAccessor accessor;

        LambdaProperty(MetaObject<?> meta, PropertyAccessor accessor) {
            this.meta = meta;
            this.accessor = accessor;
        }
    }
}

