/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean.property;

import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.bean.PropertyAccessor;
import io.polaris.core.lang.bean.property.PropertyBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

public abstract class AbstractPropertyBuilder<T>
implements PropertyBuilder<T> {
    private final Deque<Operation> actionQueue = new ArrayDeque<Operation>();
    protected Object lastOrig;
    protected boolean ignoredNull = true;

    private Operation newOperation(String origProperty, String destProperty, Object value) {
        Operation operation = new Operation();
        if (origProperty != null) {
            operation.orig = this.lastOrig;
            operation.origProperty = origProperty;
        }
        operation.destProperty = destProperty;
        operation.propertyValue = value;
        operation.ignoredNull = this.ignoredNull;
        return operation;
    }

    @Override
    public PropertyBuilder<T> from(Object orig) {
        this.lastOrig = orig;
        return this;
    }

    @Override
    public PropertyBuilder<T> ignoreNull(boolean ignored) {
        this.ignoredNull = ignored;
        return this;
    }

    @Override
    public PropertyBuilder<T> set(String destProperty, Object value) {
        Operation operation = this.newOperation(null, destProperty, value);
        this.actionQueue.add(operation);
        return this;
    }

    @Override
    public PropertyBuilder<T> mapAll() {
        if (this.lastOrig != null) {
            this.mapAll(this.lastOrig.getClass());
        }
        return this;
    }

    @Override
    public PropertyBuilder<T> mapAll(Class<?> clazz) {
        Map<String, PropertyAccessor> metadata = Beans.getIndexedPropertyAccessors(clazz);
        for (String name : metadata.keySet()) {
            this.map(name, name);
        }
        return this;
    }

    @Override
    public PropertyBuilder<T> map(String origProperty, String destProperty) {
        if (this.lastOrig != null) {
            Operation operation = this.newOperation(origProperty, destProperty, null);
            this.actionQueue.add(operation);
        }
        return this;
    }

    @Override
    public PropertyBuilder<T> exec() {
        Operation operation = null;
        while ((operation = this.actionQueue.poll()) != null) {
            this.exec(operation);
        }
        return this;
    }

    protected abstract void exec(Operation var1);

    protected static class Operation {
        Object orig;
        String origProperty;
        String destProperty;
        Object propertyValue;
        boolean ignoredNull = true;

        protected Operation() {
        }
    }
}

