/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.copier;

import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.copier.Copier;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class MapToMapCopier
implements Copier<Map> {
    private static final ILogger log = ILoggers.of(MapToMapCopier.class);
    private final Map source;
    private final Map target;
    private final Type targetType;
    private final CopyOptions options;

    public MapToMapCopier(Map source, Type targetType, Map target, CopyOptions options) {
        this.source = source;
        this.target = target;
        this.targetType = targetType != null ? targetType : target.getClass();
        this.options = options != null ? options : CopyOptions.create();
    }

    @Override
    public Map copy() {
        block9: {
            try {
                JavaType javaType = JavaType.of(this.targetType);
                Type valueType = javaType.getActualType(Map.class, 1);
                Type keyType = javaType.getActualType(Map.class, 0);
                Set set = this.source.entrySet();
                for (Map.Entry entry : set) {
                    Object sourceKey = entry.getKey();
                    Object value = entry.getValue();
                    if (sourceKey == null) continue;
                    try {
                        Object key = sourceKey;
                        if (key instanceof String) {
                            String key1 = key.toString();
                            String keyStr = this.options.editKey(key1);
                            if (keyStr == null || this.options.isIgnoredKey(keyStr)) continue;
                            value = this.options.editValue(keyStr, value);
                            value = this.options.convert(valueType, value);
                            key = this.options.convert(keyType, keyStr);
                        } else {
                            value = this.options.convert(valueType, value);
                            key = this.options.convert(keyType, key);
                        }
                        if (value == null && this.options.ignoreNull() || !this.options.override() && null != this.target.get(key)) continue;
                        this.target.put(key, value);
                    }
                    catch (Exception e) {
                        if (!this.options.ignoreError()) {
                            throw new IllegalArgumentException(e);
                        }
                        log.warn("\u590d\u5236\u5c5e\u6027[{}]\u5931\u8d25\uff1a{}", sourceKey, e.getMessage());
                        if (!log.isDebugEnabled()) continue;
                        log.debug(e.getMessage(), e);
                    }
                }
            }
            catch (Exception e) {
                if (!this.options.ignoreError()) {
                    throw new IllegalArgumentException(e);
                }
                log.warn("\u590d\u5236\u5c5e\u6027\u5931\u8d25\uff1a{}", e.getMessage());
                if (!log.isDebugEnabled()) break block9;
                log.debug(e.getMessage(), e);
            }
        }
        return this.target;
    }
}

