/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.primitive;

import io.polaris.core.lang.Numbers;
import io.polaris.core.random.Randoms;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nonnull;

public class Bytes {
    public static final ByteOrder DEFAULT_ORDER;
    public static final ByteOrder CPU_ENDIAN;

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(byte[] array) {
        return !Bytes.isEmpty(array);
    }

    public static byte[] resize(byte[] bytes, int newSize) {
        if (newSize < 0) {
            return bytes;
        }
        byte[] newArray = new byte[newSize];
        if (newSize > 0 && Bytes.isNotEmpty(bytes)) {
            System.arraycopy(bytes, 0, newArray, 0, Math.min(bytes.length, newSize));
        }
        return newArray;
    }

    public static byte[] join(byte[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (byte[] array : arrays) {
            if (!Bytes.isNotEmpty(array)) continue;
            length += array.length;
        }
        byte[] result = new byte[length];
        length = 0;
        for (byte[] array : arrays) {
            if (!Bytes.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static byte[][] split(byte[] array, int len) {
        int amount = array.length / len;
        int remainder = array.length % len;
        if (remainder != 0) {
            ++amount;
        }
        byte[][] arrays = new byte[amount][];
        for (int i = 0; i < amount; ++i) {
            byte[] arr;
            if (i == amount - 1 && remainder != 0) {
                arr = new byte[remainder];
                System.arraycopy(array, i * len, arr, 0, remainder);
            } else {
                arr = new byte[len];
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static int indexOf(byte[] array, byte value) {
        if (Bytes.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte value) {
        if (Bytes.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte value) {
        return Bytes.indexOf(array, value) > -1;
    }

    public static Byte[] wrap(byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Byte[0];
        }
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static byte[] unwrap(Byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new byte[0];
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Optional.ofNullable(values[i]).orElse((byte)0);
        }
        return array;
    }

    public static byte[] sub(byte[] array, int start, int end) {
        int length = array.length;
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new byte[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new byte[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static byte[] remove(byte[] array, int index) throws IllegalArgumentException {
        if (null == array) {
            return null;
        }
        int length = array.length;
        if (index < 0 || index >= length) {
            return array;
        }
        byte[] result = new byte[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static byte[] removeElement(byte[] array, byte element) throws IllegalArgumentException {
        return Bytes.remove(array, Bytes.indexOf(array, element));
    }

    public static byte[] reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        if (Bytes.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Bytes.swap(array, i, j);
        }
        return array;
    }

    public static byte[] reverse(byte[] array) {
        return Bytes.reverse(array, 0, array.length);
    }

    public static byte min(byte ... numberArray) {
        if (Bytes.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static byte max(byte ... numberArray) {
        if (Bytes.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static byte[] shuffle(byte[] array) {
        return Bytes.shuffle(array, Randoms.getRandom());
    }

    public static byte[] shuffle(byte[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            Bytes.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static byte[] swap(byte[] array, int index1, int index2) {
        if (Bytes.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static boolean isSorted(byte[] array) {
        return Bytes.isSortedAsc(array);
    }

    public static boolean isSortedAsc(byte[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDesc(byte[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return str.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] utf8Bytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return str.toString().getBytes();
    }

    public static byte[] bytes(String str) {
        return str.getBytes();
    }

    public static byte[] copy(byte[] array, int length) {
        return Arrays.copyOf(array, length);
    }

    public static byte[] copy(byte[] array, int from, int to) {
        return Arrays.copyOfRange(array, from, to);
    }

    public static byte[] concat(@Nonnull byte[] byteArray, byte[] ... byteArrays) {
        if (byteArrays.length == 0) {
            return byteArray;
        }
        int length = 0;
        for (byte[] bytes : byteArrays) {
            length += bytes.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] bytes : byteArrays) {
            System.arraycopy(bytes, 0, result, pos, bytes.length);
            pos += bytes.length;
        }
        return result;
    }

    public static int indexOf(byte[] array, byte[] target) {
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static byte intToByte(int intValue) {
        return (byte)intValue;
    }

    public static int byteToUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static short bytesToShort(byte[] bytes) {
        return Bytes.bytesToShort(bytes, DEFAULT_ORDER);
    }

    public static short bytesToShort(byte[] bytes, ByteOrder byteOrder) {
        return Bytes.bytesToShort(bytes, 0, byteOrder);
    }

    public static short bytesToShort(byte[] bytes, int start, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(bytes[start] & 0xFF | (bytes[start + 1] & 0xFF) << 8);
        }
        return (short)(bytes[start + 1] & 0xFF | (bytes[start] & 0xFF) << 8);
    }

    public static byte[] shortToBytes(short shortValue) {
        return Bytes.shortToBytes(shortValue, DEFAULT_ORDER);
    }

    public static byte[] shortToBytes(short shortValue, ByteOrder byteOrder) {
        byte[] b = new byte[2];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            b[0] = (byte)(shortValue & 0xFF);
            b[1] = (byte)(shortValue >> 8 & 0xFF);
        } else {
            b[1] = (byte)(shortValue & 0xFF);
            b[0] = (byte)(shortValue >> 8 & 0xFF);
        }
        return b;
    }

    public static int bytesToInt(byte[] bytes) {
        return Bytes.bytesToInt(bytes, DEFAULT_ORDER);
    }

    public static int bytesToInt(byte[] bytes, ByteOrder byteOrder) {
        return Bytes.bytesToInt(bytes, 0, byteOrder);
    }

    public static int bytesToInt(byte[] bytes, int start, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return bytes[start] & 0xFF | (bytes[1 + start] & 0xFF) << 8 | (bytes[2 + start] & 0xFF) << 16 | (bytes[3 + start] & 0xFF) << 24;
        }
        return bytes[3 + start] & 0xFF | (bytes[2 + start] & 0xFF) << 8 | (bytes[1 + start] & 0xFF) << 16 | (bytes[start] & 0xFF) << 24;
    }

    public static byte[] intToBytes(int intValue) {
        return Bytes.intToBytes(intValue, DEFAULT_ORDER);
    }

    public static byte[] intToBytes(int intValue, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return new byte[]{(byte)(intValue & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 24 & 0xFF)};
        }
        return new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
    }

    public static byte[] longToBytes(long longValue) {
        return Bytes.longToBytes(longValue, DEFAULT_ORDER);
    }

    public static byte[] longToBytes(long longValue, ByteOrder byteOrder) {
        byte[] result = new byte[8];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        } else {
            for (int i = result.length - 1; i >= 0; --i) {
                result[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        }
        return result;
    }

    public static long bytesToLong(byte[] bytes) {
        return Bytes.bytesToLong(bytes, DEFAULT_ORDER);
    }

    public static long bytesToLong(byte[] bytes, ByteOrder byteOrder) {
        return Bytes.bytesToLong(bytes, 0, byteOrder);
    }

    public static long bytesToLong(byte[] bytes, int start, ByteOrder byteOrder) {
        long values = 0L;
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 7; i >= 0; --i) {
                values <<= 8;
                values |= (long)(bytes[i + start] & 0xFF);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                values <<= 8;
                values |= (long)(bytes[i + start] & 0xFF);
            }
        }
        return values;
    }

    public static byte[] floatToBytes(float floatValue) {
        return Bytes.floatToBytes(floatValue, DEFAULT_ORDER);
    }

    public static byte[] floatToBytes(float floatValue, ByteOrder byteOrder) {
        return Bytes.intToBytes(Float.floatToIntBits(floatValue), byteOrder);
    }

    public static float bytesToFloat(byte[] bytes) {
        return Bytes.bytesToFloat(bytes, DEFAULT_ORDER);
    }

    public static float bytesToFloat(byte[] bytes, ByteOrder byteOrder) {
        return Float.intBitsToFloat(Bytes.bytesToInt(bytes, byteOrder));
    }

    public static byte[] doubleToBytes(double doubleValue) {
        return Bytes.doubleToBytes(doubleValue, DEFAULT_ORDER);
    }

    public static byte[] doubleToBytes(double doubleValue, ByteOrder byteOrder) {
        return Bytes.longToBytes(Double.doubleToLongBits(doubleValue), byteOrder);
    }

    public static double bytesToDouble(byte[] bytes) {
        return Bytes.bytesToDouble(bytes, DEFAULT_ORDER);
    }

    public static double bytesToDouble(byte[] bytes, ByteOrder byteOrder) {
        return Double.longBitsToDouble(Bytes.bytesToLong(bytes, byteOrder));
    }

    public static byte[] numberToBytes(Number number) {
        return Bytes.numberToBytes(number, DEFAULT_ORDER);
    }

    public static byte[] numberToBytes(Number number, ByteOrder byteOrder) {
        if (number instanceof Byte) {
            return new byte[]{number.byteValue()};
        }
        if (number instanceof Double) {
            return Bytes.doubleToBytes((Double)number, byteOrder);
        }
        if (number instanceof Long) {
            return Bytes.longToBytes((Long)number, byteOrder);
        }
        if (number instanceof Integer) {
            return Bytes.intToBytes((Integer)number, byteOrder);
        }
        if (number instanceof Short) {
            return Bytes.shortToBytes((Short)number, byteOrder);
        }
        if (number instanceof Float) {
            return Bytes.floatToBytes(((Float)number).floatValue(), byteOrder);
        }
        return Bytes.doubleToBytes(number.doubleValue(), byteOrder);
    }

    public static <T extends Number> T bytesToNumber(byte[] bytes, Class<T> targetClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Number number;
        if (Byte.class == targetClass || Byte.TYPE == targetClass) {
            number = bytes[0];
        } else if (Short.class == targetClass || Short.TYPE == targetClass) {
            number = Bytes.bytesToShort(bytes, byteOrder);
        } else if (Integer.class == targetClass || Integer.TYPE == targetClass) {
            number = Bytes.bytesToInt(bytes, byteOrder);
        } else if (AtomicInteger.class == targetClass) {
            number = new AtomicInteger(Bytes.bytesToInt(bytes, byteOrder));
        } else if (Long.class == targetClass || Long.TYPE == targetClass) {
            number = Bytes.bytesToLong(bytes, byteOrder);
        } else if (AtomicLong.class == targetClass) {
            number = new AtomicLong(Bytes.bytesToLong(bytes, byteOrder));
        } else if (LongAdder.class == targetClass) {
            LongAdder longValue = new LongAdder();
            longValue.add(Bytes.bytesToLong(bytes, byteOrder));
            number = longValue;
        } else if (Float.class == targetClass || Float.TYPE == targetClass) {
            number = Float.valueOf(Bytes.bytesToFloat(bytes, byteOrder));
        } else if (Double.class == targetClass || Double.TYPE == targetClass) {
            number = Bytes.bytesToDouble(bytes, byteOrder);
        } else if (DoubleAdder.class == targetClass) {
            DoubleAdder doubleAdder = new DoubleAdder();
            doubleAdder.add(Bytes.bytesToDouble(bytes, byteOrder));
            number = doubleAdder;
        } else if (BigDecimal.class == targetClass) {
            number = Numbers.toBigDecimal(Bytes.bytesToDouble(bytes, byteOrder));
        } else if (BigInteger.class == targetClass) {
            number = BigInteger.valueOf(Bytes.bytesToLong(bytes, byteOrder));
        } else if (Number.class == targetClass) {
            number = Bytes.bytesToDouble(bytes, byteOrder);
        } else {
            throw new IllegalArgumentException("Unsupported Number type: " + targetClass.getName());
        }
        return (T)number;
    }

    static {
        ByteOrder byteOrder;
        DEFAULT_ORDER = ByteOrder.BIG_ENDIAN;
        try {
            byteOrder = ByteOrder.nativeOrder();
        }
        catch (Throwable e) {
            byteOrder = "little".equals(System.getProperty("sun.cpu.endian")) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }
        CPU_ENDIAN = byteOrder;
    }
}

