/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log;

import io.polaris.core.log.ILogResolver;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.support.DefaultLoggerResolver;
import io.polaris.core.log.support.StdoutLogger;
import io.polaris.core.string.Strings;

public class ILoggers {
    private static ILogResolver RESOLVER = new DefaultLoggerResolver();

    public static ILogger of(Class<?> c) {
        if (RESOLVER == null) {
            return new StdoutLogger(c.getName());
        }
        return RESOLVER.getLogger(c);
    }

    public static ILogger of(String name) {
        if (RESOLVER == null) {
            return new StdoutLogger(name);
        }
        return RESOLVER.getLogger(name);
    }

    public static ILogger of() {
        return ILoggers.of(ILoggers.detectLoggerName());
    }

    private static String detectLoggerName() {
        String name = null;
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < elements.length; ++i) {
            String className = elements[i].getClassName();
            if (ILoggers.class.getName().equals(className)) continue;
            name = className;
            break;
        }
        return Strings.coalesce(name, "");
    }

    public static void setResolver(ILogResolver resolver) {
        RESOLVER = resolver;
    }
}

