/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.log.support;

import io.polaris.core.log.ILogResolver;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.support.Slf4jAwareLogger;
import io.polaris.core.log.support.Slf4jLogger;
import io.polaris.core.log.support.StdoutLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class DefaultLoggerResolver
implements ILogResolver {
    private final Map<String, ILogger> CACHE = new ConcurrentHashMap<String, ILogger>();

    @Override
    public ILogger getLogger(String name) {
        return this.CACHE.computeIfAbsent(name, k -> this.newLogger(name));
    }

    private ILogger newLogger(String name) {
        ILogger logger = DefaultLoggerResolver.getDirectSlf4jLogger(name);
        if (logger != null) {
            return logger;
        }
        return new StdoutLogger(name);
    }

    private static ILogger getDirectSlf4jLogger(String name) {
        try {
            Logger logger = LoggerFactory.getLogger((String)name);
            if (logger instanceof LocationAwareLogger) {
                return new Slf4jAwareLogger((LocationAwareLogger)logger);
            }
            return new Slf4jLogger(logger);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

