/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.service;

import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.service.Service;
import io.polaris.core.service.ServiceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class StatefulServiceLoader<S>
implements Iterable<S> {
    private static final ILogger log = ILoggers.of(StatefulServiceLoader.class);
    private static final Map<Class<?>, State<?>> store = new ConcurrentHashMap();
    private final ServiceLoader<S> serviceLoader;

    private StatefulServiceLoader(ServiceLoader<S> serviceLoader) {
        this.serviceLoader = serviceLoader;
    }

    private StatefulServiceLoader(Class<S> service, ClassLoader loader) {
        this(ServiceLoader.of(service, loader));
    }

    public static <S> StatefulServiceLoader<S> load(Class<S> service) {
        return StatefulServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> StatefulServiceLoader<S> load(Class<S> service, ClassLoader classLoader) {
        Object object;
        StatefulServiceLoader<Object> loader = null;
        State<?> ref = store.get(service);
        if (ref == null) {
            object = store;
            synchronized (object) {
                ref = store.get(service);
                if (ref == null) {
                    loader = new StatefulServiceLoader<S>(service, classLoader);
                    ref = new State(classLoader, loader);
                    store.put(service, ref);
                }
            }
        }
        if (loader == null && (loader = ref.getByClassLoader(classLoader)) == null) {
            object = ref;
            synchronized (object) {
                loader = ref.getByClassLoader(classLoader);
                if (loader == null) {
                    loader = new StatefulServiceLoader<S>(service, classLoader);
                    ref.update(classLoader, loader);
                }
            }
        }
        return loader;
    }

    public static <S> void clear(Class<S> service) {
        store.computeIfPresent(service, (k, v) -> {
            ((State)v).map.clear();
            return null;
        });
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            final Iterator<Service<S>> iter;
            {
                this.iter = StatefulServiceLoader.this.serviceLoader.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public S next() {
                return this.iter.next().getSingleton();
            }
        };
    }

    public ServiceLoader<S> serviceLoader() {
        return this.serviceLoader;
    }

    public Optional<S> optionalService() {
        return Optional.ofNullable(this.serviceLoader.get()).map(s -> {
            try {
                return s.getSingleton();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                return null;
            }
        });
    }

    @Nullable
    public S service() {
        return this.optionalService().orElse(null);
    }

    @Nullable
    public S service(String propertyName, String propertyValue) {
        return Optional.ofNullable(this.serviceLoader.get(propertyName, propertyValue)).map(s -> {
            try {
                return s.getSingleton();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                return null;
            }
        }).orElse(null);
    }

    public List<S> serviceList() {
        ArrayList<S> list = new ArrayList<S>();
        for (Service<S> service : this.serviceLoader) {
            try {
                list.add(service.getSingleton());
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        return list;
    }

    public Map<String, S> serviceMap() {
        HashMap map = new HashMap();
        this.serviceLoader.getNamings().forEach((? super K k, ? super V v) -> {
            try {
                map.put(k, v.getSingleton());
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        });
        return map;
    }

    static class State<S> {
        private Map<ClassLoader, StatefulServiceLoader<S>> map = new ConcurrentHashMap<ClassLoader, StatefulServiceLoader<S>>();
        private ClassLoader lastClassLoader;
        private StatefulServiceLoader<S> lastServiceLoader;

        State(ClassLoader lastClassLoader, StatefulServiceLoader<S> lastServiceLoader) {
            this.update(lastClassLoader, lastServiceLoader);
        }

        void update(ClassLoader lastClassLoader, StatefulServiceLoader<S> lastServiceLoader) {
            this.lastClassLoader = lastClassLoader;
            this.lastServiceLoader = lastServiceLoader;
            this.map.put(lastClassLoader, lastServiceLoader);
        }

        StatefulServiceLoader<S> getByClassLoader(ClassLoader loader) {
            if (this.lastClassLoader == loader) {
                return this.lastServiceLoader;
            }
            return this.map.get(loader);
        }

        ClassLoader getLastClassLoader() {
            return this.lastClassLoader;
        }

        StatefulServiceLoader<S> getLastServiceLoader() {
            return this.lastServiceLoader;
        }
    }
}

