/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.string;

import io.polaris.core.collection.Iterables;
import io.polaris.core.collection.PrimitiveArrays;
import io.polaris.core.consts.StdConsts;
import io.polaris.core.lang.primitive.Chars;
import io.polaris.core.regex.Patterns;
import io.polaris.core.string.StringCases;
import io.polaris.core.tuple.Ref;
import io.polaris.core.tuple.ValueRef;
import io.polaris.core.ulid.UlidCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class Strings {
    private static final ThreadLocal<Map<String, Ref<String>>> resolvedKeysLocal = new ThreadLocal();
    private static final Pattern patternPlaceholder = Pattern.compile("\\$\\{([\\w\\.\\-]+)(?:(:-?)([^${}]*))?\\}");
    private static final Pattern patternDigits = Pattern.compile("(?<!\\\\)\\{(\\d+)\\}");
    private static final Pattern patternEmpty = Pattern.compile("(?<!\\\\)\\{\\}");

    public static String toReadableByteSizeStr(long byteSize) {
        long b = byteSize % 1024L;
        long k = byteSize / 1024L;
        if (k == 0L) {
            return b + "B";
        }
        long m = k / 1024L;
        k %= 1024L;
        if (m == 0L) {
            return k + "K " + (b == 0L ? "" : b + "B");
        }
        long g = m / 1024L;
        m %= 1024L;
        if (g == 0L) {
            return m + "M " + (k == 0L ? "" : k + "K ") + (b == 0L ? "" : b + "B");
        }
        long t = g / 1024L;
        return (t == 0L ? "" : t + "T ") + (g == 0L ? "" : (g %= 1024L) + "G ") + (m == 0L ? "" : m + "M ") + (k == 0L ? "" : k + "K ") + (b == 0L ? "" : b + "B");
    }

    public static String truncate(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength);
    }

    public static String padStart(String str, int minLength, char pad) {
        if ((str = Strings.coalesce(str, "")).length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(pad);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padEnd(String str, int minLength, char pad) {
        if ((str = Strings.coalesce(str, "")).length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(str);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public static String repeat(char ch, int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    public static String repeat(String str, int count) {
        int n;
        if (str == null) {
            return null;
        }
        if (count <= 0) {
            return "";
        }
        if (count == 1) {
            return str;
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] array = new char[size];
        str.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static <T> T nvl(T o, T reo) {
        if (Strings.isEmpty(o)) {
            return reo;
        }
        return o;
    }

    public static String coalesce(String ... args) {
        String arg;
        String v = null;
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n && !Strings.isNotBlank(v = (arg = stringArray[i])); ++i) {
        }
        return v;
    }

    public static String coalesceNull(String ... args) {
        String arg;
        String v = null;
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n && (v = (arg = stringArray[i])) == null; ++i) {
        }
        return v;
    }

    public static String coalesceEmpty(String ... args) {
        String arg;
        String v = null;
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n && !Strings.isNotEmpty(v = (arg = stringArray[i])); ++i) {
        }
        return v;
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String ulid() {
        return UlidCreator.getUlid().toString();
    }

    public static String normalize(String name) {
        return name == null ? "" : name.trim().replaceAll("\\W", "_");
    }

    public static String decapitalize(String name) {
        return StringCases.decapitalize(name);
    }

    public static String capitalize(String name) {
        return StringCases.capitalize(name);
    }

    public static String getSystemProperty(String key) {
        String val = System.getProperty(key);
        if (val != null) {
            return Strings.resolvePlaceholders(val, Strings::getSystemProperty);
        }
        val = System.getenv(key);
        if (val != null) {
            return Strings.resolvePlaceholders(val, Strings::getSystemProperty);
        }
        int len = key.length();
        StringBuilder sb = new StringBuilder(len + 16);
        sb.append(Character.toUpperCase(key.charAt(0)));
        for (int i = 1; i < len; ++i) {
            char c = key.charAt(i);
            if (c == '.') {
                sb.append("_");
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append("_").append(c);
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        String envKey = sb.toString();
        val = System.getenv(envKey);
        if (val != null) {
            return Strings.resolvePlaceholders(val, Strings::getSystemProperty);
        }
        return null;
    }

    public static String resolvePlaceholders(String origin, Function<String, String> getter) {
        return Strings.resolvePlaceholders(origin, patternPlaceholder, getter);
    }

    public static String resolvePlaceholders(String origin, Function<String, String> getter, boolean defaultAsEmpty) {
        return Strings.resolvePlaceholders(origin, patternPlaceholder, getter, defaultAsEmpty);
    }

    public static String resolvePlaceholders(String origin, Pattern placeholderPattern, Function<String, String> getter) {
        return Strings.resolvePlaceholders(origin, placeholderPattern, getter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolvePlaceholders(String origin, Pattern placeholderPattern, Function<String, String> getter, boolean defaultAsEmpty) {
        if (origin == null) {
            return origin;
        }
        boolean hasInit = false;
        Map<String, Ref<String>> resovedKeys = resolvedKeysLocal.get();
        if (resovedKeys == null) {
            hasInit = true;
            resovedKeys = new HashMap<String, Ref<String>>();
            resolvedKeysLocal.set(resovedKeys);
        }
        try {
            Matcher matcher = placeholderPattern.matcher(origin);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String separator;
                String group = matcher.group();
                if (resovedKeys.containsKey(group)) {
                    matcher.appendReplacement(sb, resovedKeys.get(group).get());
                    continue;
                }
                String k = matcher.group(1);
                int groupCount = matcher.groupCount();
                String string = separator = groupCount >= 3 ? matcher.group(2) : ":";
                String defVal = groupCount >= 3 ? matcher.group(3) : (groupCount == 2 ? matcher.group(2) : null);
                String v = null;
                if (resovedKeys.containsKey(k)) {
                    v = resovedKeys.get(k).get();
                } else {
                    resovedKeys.put(k, ValueRef.of(null));
                    v = getter.apply(k);
                    resovedKeys.put(k, new ValueRef<String>(v));
                }
                if (defVal != null && (v == null || v.isEmpty() && separator != null && separator.length() > 1)) {
                    v = defVal;
                }
                String replacement = v == null ? (defaultAsEmpty ? "" : group) : v;
                replacement = replacement.replace("\\", "\\\\").replace("$", "\\$");
                resovedKeys.put(group, new ValueRef<String>(replacement));
                matcher.appendReplacement(sb, replacement);
            }
            matcher.appendTail(sb);
            String rs = sb.toString();
            boolean hasNextMatcher = false;
            Matcher nextMatcher = placeholderPattern.matcher(rs);
            while (nextMatcher.find()) {
                String group = nextMatcher.group();
                if (resovedKeys.containsKey(group)) continue;
                hasNextMatcher = true;
                break;
            }
            if (hasNextMatcher) {
                rs = Strings.resolvePlaceholders(rs, placeholderPattern, getter, defaultAsEmpty);
            }
            String string = rs;
            return string;
        }
        finally {
            if (hasInit) {
                resolvedKeysLocal.get().clear();
                resolvedKeysLocal.remove();
            }
        }
    }

    public static String filter(CharSequence str, Predicate<Character> filter) {
        if (str == null || filter == null) {
            return Objects.toString(str, "");
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!filter.test(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String cleanBlank(CharSequence str) {
        return Strings.filter(str, c -> !Chars.isBlankChar(c.charValue()));
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (Strings.isEmpty(str) || Strings.isEmpty(prefix)) {
            return Objects.toString(str, "");
        }
        String str1 = str.toString();
        if (str1.startsWith(prefix.toString())) {
            return str1.substring(prefix.length());
        }
        return str1;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (Strings.isEmpty(str) || Strings.isEmpty(suffix)) {
            return Objects.toString(str, "");
        }
        String str1 = str.toString();
        if (str1.endsWith(suffix.toString())) {
            return str1.substring(0, str.length() - suffix.length());
        }
        return str1;
    }

    public static String trimToEmpty(String str) {
        if (str == null) {
            return "";
        }
        return Strings.trim(str);
    }

    public static String trimToNull(String str) {
        if (str != null && (str = Strings.trim(str)).length() > 0) {
            return str;
        }
        return null;
    }

    public static String trim(String str) {
        int begin;
        if (str == null || str.isEmpty()) {
            return str;
        }
        int end = str.length() - 1;
        for (begin = 0; begin <= end && Character.isWhitespace(str.charAt(begin)); ++begin) {
        }
        while (end > begin && Character.isWhitespace(str.charAt(end))) {
            --end;
        }
        return str.substring(begin, end + 1);
    }

    public static String trimStart(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (!Character.isWhitespace(str.charAt(0))) {
            return str;
        }
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            start = i;
            break;
        }
        return str.substring(start);
    }

    public static String trimEnd(String str) {
        int end;
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (!Character.isWhitespace(str.charAt(str.length() - 1))) {
            return str;
        }
        for (int i = end = str.length(); i > 0; --i) {
            if (Character.isWhitespace(str.charAt(i - 1))) continue;
            end = i;
            break;
        }
        return str.substring(0, end);
    }

    public static String trim(String str, char ch) {
        int begin;
        if (str == null || str.isEmpty()) {
            return str;
        }
        int end = str.length() - 1;
        for (begin = 0; begin <= end && ch == str.charAt(begin); ++begin) {
        }
        while (end > begin && ch == str.charAt(end)) {
            --end;
        }
        return str.substring(begin, end + 1);
    }

    public static String trimStart(String str, char ch) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (ch != str.charAt(0)) {
            return str;
        }
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (ch == str.charAt(i)) continue;
            start = i;
            break;
        }
        return str.substring(start);
    }

    public static String trimEnd(String str, char ch) {
        int end;
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (ch != str.charAt(str.length() - 1)) {
            return str;
        }
        for (int i = end = str.length(); i > 0; --i) {
            if (ch == str.charAt(i - 1)) continue;
            end = i;
            break;
        }
        return str.substring(0, end);
    }

    public static boolean isEmpty(Object o) {
        return o == null || "".equals(o);
    }

    public static boolean isNotEmpty(Object o) {
        return !Strings.isEmpty(o);
    }

    public static boolean isNotNone(CharSequence str) {
        return !Strings.isNone(str);
    }

    public static boolean isNone(CharSequence cs) {
        return Strings.isBlank(cs) || "null".equals(cs.toString());
    }

    public static boolean isNotBlank(CharSequence str) {
        return !Strings.isBlank(str);
    }

    public static boolean isBlank(CharSequence str) {
        if (Strings.isEmpty(str)) {
            return true;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !Strings.isEmpty(str);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!Strings.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!PrimitiveArrays.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (str == null || testStrs.length == 0) {
            return null;
        }
        String s = str.toString();
        for (CharSequence checkStr : testStrs) {
            if (!s.contains(checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        if (str == null || testStrs.length == 0) {
            return false;
        }
        String s = str.toString();
        for (CharSequence checkStr : testStrs) {
            if (!s.contains(checkStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (str == null || testStrs.length == 0) {
            return false;
        }
        String s = str.toString();
        for (CharSequence checkStr : testStrs) {
            if (!Strings.containsIgnoreCase(s, checkStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence str, CharSequence testStr) {
        if (str == null) {
            return false;
        }
        if (testStr == null || testStr.length() == 0) {
            return true;
        }
        if (str.length() == 0) {
            return false;
        }
        return str.toString().contains(testStr);
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (str == null) {
            return false;
        }
        if (testStr == null || testStr.length() == 0) {
            return true;
        }
        if (str.length() == 0) {
            return false;
        }
        return Strings.indexOfIgnoreCase(str, testStr) >= 0;
    }

    public static boolean startsWithAny(CharSequence str, CharSequence ... testStrs) {
        if (str == null || testStrs.length == 0) {
            return false;
        }
        String s = str.toString();
        for (CharSequence checkStr : testStrs) {
            if (!Strings.startsWith(s, checkStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        if (str == null) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        if (str.length() == 0) {
            return false;
        }
        return str.toString().startsWith(prefix.toString());
    }

    public static boolean endsWithAny(CharSequence str, CharSequence ... testStrs) {
        if (str == null || testStrs.length == 0) {
            return false;
        }
        String s = str.toString();
        for (CharSequence checkStr : testStrs) {
            if (!Strings.endsWith(s, checkStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        if (str == null) {
            return false;
        }
        if (suffix == null || suffix.length() == 0) {
            return true;
        }
        if (str.length() == 0) {
            return false;
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static boolean startsWithAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (str == null || testStrs.length == 0) {
            return false;
        }
        String s = str.toString();
        for (CharSequence checkStr : testStrs) {
            if (!Strings.startsWithIgnoreCase(s, checkStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        if (str == null) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        if (str.length() == 0) {
            return false;
        }
        return str.toString().regionMatches(true, 0, prefix.toString(), 0, prefix.length());
    }

    public static boolean endsWithAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (str == null || testStrs.length == 0) {
            return false;
        }
        String s = str.toString();
        for (CharSequence checkStr : testStrs) {
            if (!Strings.endsWithIgnoreCase(s, checkStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        if (str == null) {
            return false;
        }
        if (suffix == null || suffix.length() == 0) {
            return true;
        }
        if (str.length() == 0) {
            return false;
        }
        return str.toString().regionMatches(true, str.length() - suffix.length(), suffix.toString(), 0, suffix.length());
    }

    public static int indexOf(CharSequence source, CharSequence target) {
        if (source == null || target == null) {
            return -1;
        }
        return source.toString().indexOf(target.toString());
    }

    public static int indexOfIgnoreCase(CharSequence source, CharSequence target) {
        return Strings.indexOfIgnoreCase(source.toString().toCharArray(), 0, source.length(), target.toString().toCharArray(), 0, target.length(), 0);
    }

    public static int indexOfIgnoreCase(CharSequence source, CharSequence target, int fromIndex) {
        return Strings.indexOfIgnoreCase(source.toString().toCharArray(), 0, source.length(), target.toString().toCharArray(), 0, target.length(), fromIndex);
    }

    public static int indexOfIgnoreCase(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = Character.toUpperCase(target[targetOffset]);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (Character.toUpperCase(source[i]) != first) {
                while (++i <= max && Character.toUpperCase(source[i]) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && Character.toUpperCase(source[j]) == Character.toUpperCase(target[k])) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence source, CharSequence target) {
        return Strings.lastIndexOfIgnoreCase(source.toString().toCharArray(), 0, source.length(), target.toString().toCharArray(), 0, target.length(), source.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence source, CharSequence target, int fromIndex) {
        return Strings.lastIndexOfIgnoreCase(source.toString().toCharArray(), 0, source.length(), target.toString().toCharArray(), 0, target.length(), fromIndex);
    }

    public static int lastIndexOfIgnoreCase(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = Character.toUpperCase(target[strLastIndex]);
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && Character.toUpperCase(source[i]) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (Character.toUpperCase(source[j--]) == Character.toUpperCase(target[k--])) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        for (CharSequence str : strs) {
            if (!Strings.equals(str1, str)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(CharSequence str1, CharSequence ... strs) {
        for (CharSequence str : strs) {
            if (!Strings.equalsIgnoreCase(str1, str)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        if (str1.length() != str2.length()) {
            return false;
        }
        return str1.toString().equals(str2.toString());
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        if (str1.length() != str2.length()) {
            return false;
        }
        return str1.toString().equalsIgnoreCase(str2.toString());
    }

    public static boolean equalsIgnoreCase(char[] cs1, char[] cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        int len = cs1.length;
        if (len != cs2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.toUpperCase(cs1[i]) == Character.toUpperCase(cs2[i])) continue;
            return false;
        }
        return true;
    }

    public static String getIfMatch(String str, String ... args) {
        int i = 0;
        while (i + 1 < args.length) {
            if (Patterns.matches(args[i], (CharSequence)str)) {
                return args[i + 1];
            }
            i += 2;
        }
        if ((args.length & 1) == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    public static String getIfEquals(String str, String ... args) {
        int i = 0;
        while (i + 1 < args.length) {
            if (Strings.equals(args[i], str)) {
                return args[i + 1];
            }
            i += 2;
        }
        if ((args.length & 1) == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    public static CharSequence getIfEquals(CharSequence str, CharSequence ... args) {
        int i = 0;
        while (i + 1 < args.length) {
            if (Strings.equals(args[i], str)) {
                return args[i + 1];
            }
            i += 2;
        }
        if ((args.length & 1) == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    public static String getIfEqualsIgnoreCase(String str, String ... args) {
        int i = 0;
        while (i + 1 < args.length) {
            if (Strings.equalsIgnoreCase(args[i], str)) {
                return args[i + 1];
            }
            i += 2;
        }
        if ((args.length & 1) == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    public static CharSequence getIfEqualsIgnoreCase(CharSequence str, CharSequence ... args) {
        int i = 0;
        while (i + 1 < args.length) {
            if (Strings.equalsIgnoreCase(args[i], str)) {
                return args[i + 1];
            }
            i += 2;
        }
        if ((args.length & 1) == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    public static <T extends Collection<E>, E> T splitToCollection(Supplier<T> supplier, Function<String, E> converter, String str, String delimiterRegex) {
        return Strings.asCollection(supplier, converter, str.split(delimiterRegex));
    }

    public static <T extends Collection<String>> T splitToCollection(Supplier<T> supplier, String str, String delimiterRegex) {
        return Strings.asCollection(supplier, str.split(delimiterRegex));
    }

    public static <E> Set<E> splitToSet(String str, Function<String, E> converter, String delimiterRegex) {
        return Strings.asCollection(HashSet::new, converter, str.split(delimiterRegex));
    }

    public static Set<String> splitToSet(String str, String delimiterRegex) {
        return Strings.asCollection(HashSet::new, str.split(delimiterRegex));
    }

    public static <E> List<E> splitToList(String str, Function<String, E> converter, String delimiterRegex) {
        return Strings.asCollection(ArrayList::new, converter, str.split(delimiterRegex));
    }

    public static List<String> splitToList(String str, String delimiterRegex) {
        return Strings.asCollection(ArrayList::new, str.split(delimiterRegex));
    }

    public static <T extends Collection<E>, E> T splitToCollection(Supplier<T> supplier, Function<String, E> converter, String str) {
        return Strings.asCollection(supplier, converter, str.split(","));
    }

    public static <T extends Collection<String>> T splitToCollection(Supplier<T> supplier, String str) {
        return Strings.asCollection(supplier, str.split(","));
    }

    public static <E> Set<E> splitToSet(String str, Function<String, E> converter) {
        return Strings.asCollection(HashSet::new, converter, str.split(","));
    }

    public static Set<String> splitToSet(String str) {
        return Strings.asCollection(HashSet::new, str.split(","));
    }

    public static <E> List<E> splitToList(String str, Function<String, E> converter) {
        return Strings.asCollection(ArrayList::new, converter, str.split(","));
    }

    public static List<String> splitToList(String str) {
        return Strings.asCollection(ArrayList::new, str.split(","));
    }

    public static String[] tokenizeToArray(@Nullable String str, String delimiters) {
        return Strings.tokenizeToArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToArray(@Nullable String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        return Strings.tokenizeToArray(str, delimiters, trimTokens, ignoreEmptyTokens, null);
    }

    public static String[] tokenizeToArray(@Nullable String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens, Function<String, String> converter) {
        if (str == null) {
            return StdConsts.EMPTY_STRING_ARRAY;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.isEmpty()) continue;
            if (converter != null) {
                token = converter.apply(token);
            }
            tokens.add(token);
        }
        return Strings.toArray(tokens);
    }

    public static String[] delimitedToArray(@Nullable String str, String delimiters) {
        return Strings.delimitedToArray(str, delimiters, true, true);
    }

    public static String[] delimitedToArray(@Nullable String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        return Strings.delimitedToArray(str, delimiters, trimTokens, ignoreEmptyTokens, null);
    }

    public static String[] delimitedToArray(@Nullable String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens, Function<String, String> converter) {
        if (str == null) {
            return StdConsts.EMPTY_STRING_ARRAY;
        }
        String[] arr = str.split(Pattern.quote(delimiters));
        if (!trimTokens && !ignoreEmptyTokens && converter == null) {
            return arr;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : arr) {
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.isEmpty()) continue;
            if (converter != null) {
                token = converter.apply(token);
            }
            tokens.add(token);
        }
        return Strings.toArray(tokens);
    }

    public static String[] toArray(@Nullable Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return StdConsts.EMPTY_STRING_ARRAY;
        }
        return collection.toArray(new String[0]);
    }

    public static String[] toArray(@Nullable Enumeration<String> enumeration) {
        return enumeration != null ? Strings.toArray(Collections.list(enumeration)) : StdConsts.EMPTY_STRING_ARRAY;
    }

    public static String[] toArray(@Nullable Iterator<String> iterator) {
        return iterator != null ? Strings.toArray(Iterables.asList(iterator)) : StdConsts.EMPTY_STRING_ARRAY;
    }

    public static <T extends Collection<E>, E> T asCollection(Supplier<T> supplier, Function<String, E> converter, String ... args) {
        Collection t = (Collection)supplier.get();
        for (String arg : args) {
            t.add(converter.apply(arg));
        }
        return (T)t;
    }

    public static <T extends Collection<String>> T asCollection(Supplier<T> supplier, String ... args) {
        Collection t = (Collection)supplier.get();
        t.addAll(Arrays.asList(args));
        return (T)t;
    }

    public static Set<String> asSet(String ... args) {
        return Strings.asCollection(HashSet::new, args);
    }

    public static <E> Set<E> asSet(Function<String, E> converter, String ... args) {
        return Strings.asCollection(HashSet::new, converter, args);
    }

    public static <E> List<E> asList(Function<String, E> converter, String ... args) {
        return Strings.asCollection(ArrayList::new, converter, args);
    }

    public static <T extends Map<String, String>> T asMap(Supplier<T> supplier, String ... args) {
        Map map = (Map)supplier.get();
        int i = 0;
        while (i + 1 < args.length) {
            map.put(args[i], args[i + 1]);
            i += 2;
        }
        return (T)map;
    }

    public static Map<String, String> asMap(String ... args) {
        return Strings.asMap(HashMap::new, args);
    }

    public static String join(CharSequence delimiter, CharSequence ... arr) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence s : arr) {
            if (Strings.isBlank(s)) continue;
            joiner.add(s);
        }
        return joiner.toString();
    }

    public static String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix, CharSequence[] arr) {
        StringJoiner joiner = new StringJoiner(delimiter, prefix, suffix);
        for (CharSequence s : arr) {
            if (Strings.isBlank(s)) continue;
            joiner.add(s);
        }
        return joiner.toString();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> arr) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence charSequence : arr) {
            if (Strings.isBlank(charSequence)) continue;
            joiner.add(charSequence);
        }
        return joiner.toString();
    }

    public static String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix, Iterable<? extends CharSequence> arr) {
        StringJoiner joiner = new StringJoiner(delimiter, prefix, suffix);
        for (CharSequence charSequence : arr) {
            if (Strings.isBlank(charSequence)) continue;
            joiner.add(charSequence);
        }
        return joiner.toString();
    }

    public static String format(String msg, Object ... args) {
        int i;
        if (msg == null || msg.isEmpty()) {
            if (args.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(args[0]);
            for (int i2 = 1; i2 < args.length; ++i2) {
                sb.append(", ").append(args[i2]);
            }
            return sb.toString();
        }
        if (args.length == 0) {
            return msg;
        }
        BitSet bitSet = new BitSet();
        StringBuffer sb = new StringBuffer();
        Matcher matcher = patternDigits.matcher(msg);
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            bitSet.set(i);
            matcher.appendReplacement(sb, String.valueOf(i < args.length ? args[i] : null).replace("\\", "\\\\").replace("$", "\\$"));
        }
        matcher.appendTail(sb);
        msg = sb.toString();
        if (msg.contains("{}")) {
            sb.setLength(0);
            matcher = patternEmpty.matcher(msg);
            i = 0;
            while (matcher.find()) {
                while (bitSet.get(i)) {
                    ++i;
                }
                matcher.appendReplacement(sb, String.valueOf(i < args.length ? args[i] : null).replace("\\", "\\\\").replace("$", "\\$"));
                bitSet.set(i);
            }
            matcher.appendTail(sb);
            msg = sb.toString();
        } else if (bitSet.cardinality() >= args.length) {
            return msg;
        }
        if (bitSet.cardinality() < args.length) {
            for (i = 0; i < args.length; ++i) {
                if (bitSet.get(i)) continue;
                sb.append(", ").append(String.valueOf(args[i]));
            }
            return sb.toString();
        }
        return msg;
    }

    public static int toInt(String str, int def) {
        if (str == null) {
            return def;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static Integer toInteger(String str) {
        return Strings.toInteger(str, null);
    }

    public static Integer toInteger(String str, Integer def) {
        if (str == null) {
            return def;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static long toLong(String str, long def) {
        if (str == null) {
            return def;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static Long toLong(String str) {
        return Strings.toLong(str, null);
    }

    public static Long toLong(String str, Long def) {
        if (str == null) {
            return def;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static double toDouble(String str, double def) {
        return Strings.toDouble(str, (Double)def);
    }

    public static Double toDouble(String str, Double def) {
        if (str == null) {
            return def;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static Double toDouble(String str) {
        return Strings.toDouble(str, null);
    }

    public static boolean toBoolean(String str, boolean def) {
        return Strings.toBoolean(str, (Boolean)def);
    }

    public static Boolean toBoolean(String str, Boolean def) {
        if (str == null) {
            return def;
        }
        try {
            return Boolean.parseBoolean(str);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static Boolean toBoolean(String str) {
        return Strings.toBoolean(str, null);
    }
}

