/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.aop;

import io.polaris.core.aop.Advice;
import io.polaris.core.aop.Advisor;
import io.polaris.core.aop.AfterAdvice;
import io.polaris.core.aop.AroundAdvice;
import io.polaris.core.aop.AroundInvocation;
import io.polaris.core.aop.BeforeAdvice;
import io.polaris.core.aop.FinallyAdvice;
import io.polaris.core.aop.FixedAdvice;
import io.polaris.core.aop.ThrowingAdvice;
import io.polaris.core.asm.proxy.Invocation;
import io.polaris.core.tuple.ValueRef;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class DefaultAdvisor
implements Advisor {
    private final BeforeAdvice[] beforeAdvices;
    private final FixedAdvice[] fixedAdvices;
    private final AroundAdvice[] aroundAdvices;
    private final AfterAdvice[] afterAdvices;
    private final ThrowingAdvice[] throwingAdvices;
    private final FinallyAdvice[] finallyAdvices;
    private final Method method;

    public DefaultAdvisor(Method method, Advice ... advices) {
        this(method, Arrays.asList(advices));
    }

    public DefaultAdvisor(Method method, Iterable<Advice> advices) {
        this.method = method;
        ArrayList<BeforeAdvice> beforeAdvices = new ArrayList<BeforeAdvice>();
        ArrayList<FixedAdvice> fixedAdvices = new ArrayList<FixedAdvice>();
        ArrayList<AroundAdvice> aroundAdvices = new ArrayList<AroundAdvice>();
        ArrayList<AfterAdvice> afterAdvices = new ArrayList<AfterAdvice>();
        ArrayList<ThrowingAdvice> throwingAdvices = new ArrayList<ThrowingAdvice>();
        ArrayList<FinallyAdvice> finallyAdvices = new ArrayList<FinallyAdvice>();
        for (Advice advice : advices) {
            if (advice instanceof BeforeAdvice) {
                beforeAdvices.add((BeforeAdvice)advice);
                continue;
            }
            if (advice instanceof FixedAdvice) {
                fixedAdvices.add((FixedAdvice)advice);
                continue;
            }
            if (advice instanceof AroundAdvice) {
                aroundAdvices.add((AroundAdvice)advice);
                continue;
            }
            if (advice instanceof AfterAdvice) {
                afterAdvices.add((AfterAdvice)advice);
                continue;
            }
            if (advice instanceof ThrowingAdvice) {
                throwingAdvices.add((ThrowingAdvice)advice);
                continue;
            }
            if (!(advice instanceof FinallyAdvice)) continue;
            finallyAdvices.add((FinallyAdvice)advice);
        }
        this.beforeAdvices = beforeAdvices.isEmpty() ? null : beforeAdvices.toArray(new BeforeAdvice[0]);
        this.fixedAdvices = fixedAdvices.isEmpty() ? null : fixedAdvices.toArray(new FixedAdvice[0]);
        this.aroundAdvices = aroundAdvices.isEmpty() ? null : aroundAdvices.toArray(new AroundAdvice[0]);
        this.afterAdvices = afterAdvices.isEmpty() ? null : afterAdvices.toArray(new AfterAdvice[0]);
        this.throwingAdvices = throwingAdvices.isEmpty() ? null : throwingAdvices.toArray(new ThrowingAdvice[0]);
        this.finallyAdvices = finallyAdvices.isEmpty() ? null : finallyAdvices.toArray(new FinallyAdvice[0]);
    }

    @Override
    public Object advise(Object target, Object[] args, Invocation invocation) throws Throwable {
        Object object;
        Object ret = null;
        Throwable thr = null;
        try {
            this.before(target, this.method, args);
            ValueRef<?> ref = this.fixedValue(target, this.method, args);
            ret = ref != null ? (Object)ref.get() : this.around(target, this.method, args, invocation);
            this.after(target, this.method, args, ret);
            object = ret;
        }
        catch (Throwable e) {
            try {
                thr = e;
                this.throwing(target, this.method, args, thr);
                throw e;
            }
            catch (Throwable throwable) {
                this.after(target, this.method, args, ret, thr);
                throw throwable;
            }
        }
        this.after(target, this.method, args, ret, thr);
        return object;
    }

    void before(Object target, Method method, Object[] args) throws Throwable {
        if (this.beforeAdvices == null || this.beforeAdvices.length == 0) {
            return;
        }
        for (int i = 0; i < this.beforeAdvices.length; ++i) {
            BeforeAdvice beforeAdvice = this.beforeAdvices[i];
            beforeAdvice.before(target, method, args);
        }
    }

    ValueRef<?> fixedValue(Object target, Method method, Object[] args) {
        if (this.fixedAdvices == null || this.fixedAdvices.length == 0) {
            return null;
        }
        for (int i = 0; i < this.fixedAdvices.length; ++i) {
            FixedAdvice fixedAdvice = this.fixedAdvices[i];
            ValueRef<?> ref = fixedAdvice.fixedValue(target, method, args);
            if (ref == null) continue;
            return ref;
        }
        return null;
    }

    Object around(Object target, Method method, Object[] args, Invocation invocation) throws Throwable {
        if (this.aroundAdvices == null || this.aroundAdvices.length == 0) {
            return invocation.invoke(target, args);
        }
        AroundInvocation aroundInvocation = new AroundInvocation(invocation, this.aroundAdvices, 0, method);
        return aroundInvocation.invoke(target, args);
    }

    void after(Object target, Method method, Object[] args, Object retVal) throws Throwable {
        for (int i = 0; i < this.afterAdvices.length; ++i) {
            AfterAdvice afterAdvice = this.afterAdvices[i];
            afterAdvice.after(target, method, args, retVal);
        }
    }

    void throwing(Object target, Method method, Object[] args, Throwable e) throws Throwable {
        for (int i = 0; i < this.throwingAdvices.length; ++i) {
            ThrowingAdvice throwingAdvice = this.throwingAdvices[i];
            throwingAdvice.throwing(target, method, args, e);
        }
    }

    void after(Object target, Method method, Object[] args, Object retVal, Throwable e) throws Throwable {
        for (int i = 0; i < this.finallyAdvices.length; ++i) {
            FinallyAdvice finallyAdvice = this.finallyAdvices[i];
            finallyAdvice.after(target, method, args, retVal, e);
        }
    }
}

