/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.cache;

import io.polaris.core.tuple.Ref;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICache<K, V> {
    @Nullable
    public Ref<V> get(@Nonnull K var1);

    @Nullable
    default public V getIfPresent(@Nonnull K key) {
        Ref<V> ref = this.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Nullable
    public V get(@Nonnull K var1, Supplier<V> var2);

    @Nullable
    default public Ref<V> putIfAbsent(@Nonnull K key, @Nullable V value) {
        Ref<V> existingValue = this.get(key);
        if (existingValue == null) {
            this.put(key, value);
        }
        return existingValue;
    }

    public void put(@Nonnull K var1, @Nullable V var2);

    default public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach((k, v) -> this.put(k, v));
    }

    public void remove(K var1);

    public void clear();
}

