/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.codec;

import java.security.AccessController;
import java.security.PrivilegedAction;

class CodecStrings {
    static String LINE_SEPARATOR;

    CodecStrings() {
    }

    public static byte[] toByteArray(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i != bytes.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static byte[] toByteArray(String string) {
        byte[] bytes = new byte[string.length()];
        for (int i = 0; i != bytes.length; ++i) {
            char ch = string.charAt(i);
            bytes[i] = (byte)ch;
        }
        return bytes;
    }

    public static int toByteArray(String s, byte[] buf, int off) {
        int count = s.length();
        for (int i = 0; i < count; ++i) {
            char c = s.charAt(i);
            buf[off + i] = (byte)c;
        }
        return count;
    }

    public static String fromByteArray(byte[] bytes) {
        return new String(CodecStrings.asCharArray(bytes));
    }

    public static char[] asCharArray(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i != chars.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return chars;
    }

    static {
        try {
            LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        catch (Exception e) {
            try {
                LINE_SEPARATOR = String.format("%n", new Object[0]);
            }
            catch (Exception ef) {
                LINE_SEPARATOR = "\n";
            }
        }
    }
}

