/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent.pool;

import io.polaris.core.concurrent.pool.ResourceableConsumer;
import io.polaris.core.concurrent.pool.RunnableStatistics;
import io.polaris.core.concurrent.pool.RunnableStatisticsHolder;
import io.polaris.core.concurrent.pool.TransactionConsumer;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class ConsumerDelegates {
    private static final ILogger log = ILoggers.of(ConsumerDelegates.class);

    public static <E> Consumer<E> createDelegate(RunnableStatisticsHolder pStatistics, Consumer<E> pConsumer) {
        return data -> {
            Consumer consumer = pConsumer;
            RunnableStatistics statistics = pStatistics.runnableStatistics();
            if (statistics != null) {
                statistics.getTotal().incrementAndGet();
                try {
                    consumer.accept(data);
                    statistics.getSuccess().incrementAndGet();
                }
                catch (Exception e) {
                    statistics.getError().incrementAndGet();
                }
            } else {
                consumer.accept(data);
            }
        };
    }

    public static <E, Resource> ResourceableConsumer<E> createDelegate(final RunnableStatisticsHolder pStatistics, final TransactionConsumer<E, Resource> pConsumer) {
        return new ResourceableConsumer<E>(){
            private TransactionConsumer<E, Resource> consumer;
            private RunnableStatistics statistics;
            private int commitCount;
            private volatile Resource resource;
            private AtomicInteger total;
            private AtomicInteger success;
            private AtomicInteger error;
            private AtomicInteger commit;
            private AtomicReference<Throwable> processError;
            {
                this.consumer = pConsumer;
                this.total = new AtomicInteger(0);
                this.success = new AtomicInteger(0);
                this.error = new AtomicInteger(0);
                this.commit = new AtomicInteger(0);
                this.processError = new AtomicReference();
            }

            @Override
            public void open() {
                try {
                    int commitCount = this.consumer.commitCount();
                    if (commitCount <= 0) {
                        commitCount = 1000;
                    }
                    this.commitCount = commitCount;
                    this.statistics = pStatistics.runnableStatistics();
                    this.resource = this.consumer.openResource();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }

            @Override
            public void close() {
                if (this.resource != null) {
                    if (this.commit.get() > 0) {
                        try {
                            if (this.processError.get() != null) {
                                throw this.processError.get();
                            }
                            this.consumer.commitResource(this.resource);
                            this.success.addAndGet(this.commit.get());
                            if (this.statistics != null) {
                                this.statistics.getSuccess().addAndGet(this.commit.get());
                            }
                            log.trace("\u5904\u7406/\u63d0\u4ea4\u6210\u529f. total: {}, success: {}, error: {}", this.total.get(), this.success.get(), this.error.get());
                        }
                        catch (Throwable e) {
                            this.error.addAndGet(this.commit.get());
                            if (this.statistics != null) {
                                this.statistics.getError().addAndGet(this.commit.get());
                            }
                            try {
                                log.trace("\u5904\u7406/\u63d0\u4ea4\u5931\u8d25. total: {}, success: {}, error: {}", this.total.get(), this.success.get(), this.error.get());
                                log.error("\u5904\u7406/\u63d0\u4ea4\u5931\u8d25, \u51c6\u5907\u56de\u6eda.", e);
                                this.consumer.rollbackResource(this.resource);
                            }
                            catch (Throwable ex) {
                                log.error("\u56de\u6eda\u5931\u8d25", ex);
                            }
                        }
                    }
                    log.trace("\u5904\u7406\u5b8c\u6210");
                    this.consumer.closeResource(this.resource);
                }
            }

            @Override
            public void accept(E data) {
                try {
                    this.total.incrementAndGet();
                    if (this.statistics != null) {
                        this.statistics.getTotal().incrementAndGet();
                    }
                    this.commit.incrementAndGet();
                    try {
                        this.consumer.processData(this.resource, data);
                    }
                    catch (Throwable e) {
                        if (this.processError.get() != null) {
                            this.processError.get().addSuppressed(e);
                        }
                        this.processError.set(e);
                    }
                    if (this.commit.get() >= this.commitCount) {
                        if (this.processError.get() != null) {
                            throw this.processError.get();
                        }
                        this.consumer.commitResource(this.resource);
                        this.success.addAndGet(this.commit.get());
                        if (this.statistics != null) {
                            this.statistics.getSuccess().addAndGet(this.commit.get());
                        }
                        log.trace("\u5904\u7406/\u63d0\u4ea4\u6210\u529f. total: {}, success: {}, error: {}", this.total.get(), this.success.get(), this.error.get());
                        this.commit.set(0);
                    }
                }
                catch (Throwable e) {
                    this.error.addAndGet(this.commit.get());
                    if (this.statistics != null) {
                        this.statistics.getError().addAndGet(this.commit.get());
                    }
                    this.commit.set(0);
                    try {
                        log.trace("\u5904\u7406/\u63d0\u4ea4\u5931\u8d25. total: {}, success: {}, error: {}", this.total.get(), this.success.get(), this.error.get());
                        log.error("\u5904\u7406/\u63d0\u4ea4\u5931\u8d25, \u51c6\u5907\u56de\u6eda.", e);
                        this.consumer.rollbackResource(this.resource);
                    }
                    catch (Throwable ex) {
                        log.error("\u56de\u6eda\u5931\u8d25", ex);
                    }
                }
            }
        };
    }
}

