/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent.pool;

import io.polaris.core.concurrent.pool.ErrorRecords;
import io.polaris.core.concurrent.pool.RunnableDelegates;
import io.polaris.core.concurrent.pool.RunnableState;
import io.polaris.core.concurrent.pool.RunnableStatistics;
import io.polaris.core.concurrent.pool.TransactionConsumer;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class PooledExecutor<E>
implements RunnableState<E> {
    private static final ILogger log = ILoggers.of(PooledExecutor.class);
    public static final int CORE_NUM = Runtime.getRuntime().availableProcessors();
    public static final float MAXIMUM_FACTOR = 8.0f;
    public static final int KEEP_ALIVE_TIME = 1000;
    private int poolSize = CORE_NUM;
    private int maximumPoolSize = CORE_NUM * 8;
    private int queueSize = 1000;
    private int errorLimit = -1;
    private boolean openStatistics = false;
    private volatile boolean running = false;
    private BlockingQueue<E> blockingQueue;
    private Lock awaitLock = new ReentrantLock();
    private Condition awaitCondition = this.awaitLock.newCondition();
    private AtomicInteger activeCount = new AtomicInteger(0);
    private ThreadPoolExecutor pool;
    private List<Runnable> consumers = new ArrayList<Runnable>();
    private RunnableStatistics statistics;
    private AtomicReference<Consumer<ErrorRecords<E>>> rejectConsumerRef = new AtomicReference();

    public static ThreadPoolExecutor newWorkerPool(int poolSize, int maximumPoolSize) {
        return PooledExecutor.newWorkerPool(poolSize, maximumPoolSize, 1000L);
    }

    public static ThreadPoolExecutor newWorkerPool(int poolSize) {
        return PooledExecutor.newWorkerPool(poolSize, (int)((float)poolSize * 8.0f), 1000L);
    }

    public static ThreadPoolExecutor newWorkerPool() {
        return PooledExecutor.newWorkerPool(CORE_NUM);
    }

    public static ThreadPoolExecutor newWorkerPool(int poolSize, int maximumPoolSize, long keepAliveTime) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(poolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), Executors.defaultThreadFactory());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    @Override
    public RunnableStatistics runnableStatistics() {
        return this.statistics;
    }

    @Override
    public boolean hasNext() {
        return this.running || !this.blockingQueue.isEmpty();
    }

    @Override
    public E next() {
        return this.blockingQueue.poll();
    }

    @Override
    public void incrementActiveCount() {
        this.activeCount.incrementAndGet();
    }

    @Override
    public void decrementActiveCount() {
        this.activeCount.decrementAndGet();
    }

    @Override
    public void notifyFinished() {
        this.awaitLock.lock();
        try {
            this.awaitCondition.signalAll();
        }
        finally {
            this.awaitLock.unlock();
        }
    }

    public void setRejectConsumer(Consumer<ErrorRecords<E>> rejectConsumer) {
        this.rejectConsumerRef.set(rejectConsumer);
    }

    public void addConsumer(Consumer<E> consumer) {
        this.addConsumer(1, consumer);
    }

    public <Resource> void addConsumer(TransactionConsumer<E, Resource> consumer) {
        this.addConsumer(1, consumer);
    }

    public void addConsumer(int count, Consumer<E> consumer) {
        for (int k = 0; k < count; ++k) {
            Runnable delegate = RunnableDelegates.createDelegate(this, consumer, this.rejectConsumerRef);
            this.consumers.add(delegate);
        }
    }

    public <Resource> void addConsumer(int count, TransactionConsumer<E, Resource> consumer) {
        for (int k = 0; k < count; ++k) {
            Runnable delegate = RunnableDelegates.createDelegate(this, consumer, this.rejectConsumerRef);
            this.consumers.add(delegate);
        }
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("\u6b63\u5728\u8fd0\u884c\u4e2d");
        }
        if (this.consumers.isEmpty()) {
            throw new IllegalArgumentException("\u672a\u63d0\u4f9b\u6d88\u8d39\u8005");
        }
        this.running = true;
        this.pool = PooledExecutor.newWorkerPool(this.poolSize, this.maximumPoolSize);
        if (this.openStatistics || this.errorLimit >= 0) {
            this.statistics = new RunnableStatistics(this.errorLimit);
        }
        this.blockingQueue = new ArrayBlockingQueue(this.queueSize, true);
        for (Runnable consumer : this.consumers) {
            try {
                this.pool.execute(consumer);
            }
            catch (RejectedExecutionException e) {
                this.extend();
                try {
                    this.pool.execute(consumer);
                }
                catch (RejectedExecutionException e2) {
                    break;
                }
            }
        }
    }

    public void offer(Iterable<E> datas) {
        for (E data : datas) {
            this.offer(data);
        }
    }

    public void offer(E ... datas) {
        for (E data : datas) {
            this.offer(data);
        }
    }

    public boolean isExceedErrorLimit() {
        return this.statistics != null && this.statistics.isExceedErrorLimit();
    }

    public void offer(E data) {
        if (!this.running) {
            throw new IllegalStateException("\u72b6\u6001\u5df2\u505c\u6b62");
        }
        if (this.isExceedErrorLimit()) {
            throw new IllegalStateException("\u5904\u7406\u5931\u8d25\u6570\u91cf\u8d85\u9650(" + this.getErrorLimit() + ")");
        }
        while (true) {
            try {
                boolean rs;
                while (!(rs = this.blockingQueue.offer(data, 1L, TimeUnit.MILLISECONDS))) {
                }
            }
            catch (InterruptedException e) {
                log.trace("", e);
                continue;
            }
            break;
        }
    }

    public void await() {
        while (this.running || this.activeCount.get() > 0 || !this.blockingQueue.isEmpty()) {
            this.awaitLock.lock();
            try {
                this.awaitCondition.await(1L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.trace("", e);
            }
            finally {
                this.awaitLock.unlock();
            }
        }
        if (this.statistics != null) {
            log.info("total: {}, success: {}, error: {}", this.statistics.getTotal().get(), this.statistics.getSuccess().get(), this.statistics.getError().get());
        }
    }

    public void shutdown() {
        this.running = false;
        this.await();
        this.consumers.clear();
        this.closePool();
    }

    private void closePool() {
        if (this.pool != null) {
            ThreadPoolExecutor workerPool = this.pool;
            this.pool = null;
            try {
                workerPool.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!workerPool.isShutdown()) {
                workerPool.shutdownNow();
                if (!workerPool.isShutdown()) {
                    workerPool.shutdown();
                }
            }
            log.info("\u5173\u95ed\u7ebf\u7a0b\u6c60\u5b8c\u6210");
        }
    }

    private void extend() {
        if (this.pool.getMaximumPoolSize() < CORE_NUM * 100) {
            this.pool.setMaximumPoolSize(this.pool.getMaximumPoolSize() + CORE_NUM);
            this.pool.setCorePoolSize(this.pool.getCorePoolSize() + CORE_NUM);
        }
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setErrorLimit(int errorLimit) {
        this.errorLimit = errorLimit;
    }

    public int getErrorLimit() {
        return this.errorLimit;
    }

    public void setOpenStatistics(boolean openStatistics) {
        this.openStatistics = openStatistics;
    }

    public boolean isOpenStatistics() {
        return this.openStatistics;
    }
}

