/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.concurrent.pool;

import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WorkerPoolExecutor
extends ThreadPoolExecutor {
    private static final ILogger log = ILoggers.of(WorkerPoolExecutor.class);
    public static final int CORE_NUM = Runtime.getRuntime().availableProcessors();
    public static final float MAXIMUM_FACTOR = 8.0f;
    public static final float EXTEND_MAXIMUM_FACTOR = 100.0f;
    public static final int KEEP_ALIVE_TIME = 1000;
    public static final int MAX_TRY_TIME = Integer.MAX_VALUE;
    private int maxTryTime = Integer.MAX_VALUE;
    private Lock lock = new ReentrantLock();
    private Condition threadPoolCond = this.lock.newCondition();

    public WorkerPoolExecutor(int poolSize) {
        this(poolSize, (int)((float)poolSize * 8.0f), 1000L);
    }

    public WorkerPoolExecutor(int poolSize, int maximumPoolSize) {
        this(poolSize, maximumPoolSize, 1000L);
    }

    public WorkerPoolExecutor(int poolSize, int maximumPoolSize, long keepAliveTime) {
        super(poolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), Executors.defaultThreadFactory());
        this.allowCoreThreadTimeOut(true);
    }

    public WorkerPoolExecutor() {
        this(CORE_NUM);
    }

    public void shutdownQuietly() {
        try {
            this.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            if (!this.isShutdown()) {
                this.shutdownNow();
                if (!this.isShutdown()) {
                    this.shutdown();
                }
            }
        }
        catch (Exception e) {
            log.error("", e);
        }
    }

    public void setMaxTryTime(int maxTryTime) {
        this.maxTryTime = maxTryTime;
    }

    public void extend() {
        if ((float)this.getMaximumPoolSize() < (float)CORE_NUM * 100.0f) {
            this.setMaximumPoolSize(this.getMaximumPoolSize() + CORE_NUM);
            this.setCorePoolSize(this.getCorePoolSize() + CORE_NUM);
        }
    }

    public boolean executeAwait(Runnable task) {
        Runnable delegate = () -> {
            try {
                task.run();
            }
            finally {
                this.notifyForThreadPoolAccess();
            }
        };
        for (int i = 0; i <= this.maxTryTime; ++i) {
            try {
                super.execute(delegate);
                return true;
            }
            catch (RejectedExecutionException e) {
                this.waitForThreadPoolAccess();
                continue;
            }
        }
        return false;
    }

    void waitForThreadPoolAccess() {
        this.lock.lock();
        try {
            this.threadPoolCond.await(100L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    void notifyForThreadPoolAccess() {
        this.lock.lock();
        try {
            this.threadPoolCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

