/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.converter.support;

import io.polaris.core.converter.AbstractSimpleConverter;
import io.polaris.core.converter.Converters;
import io.polaris.core.lang.JavaType;
import io.polaris.core.string.Strings;

public class PrimitiveConverter
extends AbstractSimpleConverter<Object> {
    private final JavaType<Object> targetType;

    public PrimitiveConverter(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        this.targetType = JavaType.of(clazz);
    }

    @Override
    public JavaType<Object> getTargetType() {
        return this.targetType;
    }

    @Override
    protected String asString(Object value) {
        return Strings.trimToEmpty(super.asString(value));
    }

    @Override
    protected Object doConvert(Object value, JavaType<Object> targetType) {
        Class<Object> primitiveClass = targetType.getRawClass();
        if (Byte.TYPE == primitiveClass) {
            return (byte)Converters.convertQuietly(Byte.class, value, (byte)0);
        }
        if (Short.TYPE == primitiveClass) {
            return (short)Converters.convertQuietly(Short.class, value, (short)0);
        }
        if (Integer.TYPE == primitiveClass) {
            return (int)Converters.convertQuietly(Integer.class, value, 0);
        }
        if (Long.TYPE == primitiveClass) {
            return (long)Converters.convertQuietly(Long.class, value, 0L);
        }
        if (Float.TYPE == primitiveClass) {
            return Float.valueOf(Converters.convertQuietly(Float.class, value, Float.valueOf(0.0f)).floatValue());
        }
        if (Double.TYPE == primitiveClass) {
            return (double)Converters.convertQuietly(Double.class, value, 0.0);
        }
        if (Character.TYPE == primitiveClass) {
            return Character.valueOf(Converters.convertQuietly(Character.class, value, Character.valueOf('\u0000')).charValue());
        }
        if (Boolean.TYPE == primitiveClass) {
            return (boolean)Converters.convertQuietly(Boolean.class, value, false);
        }
        throw new IllegalArgumentException();
    }
}

