/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto;

import io.polaris.core.crypto.CryptoKeys;
import io.polaris.core.crypto.CryptoRuntimeException;
import io.polaris.core.crypto.IDecryptor;
import io.polaris.core.crypto.IEncryptor;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class Ciphers {
    public static Cipher getCipher(String algorithm) {
        return CryptoKeys.getCipher(algorithm);
    }

    public static Cipher getEncryptCipher(String algorithm, Key key) {
        try {
            Cipher cipher = Ciphers.getCipher(algorithm);
            cipher.init(1, key);
            return cipher;
        }
        catch (InvalidKeyException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static Cipher getDecryptCipher(String algorithm, Key key) {
        try {
            Cipher cipher = Ciphers.getCipher(algorithm);
            cipher.init(2, key);
            return cipher;
        }
        catch (InvalidKeyException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static IEncryptor getEncryptor(String algorithm, Key key) {
        Cipher cipher = Ciphers.getEncryptCipher(algorithm, key);
        return Ciphers.getEncryptor(cipher);
    }

    public static IEncryptor getEncryptor(final Cipher cipher) {
        return new IEncryptor(){

            @Override
            public IEncryptor update(byte[] data, int offset, int len) {
                cipher.update(data, offset, len);
                return this;
            }

            @Override
            public byte[] encrypt(byte[] data, int offset, int len) {
                try {
                    return cipher.doFinal(data, offset, len);
                }
                catch (BadPaddingException | IllegalBlockSizeException e) {
                    throw new CryptoRuntimeException(e);
                }
            }
        };
    }

    public static IDecryptor getDecryptor(String algorithm, Key key) {
        Cipher cipher = Ciphers.getDecryptCipher(algorithm, key);
        return Ciphers.getDecryptor(cipher);
    }

    public static IDecryptor getDecryptor(final Cipher cipher) {
        return new IDecryptor(){

            @Override
            public IDecryptor update(byte[] data, int offset, int len) {
                cipher.update(data, offset, len);
                return this;
            }

            @Override
            public byte[] decrypt(byte[] data, int offset, int len) {
                try {
                    return cipher.doFinal(data, offset, len);
                }
                catch (BadPaddingException | IllegalBlockSizeException e) {
                    throw new CryptoRuntimeException(e);
                }
            }
        };
    }

    public static Cipher doUpdate(Cipher cipher, byte[] data) {
        cipher.update(data);
        return cipher;
    }

    public static byte[] doFinal(Cipher cipher, byte[] data) {
        try {
            return cipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static byte[] encrypt(String algorithm, Key key, byte[] data) {
        Cipher cipher = Ciphers.getEncryptCipher(algorithm, key);
        try {
            return cipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static byte[] encrypt(String algorithm, byte[] key, byte[] data) {
        return Ciphers.encrypt(algorithm, CryptoKeys.generateKey(algorithm, key), data);
    }

    public static byte[] encryptByKeySeed(String algorithm, byte[] seed, byte[] data) {
        return Ciphers.encrypt(algorithm, CryptoKeys.generateKeyBySeed(algorithm, seed), data);
    }

    public static byte[] decrypt(String algorithm, Key key, byte[] data) {
        Cipher cipher = Ciphers.getDecryptCipher(algorithm, key);
        try {
            return cipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static byte[] decrypt(String algorithm, byte[] key, byte[] data) {
        return Ciphers.decrypt(algorithm, CryptoKeys.generateKey(algorithm, key), data);
    }

    public static byte[] decryptByKeySeed(String algorithm, byte[] seed, byte[] data) {
        return Ciphers.decrypt(algorithm, CryptoKeys.generateKeyBySeed(algorithm, seed), data);
    }
}

