/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.crypto.digest;

import io.polaris.core.crypto.CryptoRuntimeException;
import io.polaris.core.crypto.digest.DigestAlgorithm;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Digests {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    public static boolean isAvailable(String messageDigestAlgorithm) {
        return Digests.getDigest(messageDigestAlgorithm, null) != null;
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoRuntimeException(e);
        }
    }

    public static MessageDigest getDigest(String algorithm, MessageDigest defaultMessageDigest) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            return defaultMessageDigest;
        }
    }

    public static byte[] digest(MessageDigest messageDigest, byte[] data) {
        return messageDigest.digest(data);
    }

    public static byte[] digest(MessageDigest messageDigest, ByteBuffer data) {
        messageDigest.update(data);
        return messageDigest.digest();
    }

    public static byte[] digest(MessageDigest messageDigest, InputStream data) throws IOException {
        return Digests.updateDigest(messageDigest, data).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, File data) throws IOException {
        return Digests.updateDigest(messageDigest, data).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, Path data, OpenOption ... options) throws IOException {
        return Digests.updateDigest(messageDigest, data, options).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, RandomAccessFile data) throws IOException {
        return Digests.updateDigest(messageDigest, data).digest();
    }

    /*
     * Exception decompiling
     */
    public static MessageDigest updateDigest(MessageDigest digest, File data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MessageDigest updateDigest(MessageDigest digest, InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        int read = in.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = in.read(buffer, 0, 1024);
        }
        return digest;
    }

    /*
     * Exception decompiling
     */
    public static MessageDigest updateDigest(MessageDigest digest, Path path, OpenOption ... options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MessageDigest updateDigest(MessageDigest digest, RandomAccessFile data) throws IOException {
        return Digests.updateDigest(digest, data.getChannel());
    }

    private static MessageDigest updateDigest(MessageDigest digest, FileChannel data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (data.read(buffer) > 0) {
            buffer.flip();
            digest.update(buffer);
            buffer.clear();
        }
        return digest;
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, String data) {
        messageDigest.update(data.getBytes(StandardCharsets.UTF_8));
        return messageDigest;
    }

    public static MessageDigest getMd2Digest() {
        return Digests.getDigest(DigestAlgorithm.MD2.code());
    }

    public static MessageDigest getMd5Digest() {
        return Digests.getDigest(DigestAlgorithm.MD5.code());
    }

    public static MessageDigest getSha1Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA1.code());
    }

    public static MessageDigest getSha256Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA256.code());
    }

    public static MessageDigest getSha3_224Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA3_224.code());
    }

    public static MessageDigest getSha3_256Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA3_256.code());
    }

    public static MessageDigest getSha3_384Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA3_384.code());
    }

    public static MessageDigest getSha3_512Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA3_512.code());
    }

    public static MessageDigest getSha384Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA384.code());
    }

    public static MessageDigest getSha512Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA512.code());
    }

    public static MessageDigest getSha512_224Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA512_224.code());
    }

    public static MessageDigest getSha512_256Digest() {
        return Digests.getDigest(DigestAlgorithm.SHA512_256.code());
    }

    public static byte[] md2(byte[] data) {
        return Digests.getMd2Digest().digest(data);
    }

    public static byte[] md5(byte[] data) {
        return Digests.getMd5Digest().digest(data);
    }

    public static byte[] sha1(byte[] data) {
        return Digests.getSha1Digest().digest(data);
    }

    public static byte[] sha256(byte[] data) {
        return Digests.getSha256Digest().digest(data);
    }

    public static byte[] sha3_224(byte[] data) {
        return Digests.getSha3_224Digest().digest(data);
    }

    public static byte[] sha3_256(byte[] data) {
        return Digests.getSha3_256Digest().digest(data);
    }

    public static byte[] sha3_384(byte[] data) {
        return Digests.getSha3_384Digest().digest(data);
    }

    public static byte[] sha3_512(byte[] data) {
        return Digests.getSha3_512Digest().digest(data);
    }

    public static byte[] sha384(byte[] data) {
        return Digests.getSha384Digest().digest(data);
    }

    public static byte[] sha512(byte[] data) {
        return Digests.getSha512Digest().digest(data);
    }

    public static byte[] sha512_224(byte[] data) {
        return Digests.getSha512_224Digest().digest(data);
    }

    public static byte[] sha512_256(byte[] data) {
        return Digests.getSha512_256Digest().digest(data);
    }

    public static byte[] md2(String data) {
        return Digests.md2(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] md5(String data) {
        return Digests.md5(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha1(String data) {
        return Digests.sha1(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha256(String data) {
        return Digests.sha256(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha3_224(String data) {
        return Digests.sha3_224(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha3_256(String data) {
        return Digests.sha3_256(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha3_384(String data) {
        return Digests.sha3_384(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha3_512(String data) {
        return Digests.sha3_512(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha384(String data) {
        return Digests.sha384(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha512(String data) {
        return Digests.sha512(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha512_224(String data) {
        return Digests.sha512_224(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha512_256(String data) {
        return Digests.sha512_256(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] md2(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getMd2Digest(), data);
    }

    public static byte[] md5(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getMd5Digest(), data);
    }

    public static byte[] sha1(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha1Digest(), data);
    }

    public static byte[] sha256(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha256Digest(), data);
    }

    public static byte[] sha3_224(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha3_224Digest(), data);
    }

    public static byte[] sha3_256(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha3_256Digest(), data);
    }

    public static byte[] sha3_384(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha3_384Digest(), data);
    }

    public static byte[] sha3_512(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha3_512Digest(), data);
    }

    public static byte[] sha384(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha384Digest(), data);
    }

    public static byte[] sha512(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha512Digest(), data);
    }

    public static byte[] sha512_224(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha512_224Digest(), data);
    }

    public static byte[] sha512_256(InputStream data) throws IOException, NoSuchAlgorithmException {
        return Digests.digest(Digests.getSha512_256Digest(), data);
    }
}

