/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.data.buffer;

import io.polaris.core.data.buffer.IQueueBuffer;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class BlockingQueueBuffer<T>
implements IQueueBuffer<T> {
    private final BlockingQueue<T> queue;
    private final int size;

    BlockingQueueBuffer(int bufferSize) {
        this.queue = new ArrayBlockingQueue<T>(bufferSize);
        this.size = bufferSize;
    }

    @Override
    public boolean push(T data) {
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    @Override
    public void drainTo(List<T> consumeList) {
        this.queue.drainTo(consumeList);
    }

    @Override
    public int size() {
        return this.size;
    }
}

