/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.io;

import io.polaris.core.collection.Iterables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class Serializations {
    @Nullable
    public static byte[] serialize(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
            oos.flush();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Object deserialize(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static Object deserialize(@Nullable byte[] bytes, Class<?> ... acceptClasses) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T clone(T obj) {
        if (!(obj instanceof Serializable)) {
            return null;
        }
        return (T)Serializations.deserialize(Serializations.serialize(obj));
    }

    public static class ValidateObjectInputStream
    extends ObjectInputStream {
        private Set<String> whiteClassSet;
        private Set<String> blackClassSet;

        public ValidateObjectInputStream(InputStream inputStream, Class<?> ... acceptClasses) throws IOException {
            super(inputStream);
            this.accept(acceptClasses);
        }

        public void refuse(Class<?> ... refuseClasses) {
            if (null == this.blackClassSet) {
                this.blackClassSet = new HashSet<String>();
            }
            for (Class<?> acceptClass : refuseClasses) {
                this.blackClassSet.add(acceptClass.getName());
            }
        }

        public void accept(Class<?> ... acceptClasses) {
            if (null == this.whiteClassSet) {
                this.whiteClassSet = new HashSet<String>();
            }
            for (Class<?> acceptClass : acceptClasses) {
                this.whiteClassSet.add(acceptClass.getName());
            }
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            this.validateClassName(desc.getName());
            return super.resolveClass(desc);
        }

        private void validateClassName(String className) throws InvalidClassException {
            if (Iterables.isNotEmpty(this.blackClassSet) && this.blackClassSet.contains(className)) {
                throw new InvalidClassException("Unauthorized deserialization attempt by black list", className);
            }
            if (Iterables.isEmpty(this.whiteClassSet)) {
                return;
            }
            if (className.startsWith("java.")) {
                return;
            }
            if (this.whiteClassSet.contains(className)) {
                return;
            }
            throw new InvalidClassException("Unauthorized deserialization attempt", className);
        }
    }
}

