/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.io.ansi;

import io.polaris.core.assertion.Assertions;
import io.polaris.core.io.ansi.Ansi8BitColor;
import io.polaris.core.io.ansi.AnsiBackground;
import io.polaris.core.io.ansi.AnsiColor;
import io.polaris.core.io.ansi.AnsiColors;
import io.polaris.core.io.ansi.AnsiElement;
import io.polaris.core.io.ansi.ForeOrBack;
import io.polaris.core.string.Strings;
import java.util.Objects;

public class AnsiColorWrapper {
    private final int code;
    private final AnsiColors.BitDepth bitDepth;

    public AnsiColorWrapper(int code, AnsiColors.BitDepth bitDepth) {
        if (bitDepth == AnsiColors.BitDepth.FOUR) {
            Assertions.assertTrue(30 <= code && code <= 37 || 90 <= code && code <= 97, "The value of 4 bit color only supported [30~37],[90~97].");
        }
        Assertions.assertTrue(0 <= code && code <= 255, "The value of 8 bit color only supported [0~255].");
        this.code = code;
        this.bitDepth = bitDepth;
    }

    public AnsiElement toAnsiElement(ForeOrBack foreOrBack) {
        if (this.bitDepth == AnsiColors.BitDepth.FOUR) {
            if (foreOrBack == ForeOrBack.FORE) {
                for (AnsiColor item : AnsiColor.values()) {
                    if (item.getCode() != this.code) continue;
                    return item;
                }
                throw new IllegalArgumentException(Strings.format("No matched AnsiColor instance,code={}", this.code));
            }
            for (AnsiBackground item : AnsiBackground.values()) {
                if (item.getCode() != this.code + 10) continue;
                return item;
            }
            throw new IllegalArgumentException(Strings.format("No matched AnsiBackground instance,code={}", this.code));
        }
        if (foreOrBack == ForeOrBack.FORE) {
            return Ansi8BitColor.foreground(this.code);
        }
        return Ansi8BitColor.background(this.code);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnsiColorWrapper that = (AnsiColorWrapper)o;
        return this.code == that.code && this.bitDepth == that.bitDepth;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.bitDepth});
    }
}

