/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.dbv;

import io.polaris.core.jdbc.JdbcException;
import io.polaris.core.jdbc.Jdbcs;
import io.polaris.core.jdbc.base.ResultRowSimpleMapper;
import io.polaris.core.jdbc.dbv.DbvColumnFieldsMeta;
import io.polaris.core.jdbc.dbv.DbvResultSetFetcher;
import io.polaris.core.jdbc.dbv.model.Catalog;
import io.polaris.core.jdbc.dbv.model.Column;
import io.polaris.core.jdbc.dbv.model.IndexInfo;
import io.polaris.core.jdbc.dbv.model.PrimaryKey;
import io.polaris.core.jdbc.dbv.model.Schema;
import io.polaris.core.jdbc.dbv.model.Table;
import io.polaris.core.jdbc.dbv.model.TableType;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.string.Strings;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Dbv {
    private static final ILogger log = ILoggers.of(Dbv.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> read(ResultSet rs, List<T> list, Class<? extends T> clazz) throws InstantiationException, IllegalAccessException {
        try {
            DbvColumnFieldsMeta meta = DbvResultSetFetcher.getColumnFieldsMetadata(rs, clazz);
            while (rs.next()) {
                T object = clazz.newInstance();
                DbvResultSetFetcher.fetch(meta, rs, object);
                list.add(object);
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            Jdbcs.close(rs);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> read(ResultSet rs, List<T> list, ResultRowSimpleMapper<T> mapper) {
        try {
            while (rs.next()) {
                list.add(mapper.map(rs));
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            Jdbcs.close(rs);
        }
        return list;
    }

    public static List<Catalog> readCatalog(DatabaseMetaData metaData) throws JdbcException {
        try {
            ArrayList<Catalog> list = new ArrayList<Catalog>(20);
            Dbv.read(metaData.getCatalogs(), list, Catalog.class);
            return list;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return new ArrayList<Catalog>();
        }
    }

    public static List<Schema> readSchemas(DatabaseMetaData metaData) {
        try {
            ArrayList<Schema> list = new ArrayList<Schema>(30);
            Dbv.read(metaData.getSchemas(), list, Schema.class);
            return list;
        }
        catch (Exception e) {
            return new ArrayList<Schema>();
        }
    }

    public static List<Table> readTablesWithoutIndexes(DatabaseMetaData metaData, String catalog, String schema, String tableName, String type) {
        try {
            ArrayList<Table> tables = new ArrayList<Table>(100);
            ResultSet rs = metaData.getTables(catalog, schema, tableName, Strings.isEmpty(type) ? null : type.split("[,|;\\s]+"));
            Dbv.read(rs, tables, Table.class);
            for (Table table : tables) {
                List<PrimaryKey> primaryKeys = Dbv.readPrimaryKeys(metaData, table);
                table.setPrimaryKeyList(primaryKeys);
                table.setColumnList(Dbv.readColumns(metaData, table.getTableCatalog(), table.getTableSchema(), table.getTableName(), null));
                table.fit();
            }
            return tables;
        }
        catch (Exception e) {
            return new ArrayList<Table>();
        }
    }

    public static List<Table> readTables(DatabaseMetaData metaData, String catalog, String schema, String tableName, String type) {
        try {
            ArrayList<Table> tables = new ArrayList<Table>(100);
            if (Strings.isEmpty(catalog)) {
                catalog = metaData.getConnection().getCatalog();
            }
            if (Strings.isEmpty(schema)) {
                schema = metaData.getConnection().getSchema();
            }
            ResultSet rs = metaData.getTables(Strings.trimToNull(catalog), Strings.trimToNull(schema), Strings.trimToNull(tableName), Strings.isEmpty(type) ? null : type.split("[,|;\\s]+"));
            Dbv.read(rs, tables, Table.class);
            for (Table table : tables) {
                List<PrimaryKey> primaryKeys = Dbv.readPrimaryKeys(metaData, table);
                table.setPrimaryKeyList(primaryKeys);
                List<IndexInfo> indexes = Dbv.readIndexes(metaData, table.getTableCatalog(), table.getTableSchema(), table.getTableName());
                table.setIndexInfoList(indexes);
                table.setColumnList(Dbv.readColumns(metaData, table.getTableCatalog(), table.getTableSchema(), table.getTableName(), null));
                table.fit();
            }
            return tables;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return new ArrayList<Table>();
        }
    }

    public static List<Column> readColumns(DatabaseMetaData metaData, String catalog, String schema, String tableName, String columnName) {
        try {
            List<Column> list = Dbv.read(metaData.getColumns(catalog, schema, tableName, columnName), new ArrayList(50), Column.class);
            return list;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return new ArrayList<Column>();
        }
    }

    public static List<IndexInfo> readIndexes(DatabaseMetaData metaData, String catalog, String schema, String tableName) {
        try {
            boolean approximate = true;
            List<IndexInfo> indexes = Dbv.read(metaData.getIndexInfo(catalog, schema, tableName, false, approximate), new ArrayList(20), IndexInfo.class);
            Iterator<IndexInfo> iter = indexes.iterator();
            while (iter.hasNext()) {
                IndexInfo index = iter.next();
                if (index.getIndexName() != null && !index.getIndexName().equals("")) continue;
                iter.remove();
            }
            return indexes;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return new ArrayList<IndexInfo>();
        }
    }

    public static List<PrimaryKey> readPrimaryKeys(DatabaseMetaData metaData, Table table) {
        try {
            ArrayList<PrimaryKey> primaryKeys = new ArrayList<PrimaryKey>();
            ResultSet rs = metaData.getPrimaryKeys(table.getTableCatalog(), table.getTableSchema(), table.getTableName());
            Dbv.read(rs, primaryKeys, PrimaryKey.class);
            return primaryKeys;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return new ArrayList<PrimaryKey>();
        }
    }

    public static List<TableType> readTableTypes(DatabaseMetaData metaData) {
        try {
            ArrayList<TableType> list = new ArrayList<TableType>(10);
            Dbv.read(metaData.getTableTypes(), list, TableType.class);
            return list;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return new ArrayList<TableType>();
        }
    }
}

