/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.dbv;

import io.polaris.core.converter.Converters;
import io.polaris.core.jdbc.dbv.DbvColumnFieldMeta;
import io.polaris.core.jdbc.dbv.DbvColumnFieldsMeta;
import io.polaris.core.jdbc.dbv.DbvColumnGetter;
import io.polaris.core.jdbc.dbv.annotation.DbvColumn;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.map.CaseInsensitiveMap;
import io.polaris.core.reflect.Reflects;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbvResultSetFetcher {
    private static final ILogger log = ILoggers.of(DbvResultSetFetcher.class);

    public static Map<String, Object> fetch(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cnt = meta.getColumnCount();
        CaseInsensitiveMap<String, Object> map = new CaseInsensitiveMap<String, Object>(new LinkedHashMap(), true);
        for (int i = 1; i <= cnt; ++i) {
            map.put(meta.getColumnLabel(i).toUpperCase(), rs.getObject(i));
        }
        return map;
    }

    public static List<Map<String, Object>> fetchList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            list.add(DbvResultSetFetcher.fetch(rs));
        }
        return list;
    }

    public static Object fetch(ResultSet rs, Object obj) throws SQLException {
        DbvColumnFieldsMeta columnFields = DbvResultSetFetcher.getColumnFieldsMetadata(rs, obj.getClass());
        return DbvResultSetFetcher.fetch(columnFields, rs, obj);
    }

    public static <T> List<T> fetchList(ResultSet rs, Class<T> clazz) throws SQLException, ReflectiveOperationException {
        DbvColumnFieldsMeta columnFields = DbvResultSetFetcher.getColumnFieldsMetadata(rs, clazz);
        ArrayList<T> list = new ArrayList<T>();
        while (rs.next()) {
            T object = clazz.newInstance();
            DbvResultSetFetcher.fetch(columnFields, rs, object);
            list.add(object);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fetch(DbvColumnFieldsMeta columnFields, ResultSet rs, Object obj) {
        Set<DbvColumnFieldMeta> fields = columnFields.getFields();
        for (DbvColumnFieldMeta meta : fields) {
            Field field = meta.getField();
            DbvColumnGetter handler = meta.getGetter();
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(obj, handler.getColumnValue(rs, meta.getColumn()));
            }
            catch (IllegalAccessException | SQLException e) {
                log.debug(e.getMessage(), e);
            }
            finally {
                field.setAccessible(accessible);
            }
        }
        return obj;
    }

    public static Set<String> getColumnNames(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        LinkedHashSet<String> colSet = new LinkedHashSet<String>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            colSet.add(meta.getColumnName(i).toUpperCase());
        }
        return colSet;
    }

    public static DbvColumnFieldsMeta getColumnFieldsMetadata(ResultSet resultSet, Class clazz) throws SQLException {
        DbvColumnFieldsMeta metadata = new DbvColumnFieldsMeta();
        Set<String> columnNames = DbvResultSetFetcher.getColumnNames(resultSet);
        LinkedHashSet<DbvColumnFieldMeta> fields = new LinkedHashSet<DbvColumnFieldMeta>();
        for (Class superClass = clazz; superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = superClass.getDeclaredFields()) {
                String columnName;
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                DbvColumnGetter getter = null;
                DbvColumn columnNameAnno = field.getAnnotation(DbvColumn.class);
                if (columnNameAnno == null) {
                    columnName = DbvResultSetFetcher.castFieldToColumn(field.getName());
                } else {
                    columnName = columnNameAnno.value().toUpperCase();
                    Class<? extends DbvColumnGetter> getterClass = columnNameAnno.getter();
                    if (getterClass != DbvColumnGetter.class && !Modifier.isAbstract(getterClass.getModifiers())) {
                        try {
                            getter = Reflects.newInstance(getterClass, new Object[0]);
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            // empty catch block
                        }
                    }
                }
                if (!columnNames.contains(columnName)) continue;
                DbvColumnFieldMeta meta = new DbvColumnFieldMeta();
                meta.setColumn(columnName);
                meta.setField(field);
                fields.add(meta);
                if (getter != null) {
                    meta.setGetter(getter);
                    continue;
                }
                Class<?> type = field.getType();
                if (String.class == type) {
                    meta.setGetter(ResultSet::getString);
                    continue;
                }
                if (Integer.TYPE == type) {
                    meta.setGetter(ResultSet::getInt);
                    continue;
                }
                if (Integer.class == type) {
                    meta.setGetter((rs, col) -> {
                        BigDecimal val = rs.getBigDecimal(col);
                        if (val == null) {
                            return null;
                        }
                        return val.intValue();
                    });
                    continue;
                }
                if (Long.TYPE == type) {
                    meta.setGetter(ResultSet::getLong);
                    continue;
                }
                if (Long.class == type) {
                    meta.setGetter((rs, col) -> {
                        BigDecimal val = rs.getBigDecimal(col);
                        if (val == null) {
                            return null;
                        }
                        return val.longValue();
                    });
                    continue;
                }
                if (Boolean.TYPE == type) {
                    meta.setGetter(ResultSet::getBoolean);
                    continue;
                }
                if (Boolean.class == type) {
                    meta.setGetter((rs, col) -> {
                        String val = rs.getString(col);
                        if (val == null) {
                            return null;
                        }
                        return rs.getBoolean(col);
                    });
                    continue;
                }
                if (Double.TYPE == type) {
                    meta.setGetter(ResultSet::getDouble);
                    continue;
                }
                if (Double.class == type) {
                    meta.setGetter((rs, col) -> {
                        BigDecimal val = rs.getBigDecimal(col);
                        if (val == null) {
                            return null;
                        }
                        return val.doubleValue();
                    });
                    continue;
                }
                if (Float.TYPE == type) {
                    meta.setGetter(ResultSet::getFloat);
                    continue;
                }
                if (Float.class == type) {
                    meta.setGetter((rs, col) -> {
                        BigDecimal val = rs.getBigDecimal(col);
                        if (val == null) {
                            return null;
                        }
                        return Float.valueOf(val.floatValue());
                    });
                    continue;
                }
                if (Byte.TYPE == type) {
                    meta.setGetter(ResultSet::getByte);
                    continue;
                }
                if (Byte.class == type) {
                    meta.setGetter((rs, col) -> {
                        BigDecimal val = rs.getBigDecimal(col);
                        if (val == null) {
                            return null;
                        }
                        return val.byteValue();
                    });
                    continue;
                }
                if (Short.TYPE == type) {
                    meta.setGetter(ResultSet::getShort);
                    continue;
                }
                if (Short.class == type) {
                    meta.setGetter((rs, col) -> {
                        BigDecimal val = rs.getBigDecimal(col);
                        if (val == null) {
                            return null;
                        }
                        return val.shortValue();
                    });
                    continue;
                }
                if (Character.TYPE == type) {
                    meta.setGetter((rs, col) -> {
                        String val = rs.getString(col);
                        return Character.valueOf(val == null || val.isEmpty() ? (char)'\u0000' : val.charAt(0));
                    });
                    continue;
                }
                if (Character.class == type) {
                    meta.setGetter((rs, col) -> {
                        String val = rs.getString(col);
                        return val == null || val.isEmpty() ? null : Character.valueOf(val.charAt(0));
                    });
                    continue;
                }
                if (type.isEnum()) {
                    meta.setGetter((rs, col) -> {
                        String val = rs.getString(col);
                        if (val == null) {
                            return null;
                        }
                        Class t = type;
                        return Enum.valueOf(t, val);
                    });
                    continue;
                }
                if (java.util.Date.class == type || Date.class == type) {
                    meta.setGetter(ResultSet::getDate);
                    continue;
                }
                if (Timestamp.class == type) {
                    meta.setGetter(ResultSet::getTimestamp);
                    continue;
                }
                if (Time.class == type) {
                    meta.setGetter(ResultSet::getTime);
                    continue;
                }
                if (BigDecimal.class == type) {
                    meta.setGetter(ResultSet::getBigDecimal);
                    continue;
                }
                meta.setGetter((rs, col) -> {
                    try {
                        return rs.getObject(col, type);
                    }
                    catch (Throwable e) {
                        Object val = rs.getObject(col);
                        if (val == null || type.isAssignableFrom(val.getClass())) {
                            return val;
                        }
                        return Converters.convertQuietly(type, val);
                    }
                });
            }
        }
        metadata.setColumns(columnNames);
        metadata.setFields(fields);
        return metadata;
    }

    private static String castFieldToColumn(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(length + 8);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_').append(c);
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    private static Set<Field> getDeclaredFields(Object obj) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        for (Class<?> superClass = obj.getClass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = superClass.getDeclaredFields()) {
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        return fields;
    }
}

