/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql;

import io.polaris.core.converter.Converters;
import io.polaris.core.jdbc.ColumnMeta;
import io.polaris.core.jdbc.sql.BoundSql;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.lang.bean.BeanMap;
import io.polaris.core.lang.bean.Beans;
import io.polaris.core.string.StringCases;
import io.polaris.core.string.Strings;
import io.polaris.core.tuple.ValueRef;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class BindingValues {
    public static Object getValueForInsert(ColumnMeta meta, Object val) {
        String insertDefault;
        if (val == null && (meta.isCreateTime() || meta.isUpdateTime())) {
            val = Converters.convertQuietly(meta.getFieldType(), new Timestamp(System.currentTimeMillis()));
        }
        if (val == null && Strings.isNotBlank(insertDefault = meta.getInsertDefault())) {
            val = Converters.convertQuietly(meta.getFieldType(), insertDefault);
        }
        if (val == null && meta.isVersion()) {
            val = Converters.convertQuietly(meta.getFieldType(), 1L);
        }
        if (val == null && meta.isLogicDeleted()) {
            val = Converters.convertQuietly(meta.getFieldType(), false);
        }
        return val;
    }

    public static Object getValueForUpdate(ColumnMeta meta, Object val) {
        String updateDefault;
        if (val == null && meta.isUpdateTime()) {
            val = Converters.convertQuietly(meta.getFieldType(), new Timestamp(System.currentTimeMillis()));
        }
        if (val == null && Strings.isNotBlank(updateDefault = meta.getUpdateDefault())) {
            val = Converters.convertQuietly(meta.getFieldType(), updateDefault);
        }
        return val;
    }

    @Nullable
    public static java.util.Date[] getDateRangeOrNull(Object val) {
        java.util.Date[] range = new java.util.Date[2];
        Object[] couple = new Object[2];
        if (val instanceof Iterable) {
            Object next;
            Iterator iter = ((Iterable)val).iterator();
            if (iter.hasNext()) {
                next = iter.next();
                couple[0] = next;
            }
            if (iter.hasNext()) {
                next = iter.next();
                couple[1] = next;
            }
            if (iter.hasNext()) {
                return null;
            }
        } else if (val.getClass().isArray()) {
            int len = Array.getLength(val);
            if (len == 2) {
                Object start = Array.get(val, 0);
                Object end = Array.get(val, 1);
                couple[0] = start;
                couple[1] = end;
            } else {
                return null;
            }
        }
        if (couple[0] == null && couple[1] == null) {
            return null;
        }
        range[0] = (java.util.Date)Converters.convertQuietly(java.util.Date.class, couple[0]);
        range[1] = (java.util.Date)Converters.convertQuietly(java.util.Date.class, couple[1]);
        if (range[0] == null && range[1] == null) {
            return null;
        }
        return range;
    }

    public static Object getDefaultTimeVal(Class<?> fieldType) {
        if (fieldType.isAssignableFrom(Timestamp.class)) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (fieldType.isAssignableFrom(Date.class)) {
            return new Date(System.currentTimeMillis());
        }
        if (fieldType.isAssignableFrom(java.util.Date.class)) {
            return new java.util.Date();
        }
        if (fieldType.isAssignableFrom(LocalDateTime.class)) {
            return LocalDateTime.now();
        }
        if (fieldType.isAssignableFrom(LocalDate.class)) {
            return LocalDate.now();
        }
        return new java.util.Date();
    }

    public static Object getBindingValueOrDefault(Map<String, Object> bindings, String key, Object defVal) {
        if (bindings == null) {
            return defVal;
        }
        try {
            if (key.contains(".") || key.contains("[")) {
                Object val = Beans.getPathProperty(bindings, key);
                if (val == null) {
                    return bindings.getOrDefault(key, defVal);
                }
                return val;
            }
            return bindings.getOrDefault(key, defVal);
        }
        catch (Exception e) {
            return defVal;
        }
    }

    public static Object getBindingValueOrDefault(Map<String, ValueRef<Object>> cache, Map<String, Object> bindings, String key, Object defVal) {
        Object val;
        if (bindings == null) {
            return defVal;
        }
        if (cache != null) {
            ValueRef<Object> ref = cache.get(key);
            if (ref != null) {
                val = ref.get();
            } else if (key.contains(".") || key.contains("[")) {
                try {
                    val = Beans.getPathProperty(bindings, key);
                    if (val == null) {
                        val = bindings.get(key);
                    }
                }
                catch (Exception e) {
                    val = null;
                }
                cache.put(key, ValueRef.of(val));
            } else {
                try {
                    val = bindings.get(key);
                }
                catch (Exception e) {
                    val = null;
                }
                cache.put(key, ValueRef.of(val));
            }
        } else {
            try {
                if (key.contains(".") || key.contains("[")) {
                    val = Beans.getPathProperty(bindings, key);
                    if (val == null) {
                        val = bindings.get(key);
                    }
                } else {
                    val = bindings.get(key);
                }
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (val == null) {
            return defVal;
        }
        return val;
    }

    private static boolean isBasicDataType(Class clazz) {
        return clazz.isPrimitive() || clazz.isEnum() || clazz.isArray() || String.class == clazz || Integer.class == clazz || BigDecimal.class == clazz || Double.class == clazz || BigInteger.class == clazz || Float.class == clazz || Short.class == clazz || Byte.class == clazz || Character.class == clazz || Boolean.class == clazz || java.util.Date.class.isAssignableFrom(clazz);
    }

    public static Map<String, Object> asMap(Object o) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> compatible = new HashMap<String, Object>();
        if (o == null) {
            params.put("value", null);
        } else if (BindingValues.isBasicDataType(o.getClass())) {
            params.put("value", o);
        } else if (o instanceof Map) {
            Set keys = ((Map)o).keySet();
            for (Object k : keys) {
                String s = Objects.toString(k, null);
                if (s == null) continue;
                Object val = ((Map)o).get(k);
                params.put(s, val);
                String underlineKey = StringCases.camelToUnderlineCase(s);
                if (s.equals(underlineKey)) continue;
                compatible.put(underlineKey, val);
            }
        } else if (o.getClass() != Object.class) {
            try {
                BeanMap<Object> map = Beans.newBeanMap(o);
                for (String string : map.keySet()) {
                    Object val = map.get(string);
                    params.put(string, val);
                    String underlineKey = StringCases.camelToUnderlineCase(string);
                    if (string.equals(underlineKey)) continue;
                    compatible.put(underlineKey, val);
                }
            }
            catch (Exception exception) {}
        } else {
            params.put("value", o);
        }
        if (!compatible.isEmpty()) {
            for (Map.Entry entry : compatible.entrySet()) {
                params.putIfAbsent((String)entry.getKey(), entry.getValue());
            }
        }
        return params;
    }

    public static String asSqlWithBindings(Map<String, Object> map, SqlNodeBuilder sqlNodeBuilder) {
        SqlNode sqlNode = sqlNodeBuilder.toSqlNode();
        return BindingValues.asSqlWithBindings(map, sqlNode);
    }

    public static String asSqlWithBindings(Map<String, Object> map, SqlNode sqlNode) {
        BoundSql boundSql = sqlNode.asBoundSql();
        Map<String, Object> bindings = boundSql.getBindings();
        if (bindings != null && !bindings.isEmpty()) {
            map.putAll(bindings);
        }
        return boundSql.getText();
    }
}

