/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.query;

import io.polaris.core.jdbc.sql.query.OrderBy;
import io.polaris.core.jdbc.sql.query.Pagination;

public interface Pageable {
    public int getPageNum();

    public int getPageSize();

    public int getTotal();

    public void setPageNum(int var1);

    public void setPageSize(int var1);

    public void setTotal(int var1);

    public OrderBy getOrderBy();

    public void setOrderBy(OrderBy var1);

    default public int startResult() {
        return (this.getPageNum() - 1) * this.getPageSize();
    }

    default public int endResult() {
        return this.getPageNum() * this.getPageSize() - 1;
    }

    default public int startRow() {
        return (this.getPageNum() - 1) * this.getPageSize() + 1;
    }

    default public int endRow() {
        return this.getPageNum() * this.getPageSize();
    }

    public static Pageable newInstance() {
        return new Pagination();
    }

    public static Pageable newInstance(int pageNum, int pageSize) {
        return new Pagination(pageNum, pageSize);
    }

    public static int getStartResult(Pageable page) {
        return (page.getPageNum() - 1) * page.getPageSize();
    }

    public static int getEndResult(Pageable page) {
        return page.getPageNum() * page.getPageSize() - 1;
    }

    public static int getStartRow(Pageable page) {
        return (page.getPageNum() - 1) * page.getPageSize() + 1;
    }

    public static int getEndRow(Pageable page) {
        return page.getPageNum() * page.getPageSize();
    }
}

