/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement;

import io.polaris.core.collection.Iterables;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.statement.ColumnPredicate;
import io.polaris.core.string.Strings;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class ConfigurableColumnPredicate
implements ColumnPredicate {
    private final Predicate<String> isIncludeColumns;
    private final Predicate<String> isExcludeColumns;
    private final Predicate<String> isIncludeEmptyColumns;
    private final boolean includeAllEmpty;

    private ConfigurableColumnPredicate(Predicate<String> isIncludeColumns, Predicate<String> isExcludeColumns, Predicate<String> isIncludeEmptyColumns, boolean includeAllEmpty) {
        this.isIncludeColumns = isIncludeColumns;
        this.isExcludeColumns = isExcludeColumns;
        this.isIncludeEmptyColumns = isIncludeEmptyColumns;
        this.includeAllEmpty = includeAllEmpty;
    }

    public static ColumnPredicate of(Predicate<String> isIncludeColumns, Predicate<String> isExcludeColumns, Predicate<String> isIncludeEmptyColumns, boolean includeAllEmpty) {
        return new ConfigurableColumnPredicate(isIncludeColumns, isExcludeColumns, isIncludeEmptyColumns, includeAllEmpty);
    }

    public static ColumnPredicate of(String[] includeColumns, String[] excludeColumns, String[] includeEmptyColumns, boolean includeAllEmpty) {
        return new ConfigurableColumnPredicate(ConfigurableColumnPredicate.toPredicate(includeColumns), ConfigurableColumnPredicate.toPredicate(excludeColumns), ConfigurableColumnPredicate.toPredicate(includeEmptyColumns), includeAllEmpty);
    }

    public static ColumnPredicate of(Predicate<String> isIncludeEmptyColumns) {
        return new ConfigurableColumnPredicate(null, null, isIncludeEmptyColumns, false);
    }

    public static ColumnPredicate of(String[] includeEmptyColumns) {
        return new ConfigurableColumnPredicate(null, null, ConfigurableColumnPredicate.toPredicate(includeEmptyColumns), false);
    }

    public static ColumnPredicate of(Map<String, Object> bindings, String[] includeColumns, String includeColumnsKey, String[] excludeColumns, String excludeColumnsKey, String[] includeEmptyColumns, String includeEmptyColumnsKey, boolean includeAllEmpty, String includeAllEmptyKey) {
        Predicate<String> isIncludeColumns = ConfigurableColumnPredicate.toPredicate(bindings, includeColumns, includeColumnsKey);
        Predicate<String> isExcludeColumns = ConfigurableColumnPredicate.toPredicate(bindings, excludeColumns, excludeColumnsKey);
        Predicate<String> isIncludeEmptyColumns = ConfigurableColumnPredicate.toPredicate(bindings, includeEmptyColumns, includeEmptyColumnsKey);
        includeAllEmpty = ConfigurableColumnPredicate.toBoolean(bindings, includeAllEmpty, includeAllEmptyKey);
        return new ConfigurableColumnPredicate(isIncludeColumns, isExcludeColumns, isIncludeEmptyColumns, includeAllEmpty);
    }

    public static ColumnPredicate of(Map<String, Object> bindings, String[] includeColumns, String[] includeColumnsKey, String[] excludeColumns, String[] excludeColumnsKey, String[] includeEmptyColumns, String[] includeEmptyColumnsKey, boolean includeAllEmpty, String[] includeAllEmptyKey) {
        Predicate<String> isIncludeColumns = ConfigurableColumnPredicate.toPredicate(bindings, includeColumns, includeColumnsKey);
        Predicate<String> isExcludeColumns = ConfigurableColumnPredicate.toPredicate(bindings, excludeColumns, excludeColumnsKey);
        Predicate<String> isIncludeEmptyColumns = ConfigurableColumnPredicate.toPredicate(bindings, includeEmptyColumns, includeEmptyColumnsKey);
        includeAllEmpty = ConfigurableColumnPredicate.toBoolean(bindings, includeAllEmpty, includeAllEmptyKey);
        return new ConfigurableColumnPredicate(isIncludeColumns, isExcludeColumns, isIncludeEmptyColumns, includeAllEmpty);
    }

    public static ColumnPredicate of(Map<String, Object> bindings, io.polaris.core.jdbc.annotation.segment.ColumnPredicate predicate) {
        return ConfigurableColumnPredicate.of(bindings, predicate.includeColumns(), predicate.includeColumnsKey(), predicate.excludeColumns(), predicate.excludeColumnsKey(), predicate.includeEmptyColumns(), predicate.includeEmptyColumnsKey(), predicate.includeAllEmpty(), predicate.includeAllEmptyKey());
    }

    public static boolean toBoolean(Map<String, Object> bindings, boolean includeAllEmpty, String includeAllEmptyKey) {
        Object val;
        if (!includeAllEmpty && Strings.isNotBlank(includeAllEmptyKey) && (val = BindingValues.getBindingValueOrDefault(bindings, includeAllEmptyKey, null)) instanceof Boolean) {
            includeAllEmpty = (Boolean)val;
        }
        return includeAllEmpty;
    }

    public static boolean toBoolean(Map<String, Object> bindings, boolean includeAllEmpty, String[] includeAllEmptyKeys) {
        if (!includeAllEmpty && includeAllEmptyKeys != null) {
            for (String includeAllEmptyKey : includeAllEmptyKeys) {
                Object val;
                if (!Strings.isNotBlank(includeAllEmptyKey) || !((val = BindingValues.getBindingValueOrDefault(bindings, includeAllEmptyKey, null)) instanceof Boolean)) continue;
                includeAllEmpty = (Boolean)val;
                break;
            }
        }
        return includeAllEmpty;
    }

    public static Predicate<String> toPredicate(String[] columns) {
        if (columns == null || columns.length == 0) {
            return null;
        }
        Set<String> set = Iterables.asSet(columns);
        return set::contains;
    }

    public static Predicate<String> toPredicate(Map<String, Object> bindings, String[] columns, String columnsKey) {
        if (columns != null && columns.length > 0) {
            Set<String> set = Iterables.asSet(columns);
            return set::contains;
        }
        if (Strings.isNotBlank(columnsKey)) {
            Set set;
            Object val = BindingValues.getBindingValueOrDefault(bindings, columnsKey, null);
            if (val instanceof Set) {
                if (!((Set)val).isEmpty()) {
                    return ((Set)val)::contains;
                }
            } else if (val instanceof String[]) {
                if (((String[])val).length > 0) {
                    Set<String> set2 = Iterables.asSet(columns);
                    return set2::contains;
                }
            } else if (val instanceof Collection) {
                Set set3 = Iterables.asSet((Collection)val);
                if (!set3.isEmpty()) {
                    return set3::contains;
                }
            } else if (val instanceof Iterator && !(set = Iterables.asSet((Iterator)val)).isEmpty()) {
                return set::contains;
            }
        }
        return null;
    }

    public static Predicate<String> toPredicate(Map<String, Object> bindings, String[] columns, String[] columnsKeys) {
        if (columns != null && columns.length > 0) {
            Set<String> set = Iterables.asSet(columns);
            return set::contains;
        }
        if (columnsKeys != null) {
            for (String columnsKey : columnsKeys) {
                Set<Object> set;
                if (!Strings.isNotBlank(columnsKey)) continue;
                Object val = BindingValues.getBindingValueOrDefault(bindings, columnsKey, null);
                if (val instanceof Set) {
                    if (((Set)val).isEmpty()) continue;
                    return ((Set)val)::contains;
                }
                if (val instanceof String[]) {
                    if (((String[])val).length <= 0) continue;
                    set = Iterables.asSet(columns);
                    return set::contains;
                }
                if (!(val instanceof Iterable ? !(set = Iterables.asSet((Iterable)val)).isEmpty() : val instanceof Iterator && !(set = Iterables.asSet((Iterator)val)).isEmpty())) continue;
                return set::contains;
            }
        }
        return null;
    }

    @Override
    public boolean isIncludedColumn(String name) {
        if (this.isIncludeColumns != null && !this.isIncludeColumns.test(name)) {
            return false;
        }
        return this.isExcludeColumns == null || !this.isExcludeColumns.test(name);
    }

    @Override
    public boolean isIncludedEmptyColumn(String name) {
        return this.includeAllEmpty || this.isIncludeEmptyColumns != null && this.isIncludeEmptyColumns.test(name);
    }
}

