/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.expression;

import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.TextNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@FunctionalInterface
public interface Expression {
    public SqlNode toSqlNode(SqlNode var1, SqlNode[] var2, Map<String, Object> var3);

    default public SqlNode toSqlNode(SqlNode baseSource, SqlNode[] extSources, Object[] bindings) {
        if (bindings != null && bindings.length > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < bindings.length; ++i) {
                map.put(String.valueOf(i), bindings[i]);
            }
            return this.toSqlNode(baseSource, extSources, map);
        }
        return this.toSqlNode(baseSource, extSources, Collections.emptyMap());
    }

    default public SqlNode toSqlNode(String source) {
        return this.toSqlNode((SqlNode)new TextNode(source), null, Collections.emptyMap());
    }

    default public SqlNode toSqlNode(String source, Object[] bindings) {
        return this.toSqlNode((SqlNode)new TextNode(source), null, bindings);
    }

    default public SqlNode toSqlNode(String source, Map<String, Object> bindings) {
        return this.toSqlNode((SqlNode)new TextNode(source), null, bindings);
    }

    default public SqlNode toSqlNode(SqlNode source) {
        return this.toSqlNode(source, null, Collections.emptyMap());
    }

    default public SqlNode toSqlNode(SqlNode source, Object[] bindings) {
        return this.toSqlNode(source, null, bindings);
    }

    default public SqlNode toSqlNode(SqlNode source, Map<String, Object> bindings) {
        return this.toSqlNode(source, null, bindings);
    }
}

