/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.expression;

import io.polaris.core.function.FunctionWithArgs3;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.DynamicNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.statement.expression.BaseExpression;
import java.util.Map;
import java.util.function.Supplier;

public class LikeExpression
extends BaseExpression {
    public static final LikeExpression CONTAINS = new LikeExpression(true, true, false);
    public static final LikeExpression STARTS_WITH = new LikeExpression(true, false, false);
    public static final LikeExpression ENDS_WITH = new LikeExpression(false, true, false);
    public static final LikeExpression NOT_CONTAINS = new LikeExpression(true, true, true);
    public static final LikeExpression NOT_STARTS_WITH = new LikeExpression(true, false, true);
    public static final LikeExpression NOT_ENDS_WITH = new LikeExpression(false, true, true);
    private final boolean leftFuzzy;
    private final boolean rightFuzzy;
    private final boolean not;

    public LikeExpression(boolean leftFuzzy, boolean rightFuzzy, boolean not) {
        this.leftFuzzy = leftFuzzy;
        this.rightFuzzy = rightFuzzy;
        this.not = not;
    }

    private ContainerNode bind(SqlNode baseSource, SqlNode[] extSources, Supplier<CharSequence> getter) {
        ContainerNode container = new ContainerNode();
        container.addNode(baseSource);
        if (this.not) {
            container.addNode(SqlNodes.NOT);
        }
        container.addNode(SqlNodes.LIKE);
        DynamicNode varNode = new DynamicNode(this.nextVarName());
        StringBuilder val = new StringBuilder(getter.get());
        if (this.rightFuzzy && (val.length() == 0 || val.charAt(val.length() - 1) != '%')) {
            val.append('%');
        }
        if (this.leftFuzzy && (val.length() == 0 || val.charAt(0) != '%')) {
            val.insert(0, '%');
        }
        varNode.bindVarValue(val.toString());
        container.addNode(varNode);
        return container;
    }

    @Override
    protected FunctionWithArgs3<SqlNode, SqlNode[], Object[], ContainerNode> buildArrayFunction() {
        return (baseSource, extSources, bindings) -> this.bind((SqlNode)baseSource, (SqlNode[])extSources, () -> (CharSequence)(bindings == null || ((Object[])bindings).length == 0 ? null : bindings[0]));
    }

    @Override
    protected FunctionWithArgs3<SqlNode, SqlNode[], Map<String, Object>, ContainerNode> buildMapFunction() {
        return (baseSource, extSources, bindings) -> this.bind((SqlNode)baseSource, (SqlNode[])extSources, () -> bindings == null || bindings.isEmpty() ? null : bindings.values().iterator().next());
    }
}

