/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.expression;

import io.polaris.core.function.FunctionWithArgs3;
import io.polaris.core.jdbc.sql.BindingValues;
import io.polaris.core.jdbc.sql.SqlTextParsers;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.statement.expression.BaseExpression;
import io.polaris.core.regex.Patterns;
import io.polaris.core.string.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternExpression
extends BaseExpression {
    public static final String REF_PREFIX = "ref";
    public static final Pattern REF_PATTERN = Patterns.getPattern("^ref(\\d*)$");
    private final ContainerNode templateSqlNode;
    private final int argSize;
    private final Map<String, Integer> argsIndices = new HashMap<String, Integer>();
    private final int refExtSize;
    private final boolean refBaseExisted;
    private final Map<String, Integer> refIndices = new HashMap<String, Integer>();

    public PatternExpression(String pattern) {
        ContainerNode sqlNode = SqlTextParsers.parse(pattern);
        int[] argSize = new int[]{0};
        int[] refExtIdx = new int[]{-1};
        boolean[] hasRef0 = new boolean[]{false};
        sqlNode.visitSubsetWritable(op -> {
            SqlNode n = op.getSqlNode();
            if (n.isVarNode()) {
                String varName = n.getVarName();
                int idx = this.parseRefNode(varName);
                if (idx >= 0) {
                    refExtIdx[0] = Integer.max(refExtIdx[0], idx);
                    if (idx == 0) {
                        hasRef0[0] = true;
                    }
                } else {
                    argSize[0] = argSize[0] + 1;
                    this.argsIndices.put(n.getVarName(), argSize[0] - 1);
                }
            }
        });
        this.refBaseExisted = hasRef0[0];
        this.argSize = argSize[0];
        this.refExtSize = refExtIdx[0];
        this.templateSqlNode = sqlNode;
    }

    public static PatternExpression of(String pattern) {
        return new PatternExpression(pattern);
    }

    private int parseRefNode(String varName) {
        Matcher matcher;
        if (varName.startsWith(REF_PREFIX) && (matcher = REF_PATTERN.matcher(varName)).matches()) {
            String group = matcher.group(1);
            int idx = 0;
            if (Strings.isNotBlank(group)) {
                idx = Integer.parseInt(group);
            }
            this.refIndices.put(varName, idx);
            return idx;
        }
        return -1;
    }

    private ContainerNode bind(SqlNode baseSource, SqlNode[] extSources, Function<String, Object> getter) {
        if (this.refBaseExisted && baseSource == null) {
            return SqlNodes.EMPTY;
        }
        if (this.refExtSize > 0 && (extSources == null || extSources.length < this.refExtSize)) {
            return SqlNodes.EMPTY;
        }
        ContainerNode rs = this.createPatternSqlNode();
        if (this.refBaseExisted || this.refExtSize > 0 || this.argSize > 0) {
            rs.visitSubsetWritable(op -> {
                SqlNode n = op.getSqlNode();
                if (n.isVarNode()) {
                    String varName = n.getVarName();
                    Integer index = this.refIndices.get(varName);
                    if (index != null) {
                        int i = index;
                        SqlNode source = i == 0 ? baseSource : extSources[i - 1];
                        op.replace(source);
                    } else {
                        n.bindVarValue(this.wrapBinding(getter.apply(varName)));
                    }
                }
            });
        }
        return rs;
    }

    @Override
    protected FunctionWithArgs3<SqlNode, SqlNode[], Object[], ContainerNode> buildArrayFunction() {
        return (baseSource, extSources, bindings) -> this.bind((SqlNode)baseSource, (SqlNode[])extSources, varName -> {
            if (bindings == null) {
                return null;
            }
            Integer i = this.argsIndices.get(varName);
            return ((Object[])bindings).length <= i ? null : bindings[i];
        });
    }

    @Override
    protected FunctionWithArgs3<SqlNode, SqlNode[], Map<String, Object>, ContainerNode> buildMapFunction() {
        return (baseSource, extSources, bindings) -> this.bind((SqlNode)baseSource, (SqlNode[])extSources, varName -> bindings == null ? null : BindingValues.getBindingValueOrDefault(bindings, varName, null));
    }

    protected ContainerNode createPatternSqlNode() {
        return this.templateSqlNode.copy();
    }

    protected Object wrapBinding(Object v) {
        return v;
    }
}

