/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc.sql.statement.segment;

import io.polaris.core.annotation.AnnotationProcessing;
import io.polaris.core.jdbc.sql.SqlTextParsers;
import io.polaris.core.jdbc.sql.node.ContainerNode;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.node.SqlNodes;
import io.polaris.core.jdbc.sql.node.TextNode;
import io.polaris.core.jdbc.sql.statement.BaseSegment;
import io.polaris.core.jdbc.sql.statement.Segment;
import io.polaris.core.jdbc.sql.statement.SqlNodeBuilder;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessible;
import io.polaris.core.jdbc.sql.statement.segment.TableAccessibleHolder;
import io.polaris.core.jdbc.sql.statement.segment.TableSegment;
import io.polaris.core.reflect.GetterFunction;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;

@AnnotationProcessing
public class GroupBySegment<O extends Segment<O>, S extends GroupBySegment<O, S>>
extends BaseSegment<S>
implements SqlNodeBuilder {
    private final O owner;
    private final TableSegment<?> table;
    private final TableAccessible tableAccessible;
    private String field;
    private transient String _rawColumn;
    private SqlNode sql;

    @AnnotationProcessing
    public GroupBySegment(O owner, TableSegment<?> table) {
        this.owner = owner;
        this.table = table;
        this.tableAccessible = this.fetchTableAccessible();
    }

    private TableAccessible fetchTableAccessible() {
        if (this.owner instanceof TableAccessible) {
            return (TableAccessible)this.owner;
        }
        if (this.owner instanceof TableAccessibleHolder) {
            return ((TableAccessibleHolder)this.owner).getTableAccessible();
        }
        return null;
    }

    @Override
    public SqlNode toSqlNode() {
        if (this.sql != null) {
            return this.sql;
        }
        String column = this.column();
        if (Strings.isBlank(column)) {
            return SqlNodes.EMPTY;
        }
        ContainerNode sql = new ContainerNode();
        sql.addNode(new TextNode(column));
        return sql;
    }

    private String column() {
        if (Strings.isNotBlank(this._rawColumn)) {
            return this._rawColumn;
        }
        if (this.table == null || Strings.isBlank(this.field)) {
            return "";
        }
        this._rawColumn = this.table.getColumnExpression(this.field);
        return this._rawColumn;
    }

    public O end() {
        return this.owner;
    }

    public <T, R> S column(GetterFunction<T, R> getter) {
        return this.column(Reflects.getPropertyName(getter));
    }

    @AnnotationProcessing
    public S column(String field) {
        this.field = field;
        return (S)((GroupBySegment)this.getThis());
    }

    public S sql(SqlNode sql) {
        this.sql = sql;
        return (S)((GroupBySegment)this.getThis());
    }

    public S rawColumn(String rawColumn) {
        this._rawColumn = rawColumn = SqlTextParsers.resolveTableRef(rawColumn, this.tableAccessible);
        return (S)((GroupBySegment)this.getThis());
    }

    public TableSegment<?> getTable() {
        return this.table;
    }
}

