/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.annotation;

import io.polaris.core.lang.annotation.Alias;
import io.polaris.core.lang.annotation.AnnotationAttributes;
import io.polaris.core.lang.annotation.MatchedMergedAnnotation;
import io.polaris.core.lang.annotation.MergedAnnotation;
import io.polaris.core.tuple.Tuple2;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;

class MergedAnnotations {
    private SortedMap<Integer, Set<MergedAnnotation>> sortedAnnotations = new TreeMap<Integer, Set<MergedAnnotation>>();

    public MergedAnnotations(AnnotatedElement element) {
        this.scanAnnotations(0, element);
    }

    public static MergedAnnotations of(AnnotatedElement element) {
        return new MergedAnnotations(element);
    }

    static SortedMap<Integer, Set<MergedAnnotation>> scanHierarchyAnnotations(MergedAnnotation annotation) {
        TreeMap<Integer, Set<MergedAnnotation>> hierarchyAnnotations = new TreeMap<Integer, Set<MergedAnnotation>>();
        HashSet<Class<? extends Annotation>> visitedAnnotation = new HashSet<Class<? extends Annotation>>();
        Collection<MergedAnnotation> candidates = Collections.singletonList(annotation);
        while (!candidates.isEmpty()) {
            candidates = MergedAnnotations.scanHierarchyAnnotation(hierarchyAnnotations, candidates, visitedAnnotation);
        }
        return hierarchyAnnotations;
    }

    private static void addHierarchyAnnotation(SortedMap<Integer, Set<MergedAnnotation>> hierarchyAnnotations, MergedAnnotation mergedAnnotation) {
        Set annotations = hierarchyAnnotations.computeIfAbsent(mergedAnnotation.getDistance(), k -> new LinkedHashSet());
        annotations.add(mergedAnnotation);
    }

    private static Collection<MergedAnnotation> scanHierarchyAnnotation(SortedMap<Integer, Set<MergedAnnotation>> hierarchyAnnotations, Collection<MergedAnnotation> lastCandidates, Set<Class<? extends Annotation>> visited) {
        LinkedHashSet<MergedAnnotation> candidates = new LinkedHashSet<MergedAnnotation>();
        for (MergedAnnotation mergedAnnotation : lastCandidates) {
            Class<? extends Annotation> annotationType = mergedAnnotation.getAnnotationType();
            if (annotationType.getPackage().getName().equals("java.lang.annotation") || visited.contains(annotationType)) continue;
            visited.add(annotationType);
            if (!mergedAnnotation.isRepeatable()) {
                Method[] annotationMembers = AnnotationAttributes.getAnnotationMembers(annotationType);
                LinkedHashMap<Class, Map> aliasMap = new LinkedHashMap<Class, Map>();
                for (Method method : annotationMembers) {
                    Alias alias = method.getAnnotation(Alias.class);
                    if (alias == null || alias.annotation() == annotationType || alias.annotation() == Alias.DEFAULT_ANNOTATION) continue;
                    Map aliasMethods = aliasMap.computeIfAbsent(alias.annotation(), k -> new LinkedHashMap());
                    aliasMethods.put(alias.value(), method);
                }
                if (!aliasMap.isEmpty()) {
                    for (Map.Entry entry : aliasMap.entrySet()) {
                        Class aliasAnnotationType = (Class)entry.getKey();
                        Map aliasMethods = (Map)entry.getValue();
                        MergedAnnotation aliasMergeAnnotation = MergedAnnotation.of(mergedAnnotation.getDistance() + 1, annotationType, aliasAnnotationType, mergedAnnotation, aliasMethods);
                        MergedAnnotations.addHierarchyAnnotation(hierarchyAnnotations, aliasMergeAnnotation);
                        candidates.add(aliasMergeAnnotation);
                    }
                }
            }
            for (Annotation annotation : annotationType.getAnnotations()) {
                MergedAnnotation relation = MergedAnnotation.of(mergedAnnotation.getDistance() + 1, annotationType, annotation);
                MergedAnnotations.addHierarchyAnnotation(hierarchyAnnotations, relation);
                candidates.add(relation);
            }
        }
        return candidates;
    }

    @Nullable
    public <A extends Annotation> A getMergedAnnotation(Class<A> annotationType) {
        MergedAnnotation matchedOne = null;
        ArrayList<MergedAnnotation> aliasList = new ArrayList<MergedAnnotation>();
        block0: for (Map.Entry<Integer, Set<MergedAnnotation>> entry : this.sortedAnnotations.entrySet()) {
            Set<MergedAnnotation> set = entry.getValue();
            for (MergedAnnotation annotation : set) {
                MatchedMergedAnnotation<A> matchedAnnotation = annotation.getMatchedAnnotation(annotationType);
                if (matchedAnnotation == null) continue;
                MergedAnnotation matched = matchedAnnotation.getMatched();
                if (matched != null) {
                    matchedOne = matched;
                    break block0;
                }
                aliasList.addAll(matchedAnnotation.getAliases());
            }
        }
        if (matchedOne == null && aliasList.isEmpty()) {
            return null;
        }
        return MatchedMergedAnnotation.of(annotationType, matchedOne, aliasList).getAnnotation();
    }

    public <A extends Annotation> Set<A> getMergedRepeatableAnnotation(Class<A> annotationType) {
        Set<MatchedMergedAnnotation<A>> matchedSet = null;
        block0: for (Map.Entry<Integer, Set<MergedAnnotation>> entry : this.sortedAnnotations.entrySet()) {
            Set<MergedAnnotation> set = entry.getValue();
            for (MergedAnnotation annotation : set) {
                matchedSet = annotation.getMatchedRepeatableAnnotation(annotationType);
                if (matchedSet == null) continue;
                break block0;
            }
        }
        if (matchedSet == null) {
            return Collections.emptySet();
        }
        LinkedHashSet annotationSet = new LinkedHashSet();
        for (MatchedMergedAnnotation matchedMergedAnnotation : matchedSet) {
            annotationSet.add(matchedMergedAnnotation.getAnnotation());
        }
        return annotationSet;
    }

    private void addMergedAnnotation(MergedAnnotation mergedAnnotation) {
        Set annotations = this.sortedAnnotations.computeIfAbsent(mergedAnnotation.getDistance(), k -> new LinkedHashSet());
        annotations.add(mergedAnnotation);
    }

    private void scanAnnotations(int distance, AnnotatedElement element) {
        Executable executable;
        Annotation[] annotations;
        LinkedHashSet<MergedAnnotation> first = new LinkedHashSet<MergedAnnotation>();
        for (Annotation annotation : annotations = element.getAnnotations()) {
            MergedAnnotation mergedAnnotation = MergedAnnotation.of(distance, element, annotation);
            first.add(mergedAnnotation);
            this.addMergedAnnotation(mergedAnnotation);
        }
        if (element instanceof Class) {
            this.scanHierarchyClass(distance + 1, (Class)element);
        } else if (element instanceof Method) {
            this.scanHierarchyMethod(distance + 1, (Method)element);
        } else if (element instanceof Parameter && (executable = ((Parameter)element).getDeclaringExecutable()) instanceof Method) {
            Parameter[] parameters = executable.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] != element) continue;
                this.scanHierarchyParameter(distance + 1, (Parameter)element, (Method)executable, i);
            }
        }
    }

    private Tuple2<Class<?>, Class<?>[]> getHierarchyClassCandidates(Class<?> superclass, Class<?>[] interfaces, Set<Class<?>> visitedClass) {
        LinkedHashSet candidates = new LinkedHashSet();
        if (interfaces == null) {
            if (superclass != null && superclass != Object.class) {
                for (Class<?> anInterface : interfaces = superclass.getInterfaces()) {
                    candidates.add(anInterface);
                    visitedClass.add(anInterface);
                }
            }
            superclass = superclass.getSuperclass();
            return Tuple2.of(superclass, candidates.toArray(new Class[0]));
        }
        if (superclass != null && superclass != Object.class) {
            for (Class<?> anInterface : superclass.getInterfaces()) {
                if (visitedClass.contains(anInterface)) continue;
                candidates.add(anInterface);
                visitedClass.add(anInterface);
            }
            superclass = superclass.getSuperclass();
        }
        for (Class<?> anInterface : interfaces) {
            for (Class<?> anInterfaceInterface : anInterface.getInterfaces()) {
                if (visitedClass.contains(anInterfaceInterface)) continue;
                candidates.add(anInterfaceInterface);
                visitedClass.add(anInterfaceInterface);
            }
        }
        return Tuple2.of(superclass, candidates.toArray(new Class[0]));
    }

    private void scanHierarchyClass(int distance, Class<?> element) {
        LinkedHashSet visitedClass = new LinkedHashSet();
        Tuple2<Class<?>, Class<?>[]> classCandidates = this.getHierarchyClassCandidates(element, null, visitedClass);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return;
        }
        int nextDistance = distance;
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                this.scanAnnotations(nextDistance, superclass);
            }
            for (Class<?> anInterface : interfaces) {
                this.scanAnnotations(nextDistance, anInterface);
            }
            ++nextDistance;
            classCandidates = this.getHierarchyClassCandidates(superclass, interfaces, visitedClass);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
    }

    private void scanHierarchyMethod(int distance, Method element) {
        Class<?> declaringClass = element.getDeclaringClass();
        LinkedHashSet visited = new LinkedHashSet();
        Tuple2<Class<?>, Class<?>[]> classCandidates = this.getHierarchyClassCandidates(declaringClass, null, visited);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return;
        }
        int nextDistance = distance;
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                try {
                    Method method = superclass.getDeclaredMethod(element.getName(), element.getParameterTypes());
                    this.scanAnnotations(nextDistance, method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Class<?> anInterface : interfaces) {
                try {
                    Method method = anInterface.getDeclaredMethod(element.getName(), element.getParameterTypes());
                    this.scanAnnotations(nextDistance, method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            ++nextDistance;
            classCandidates = this.getHierarchyClassCandidates(superclass, interfaces, visited);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
    }

    private void scanHierarchyParameter(int distance, Parameter element, Method declaringMethod, int position) {
        Class<?> declaringClass = declaringMethod.getDeclaringClass();
        LinkedHashSet visited = new LinkedHashSet();
        Tuple2<Class<?>, Class<?>[]> classCandidates = this.getHierarchyClassCandidates(declaringClass, null, visited);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return;
        }
        int nextDistance = distance;
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                try {
                    Parameter parameter = superclass.getDeclaredMethod(declaringMethod.getName(), declaringMethod.getParameterTypes()).getParameters()[position];
                    this.scanAnnotations(nextDistance, parameter);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Class<?> anInterface : interfaces) {
                try {
                    Parameter parameter = anInterface.getDeclaredMethod(declaringMethod.getName(), declaringMethod.getParameterTypes()).getParameters()[position];
                    this.scanAnnotations(nextDistance, parameter);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            ++nextDistance;
            classCandidates = this.getHierarchyClassCandidates(superclass, interfaces, visited);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
    }

    public SortedMap<Integer, Set<MergedAnnotation>> getSortedAnnotations() {
        return Collections.unmodifiableSortedMap(this.sortedAnnotations);
    }
}

