/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.annotation;

import io.polaris.core.tuple.Tuple2;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

class RawAnnotations {
    RawAnnotations() {
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationType) {
        Executable executable;
        A rs = element.getAnnotation(annotationType);
        if (rs != null) {
            return rs;
        }
        rs = RawAnnotations.seekByHierarchyAnnotation(element, annotationType);
        if (rs != null) {
            return rs;
        }
        if (element instanceof Class) {
            rs = RawAnnotations.seekByHierarchyClass((Class)element, annotationType);
            return rs;
        }
        if (element instanceof Method) {
            return RawAnnotations.seekByHierarchyMethod((Method)element, annotationType);
        }
        if (element instanceof Parameter && (executable = ((Parameter)element).getDeclaringExecutable()) instanceof Method) {
            Parameter[] parameters = executable.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] != element) continue;
                return RawAnnotations.seekByHierarchyParameter((Parameter)element, (Method)executable, i, annotationType);
            }
        }
        return null;
    }

    private static <A extends Annotation> A seekByHierarchyAnnotation(AnnotatedElement element, Class<A> annotationType) {
        HashSet<AnnotatedElement> visited = new HashSet<AnnotatedElement>();
        AnnotatedElement[] candidates = RawAnnotations.getHierarchyAnnotationCandidates(new AnnotatedElement[]{element}, visited);
        while (candidates.length > 0) {
            for (AnnotatedElement candidate : candidates) {
                A rs = candidate.getAnnotation(annotationType);
                if (rs == null) continue;
                return rs;
            }
            candidates = RawAnnotations.getHierarchyAnnotationCandidates(candidates, visited);
        }
        return null;
    }

    private static <A extends Annotation> A seekByHierarchyClass(Class<?> element, Class<A> annotationType) {
        LinkedHashSet<AnnotatedElement> visited = new LinkedHashSet<AnnotatedElement>();
        Tuple2<Class<?>, Class<?>[]> classCandidates = RawAnnotations.getHierarchyClassCandidates(element, null, visited);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return null;
        }
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                A rs = superclass.getAnnotation(annotationType);
                if (rs != null) {
                    return rs;
                }
                rs = RawAnnotations.seekByHierarchyAnnotation(superclass, annotationType);
                if (rs != null) {
                    return rs;
                }
            }
            for (Class<?> anInterface : interfaces) {
                A rs = anInterface.getAnnotation(annotationType);
                if (rs != null) {
                    return rs;
                }
                rs = RawAnnotations.seekByHierarchyAnnotation(anInterface, annotationType);
                if (rs == null) continue;
                return rs;
            }
            classCandidates = RawAnnotations.getHierarchyClassCandidates(superclass, interfaces, visited);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
        return null;
    }

    private static <A extends Annotation> A seekByHierarchyMethod(Method element, Class<A> annotationType) {
        Class<?> declaringClass = element.getDeclaringClass();
        LinkedHashSet<AnnotatedElement> visited = new LinkedHashSet<AnnotatedElement>();
        Tuple2<Class<?>, Class<?>[]> classCandidates = RawAnnotations.getHierarchyClassCandidates(declaringClass, null, visited);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return null;
        }
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                try {
                    Method method = superclass.getDeclaredMethod(element.getName(), element.getParameterTypes());
                    A rs = method.getAnnotation(annotationType);
                    if (rs != null) {
                        return rs;
                    }
                    rs = RawAnnotations.seekByHierarchyAnnotation(method, annotationType);
                    if (rs != null) {
                        return rs;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Class<?> anInterface : interfaces) {
                try {
                    Method method = anInterface.getDeclaredMethod(element.getName(), element.getParameterTypes());
                    A rs = method.getAnnotation(annotationType);
                    if (rs != null) {
                        return rs;
                    }
                    rs = RawAnnotations.seekByHierarchyAnnotation(method, annotationType);
                    if (rs == null) continue;
                    return rs;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            classCandidates = RawAnnotations.getHierarchyClassCandidates(superclass, interfaces, visited);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
        return null;
    }

    private static <A extends Annotation> A seekByHierarchyParameter(Parameter element, Method declaringMethod, int position, Class<A> annotationType) {
        Class<?> declaringClass = declaringMethod.getDeclaringClass();
        LinkedHashSet<AnnotatedElement> visited = new LinkedHashSet<AnnotatedElement>();
        Tuple2<Class<?>, Class<?>[]> classCandidates = RawAnnotations.getHierarchyClassCandidates(declaringClass, null, visited);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return null;
        }
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                try {
                    Parameter parameter = superclass.getDeclaredMethod(declaringMethod.getName(), declaringMethod.getParameterTypes()).getParameters()[position];
                    A rs = parameter.getAnnotation(annotationType);
                    if (rs != null) {
                        return rs;
                    }
                    rs = RawAnnotations.seekByHierarchyAnnotation(parameter, annotationType);
                    if (rs != null) {
                        return rs;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Class<?> anInterface : interfaces) {
                try {
                    Parameter parameter = anInterface.getDeclaredMethod(declaringMethod.getName(), declaringMethod.getParameterTypes()).getParameters()[position];
                    A rs = parameter.getAnnotation(annotationType);
                    if (rs != null) {
                        return rs;
                    }
                    rs = RawAnnotations.seekByHierarchyAnnotation(parameter, annotationType);
                    if (rs == null) continue;
                    return rs;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            classCandidates = RawAnnotations.getHierarchyClassCandidates(superclass, interfaces, visited);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
        return null;
    }

    private static AnnotatedElement[] getHierarchyAnnotationCandidates(AnnotatedElement[] candidates, Set<AnnotatedElement> visited) {
        LinkedHashSet<Class<? extends Annotation>> candidateSet = new LinkedHashSet<Class<? extends Annotation>>();
        for (AnnotatedElement candidate : candidates) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = candidate.getAnnotations()) {
                Class<? extends Annotation> type = annotation.annotationType();
                if (visited.contains(type)) continue;
                candidateSet.add(type);
                visited.add(type);
            }
        }
        candidates = candidateSet.toArray(new AnnotatedElement[0]);
        candidateSet.clear();
        return candidates;
    }

    private static Tuple2<Class<?>, Class<?>[]> getHierarchyClassCandidates(Class<?> superclass, Class<?>[] interfaces, Set<AnnotatedElement> visited) {
        LinkedHashSet candidates = new LinkedHashSet();
        if (interfaces == null) {
            if (superclass != null && superclass != Object.class) {
                for (Class<?> anInterface : interfaces = superclass.getInterfaces()) {
                    candidates.add(anInterface);
                    visited.add(anInterface);
                }
            }
            superclass = superclass.getSuperclass();
            return Tuple2.of(superclass, candidates.toArray(new Class[0]));
        }
        if (superclass != null && superclass != Object.class) {
            for (Class<?> anInterface : superclass.getInterfaces()) {
                if (visited.contains(anInterface)) continue;
                candidates.add(anInterface);
                visited.add(anInterface);
            }
            superclass = superclass.getSuperclass();
        }
        for (Class<?> anInterface : interfaces) {
            for (Class<?> anInterfaceInterface : anInterface.getInterfaces()) {
                if (visited.contains(anInterfaceInterface)) continue;
                candidates.add(anInterfaceInterface);
                visited.add(anInterfaceInterface);
            }
        }
        return Tuple2.of(superclass, candidates.toArray(new Class[0]));
    }

    public static <A extends Annotation> A[] getRepeatableAnnotation(AnnotatedElement element, Class<A> annotationType) {
        Annotation[] rs = element.getAnnotationsByType(annotationType);
        if (rs.length == 0) {
            Executable executable;
            Annotation[] arr = RawAnnotations.seekRepeatableByHierarchyAnnotation((AnnotatedElement)element, annotationType);
            if (arr != null && arr.length > 0) {
                return arr;
            }
            if (element instanceof Class) {
                arr = RawAnnotations.seekRepeatableByHierarchyClass((Class)((Class)element), annotationType);
                if (arr != null && arr.length > 0) {
                    return arr;
                }
            } else if (element instanceof Method) {
                arr = RawAnnotations.seekRepeatableByHierarchyMethod((Method)((Method)element), annotationType);
                if (arr != null && arr.length > 0) {
                    return arr;
                }
            } else if (element instanceof Parameter && (executable = ((Parameter)element).getDeclaringExecutable()) instanceof Method) {
                Parameter[] parameters = executable.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i] != element) continue;
                    Annotation[] arr2 = RawAnnotations.seekRepeatableByHierarchyParameter((Parameter)((Parameter)element), (Method)((Method)executable), (int)i, annotationType);
                    if (arr2 == null || arr2.length <= 0) break;
                    return arr2;
                }
            }
        }
        return rs;
    }

    private static <A extends Annotation> A[] seekRepeatableByHierarchyAnnotation(AnnotatedElement element, Class<A> annotationType) {
        HashSet<AnnotatedElement> visited = new HashSet<AnnotatedElement>();
        AnnotatedElement[] candidates = RawAnnotations.getHierarchyAnnotationCandidates(new AnnotatedElement[]{element}, visited);
        while (candidates.length > 0) {
            for (AnnotatedElement candidate : candidates) {
                Annotation[] rs = candidate.getAnnotationsByType(annotationType);
                if (rs.length <= 0) continue;
                return rs;
            }
            candidates = RawAnnotations.getHierarchyAnnotationCandidates(candidates, visited);
        }
        return null;
    }

    private static <A extends Annotation> A[] seekRepeatableByHierarchyClass(Class<?> element, Class<A> annotationType) {
        LinkedHashSet<AnnotatedElement> visited = new LinkedHashSet<AnnotatedElement>();
        Tuple2<Class<?>, Class<?>[]> classCandidates = RawAnnotations.getHierarchyClassCandidates(element, null, visited);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return null;
        }
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                Annotation[] rs = superclass.getAnnotationsByType(annotationType);
                if (rs != null && rs.length > 0) {
                    return rs;
                }
                rs = RawAnnotations.seekRepeatableByHierarchyAnnotation(superclass, annotationType);
                if (rs != null && rs.length > 0) {
                    return rs;
                }
            }
            for (Class<?> anInterface : interfaces) {
                Annotation[] rs = anInterface.getAnnotationsByType(annotationType);
                if (rs != null && rs.length > 0) {
                    return rs;
                }
                rs = RawAnnotations.seekRepeatableByHierarchyAnnotation(anInterface, annotationType);
                if (rs == null || rs.length <= 0) continue;
                return rs;
            }
            classCandidates = RawAnnotations.getHierarchyClassCandidates(superclass, interfaces, visited);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
        return null;
    }

    private static <A extends Annotation> A[] seekRepeatableByHierarchyMethod(Method element, Class<A> annotationType) {
        Class<?> declaringClass = element.getDeclaringClass();
        LinkedHashSet<AnnotatedElement> visited = new LinkedHashSet<AnnotatedElement>();
        Tuple2<Class<?>, Class<?>[]> classCandidates = RawAnnotations.getHierarchyClassCandidates(declaringClass, null, visited);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return null;
        }
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                try {
                    Method method = superclass.getDeclaredMethod(element.getName(), element.getParameterTypes());
                    Annotation[] rs = method.getAnnotationsByType(annotationType);
                    if (rs != null && rs.length > 0) {
                        return rs;
                    }
                    rs = RawAnnotations.seekRepeatableByHierarchyAnnotation((AnnotatedElement)method, annotationType);
                    if (rs != null && rs.length > 0) {
                        return rs;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Class<?> anInterface : interfaces) {
                try {
                    Method method = anInterface.getDeclaredMethod(element.getName(), element.getParameterTypes());
                    Annotation[] rs = method.getAnnotationsByType(annotationType);
                    if (rs != null && rs.length > 0) {
                        return rs;
                    }
                    rs = RawAnnotations.seekRepeatableByHierarchyAnnotation((AnnotatedElement)method, annotationType);
                    if (rs == null || rs.length <= 0) continue;
                    return rs;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            classCandidates = RawAnnotations.getHierarchyClassCandidates(superclass, interfaces, visited);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
        return null;
    }

    private static <A extends Annotation> A[] seekRepeatableByHierarchyParameter(Parameter element, Method declaringMethod, int position, Class<A> annotationType) {
        Class<?> declaringClass = declaringMethod.getDeclaringClass();
        LinkedHashSet<AnnotatedElement> visited = new LinkedHashSet<AnnotatedElement>();
        Tuple2<Class<?>, Class<?>[]> classCandidates = RawAnnotations.getHierarchyClassCandidates(declaringClass, null, visited);
        Class<?> superclass = classCandidates.getFirst();
        Class<?>[] interfaces = classCandidates.getSecond();
        if ((superclass == null || superclass == Object.class) && interfaces.length == 0) {
            return null;
        }
        while (superclass != null && superclass != Object.class || interfaces.length > 0) {
            if (superclass != null && superclass != Object.class) {
                try {
                    Parameter parameter = superclass.getDeclaredMethod(declaringMethod.getName(), declaringMethod.getParameterTypes()).getParameters()[position];
                    Annotation[] rs = parameter.getAnnotationsByType(annotationType);
                    if (rs != null && rs.length > 0) {
                        return rs;
                    }
                    rs = RawAnnotations.seekRepeatableByHierarchyAnnotation((AnnotatedElement)parameter, annotationType);
                    if (rs != null && rs.length > 0) {
                        return rs;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Class<?> anInterface : interfaces) {
                try {
                    Parameter parameter = anInterface.getDeclaredMethod(declaringMethod.getName(), declaringMethod.getParameterTypes()).getParameters()[position];
                    Annotation[] rs = parameter.getAnnotationsByType(annotationType);
                    if (rs != null && rs.length > 0) {
                        return rs;
                    }
                    rs = RawAnnotations.seekRepeatableByHierarchyAnnotation((AnnotatedElement)parameter, annotationType);
                    if (rs == null || rs.length <= 0) continue;
                    return rs;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            classCandidates = RawAnnotations.getHierarchyClassCandidates(superclass, interfaces, visited);
            superclass = classCandidates.getFirst();
            interfaces = classCandidates.getSecond();
        }
        return null;
    }
}

