/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.lang.bean.property;

import io.polaris.core.lang.bean.Beans;
import io.polaris.core.lang.bean.property.AbstractPropertyBuilder;
import io.polaris.core.lang.bean.property.PropertyBuilder;

public class StdPropertyBuilder<T>
extends AbstractPropertyBuilder<T>
implements PropertyBuilder<T> {
    private final T dest;

    public StdPropertyBuilder(T dest) {
        this.dest = dest;
    }

    public StdPropertyBuilder(Class<T> clazz) {
        try {
            this.dest = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public StdPropertyBuilder(Object orig, T dest) {
        this(dest);
        this.from(orig);
    }

    @Override
    public void exec(AbstractPropertyBuilder.Operation operation) {
        Object orig = operation.orig;
        if (orig != null) {
            Object val = Beans.getPathProperty(orig, operation.origProperty);
            if (val != null || !operation.ignoredNull) {
                Beans.setPathProperty(this.dest, operation.destProperty, val);
            }
        } else if (operation.propertyValue != null || !operation.ignoredNull) {
            Beans.setPathProperty(this.dest, operation.destProperty, operation.propertyValue);
        }
    }

    @Override
    public T done() {
        this.exec();
        return this.dest;
    }
}

