/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import java.util.LinkedHashMap;
import java.util.Map;

public class LimitedLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private int maxCapacity = 0;

    public LimitedLinkedHashMap(int maxCapacity) {
        this(maxCapacity, false);
    }

    public LimitedLinkedHashMap(int maxCapacity, boolean accessOrder) {
        this(maxCapacity, accessOrder, 128, 0.75f);
    }

    public LimitedLinkedHashMap(int maxCapacity, boolean accessOrder, int initialCapacity) {
        this(maxCapacity, accessOrder, initialCapacity, 0.75f);
    }

    public LimitedLinkedHashMap(int maxCapacity, boolean accessOrder, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxCapacity = maxCapacity;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxCapacity;
    }
}

