/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import io.polaris.core.map.BaseMultiMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class SetMultiMap<K, V>
extends BaseMultiMap<K, V, Set<V>> {
    public SetMultiMap(Map<K, Set<V>> raw, Supplier<Set<V>> supplier) {
        super(raw, supplier);
    }

    public SetMultiMap(Map<K, Set<V>> raw) {
        super(raw, HashSet::new);
    }

    public SetMultiMap(Supplier<Set<V>> supplier) {
        super(new HashMap(), supplier);
    }

    public SetMultiMap() {
        super(new HashMap(), HashSet::new);
    }

    @Override
    public V getOne(Object key) {
        Set c = (Set)this.get(key);
        if (c == null || c.isEmpty()) {
            return null;
        }
        return (V)c.iterator().next();
    }

    @Override
    public Set<V> putOne(K key, V value) {
        Set c = (Set)this.get(key);
        if (c == null) {
            c = (Set)this.supplier.get();
            this.put(key, c);
        }
        c.add(value);
        return c;
    }
}

