/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class TransformMap<K, V>
implements Map<K, V> {
    private final Map<K, V> raw;
    private final Function<Object, K> keyTransformer;
    private final Function<Object, V> valueTransformer;

    public TransformMap(Supplier<Map<K, V>> supplier) {
        this.raw = supplier.get();
        this.keyTransformer = null;
        this.valueTransformer = null;
    }

    public TransformMap(Map<K, V> raw) {
        this.raw = raw;
        this.keyTransformer = null;
        this.valueTransformer = null;
    }

    public TransformMap(Supplier<Map<K, V>> supplier, Function<Object, K> keyTransformer) {
        this.raw = supplier.get();
        this.keyTransformer = keyTransformer;
        this.valueTransformer = null;
    }

    public TransformMap(Map<K, V> raw, Function<Object, K> keyTransformer) {
        this.raw = raw;
        this.keyTransformer = keyTransformer;
        this.valueTransformer = null;
    }

    public TransformMap(Supplier<Map<K, V>> supplier, Function<Object, K> keyTransformer, Function<Object, V> valueTransformer) {
        this.raw = supplier.get();
        this.keyTransformer = keyTransformer;
        this.valueTransformer = valueTransformer;
    }

    public TransformMap(Map<K, V> raw, Function<Object, K> keyTransformer, Function<Object, V> valueTransformer) {
        this.raw = raw;
        this.keyTransformer = keyTransformer;
        this.valueTransformer = valueTransformer;
    }

    protected K transformKey(Object key) {
        return (K)(this.keyTransformer == null ? key : this.keyTransformer.apply(key));
    }

    protected V transformValue(Object value) {
        return (V)(this.valueTransformer == null ? value : this.valueTransformer.apply(value));
    }

    public String toString() {
        return this.raw.toString();
    }

    @Override
    public int size() {
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.raw.containsKey(this.transformKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.raw.containsValue(this.transformValue(value));
    }

    @Override
    public V get(Object key) {
        return this.raw.get(this.transformKey(key));
    }

    @Override
    public V put(K key, V value) {
        return this.raw.put(this.transformKey(key), this.transformValue(value));
    }

    @Override
    public V remove(Object key) {
        return this.raw.remove(this.transformKey(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.raw.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.raw.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.raw.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.raw.entrySet();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.raw.getOrDefault(this.transformKey(key), this.transformValue(defaultValue));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.raw.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.raw.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.raw.putIfAbsent(this.transformKey(key), this.transformValue(value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.raw.remove(this.transformKey(key), this.transformValue(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.raw.replace(this.transformKey(key), this.transformValue(oldValue), this.transformValue(newValue));
    }

    @Override
    public V replace(K key, V value) {
        return this.raw.replace(this.transformKey(key), this.transformValue(value));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.raw.computeIfAbsent((K)this.transformKey(key), mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.raw.computeIfPresent((K)this.transformKey(key), (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.raw.compute((K)this.transformKey(key), (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.raw.merge(this.transformKey(key), (V)this.transformValue(value), (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }
}

