/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.msg;

import io.polaris.core.msg.AggregateResourceBundles;
import io.polaris.core.msg.MemoryResourceBundle;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;

public class MessageResource {
    private final String baseName;
    private final Map<Locale, MemoryResourceBundle> cache = new ConcurrentHashMap<Locale, MemoryResourceBundle>();

    public MessageResource(String ... baseNames) {
        this(AggregateResourceBundles.aggregateNames(baseNames));
    }

    public MessageResource(String baseName) {
        this.baseName = baseName;
    }

    public MemoryResourceBundle getBundle(Locale locale) {
        return this.cache.computeIfAbsent(locale, k -> {
            MemoryResourceBundle bundle = new MemoryResourceBundle(this.baseName, locale);
            bundle.setParent(AggregateResourceBundles.getBundle(this.baseName, locale));
            return bundle;
        });
    }

    public String getMessageOrDefault(String code, String defaults, Locale locale, Object ... params) {
        MemoryResourceBundle bundle = this.getBundle(locale);
        String val = null;
        try {
            val = bundle.getString(code);
        }
        catch (MissingResourceException e) {
            val = defaults;
        }
        if (val == null) {
            return val;
        }
        if (params.length == 0) {
            return val;
        }
        return MessageFormat.format(val, params);
    }

    public String getMessage(String code, Object ... params) {
        return this.getMessageOrDefault(code, "", Locale.getDefault(), params);
    }

    public String getMessageOrDefault(String code, String defaults, Object ... params) {
        return this.getMessageOrDefault(code, defaults, Locale.getDefault(), params);
    }
}

